/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MavenLocationComponent
extends Composite {
    protected Button inWorkspaceButton;
    protected Button inExternalLocationButton;
    protected Combo locationCombo;
    protected Button locationBrowseButton;
    protected ModifyListener modifyingListener;
    protected Label locationLabel;

    public MavenLocationComponent(Composite parent, int styles) {
        super(parent, styles);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        Group locationGroup = new Group((Composite)this, 0);
        locationGroup.setText(Messages.locationComponentLocation);
        locationGroup.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 3;
        groupLayout.marginLeft = 0;
        locationGroup.setLayout((Layout)groupLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.inWorkspaceButton = new Button((Composite)locationGroup, 16);
        this.inWorkspaceButton.setText(Messages.locationComponentInWorkspace);
        this.inWorkspaceButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.inWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isEnabled = !MavenLocationComponent.this.inWorkspaceButton.getSelection();
                MavenLocationComponent.this.locationLabel.setEnabled(isEnabled);
                MavenLocationComponent.this.locationCombo.setEnabled(isEnabled);
                MavenLocationComponent.this.locationBrowseButton.setEnabled(isEnabled);
                if (MavenLocationComponent.this.modifyingListener != null) {
                    MavenLocationComponent.this.modifyingListener.modifyText(null);
                }
            }
        });
        this.inExternalLocationButton = new Button((Composite)locationGroup, 16);
        this.inExternalLocationButton.setText(Messages.locationComponentAtExternal);
        this.inExternalLocationButton.setLayoutData((Object)gridData);
        this.locationLabel = new Label((Composite)locationGroup, 0);
        GridData gd_locationLabel = new GridData();
        gd_locationLabel.horizontalIndent = 10;
        this.locationLabel.setLayoutData((Object)gd_locationLabel);
        this.locationLabel.setText(Messages.locationComponentDirectory);
        this.locationCombo = new Combo((Composite)locationGroup, 2048);
        this.locationCombo.setLayoutData((Object)new GridData(768));
        this.locationBrowseButton = new Button((Composite)locationGroup, 8);
        this.locationBrowseButton.setText(Messages.locationComponentBrowse);
        gridData = new GridData(4, -1, false, false);
        this.locationBrowseButton.setLayoutData((Object)gridData);
        this.locationBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(MavenLocationComponent.this.getShell());
                dialog.setText(Messages.locationComponentSelectLocation);
                String path = MavenLocationComponent.this.locationCombo.getText();
                if (path.length() == 0) {
                    path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toPortableString();
                }
                dialog.setFilterPath(path);
                String selectedDir = dialog.open();
                if (selectedDir != null) {
                    MavenLocationComponent.this.locationCombo.setText(selectedDir.trim());
                }
            }
        });
        this.inWorkspaceButton.setSelection(true);
        this.locationLabel.setEnabled(false);
        this.locationCombo.setEnabled(false);
        this.locationBrowseButton.setEnabled(false);
    }

    public IPath getLocationPath() {
        if (this.isInWorkspace()) {
            return Platform.getLocation();
        }
        return Path.fromOSString((String)this.locationCombo.getText().trim());
    }

    public boolean isInWorkspace() {
        return this.inWorkspaceButton.getSelection();
    }

    public void setModifyingListener(ModifyListener modifyingListener) {
        this.modifyingListener = modifyingListener;
        this.locationCombo.addModifyListener(modifyingListener);
    }

    public Combo getLocationCombo() {
        return this.locationCombo;
    }

    public void dispose() {
        super.dispose();
        if (this.modifyingListener != null) {
            this.locationCombo.removeModifyListener(this.modifyingListener);
        }
    }
}

