/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.search;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.cdt.debug.ui.memory.search.MemoryMatch;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;

public class MemorySearchResult
implements ISearchResult {
    private ISearchQuery fQuery;
    private String fLabel;
    private Vector<ISearchResultListener> listeners = new Vector();
    private Vector<MemoryMatch> fMatches = new Vector();

    public MemorySearchResult(ISearchQuery query, String label) {
        this.fQuery = query;
        this.fLabel = label;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public String getTooltip() {
        return this.fLabel;
    }

    public MemoryMatch[] getMatches() {
        MemoryMatch[] matches = new MemoryMatch[this.fMatches.size()];
        int i = 0;
        while (i < matches.length) {
            matches[i] = this.fMatches.elementAt(i);
            ++i;
        }
        return matches;
    }

    public void addMatch(MemoryMatch address) {
        this.fMatches.addElement(address);
        this.fireChange();
    }

    private void fireChange() {
        Enumeration<ISearchResultListener> en = this.listeners.elements();
        while (en.hasMoreElements()) {
            en.nextElement().searchResultChanged(new SearchResultEvent(this){
                private static final long serialVersionUID = -1435449002760145835L;
            });
        }
    }

    public void addListener(ISearchResultListener l) {
        this.listeners.addElement(l);
    }

    public void removeListener(ISearchResultListener l) {
        this.listeners.removeElement(l);
    }
}

