/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;

public class BitInlineEditor
extends BaseValueEditor<Combo> {
    public BitInlineEditor(IValueController controller) {
        super(controller);
    }

    @Override
    protected Combo createControl(Composite editPlaceholder) {
        Combo editor = new Combo(this.valueController.getEditPlaceholder(), 8);
        editor.add(Boolean.FALSE.toString());
        editor.add(Boolean.TRUE.toString());
        editor.setEnabled(!this.valueController.isReadOnly());
        editor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BitInlineEditor.this.saveValue();
            }
        });
        return editor;
    }

    @Override
    public void primeEditorValue(@Nullable Object value) throws DBException {
        ((Combo)this.control).setText(value == null ? Boolean.FALSE.toString() : value.toString());
    }

    @Override
    public Object extractEditorValue() {
        switch (((Combo)this.control).getSelectionIndex()) {
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
        }
        return null;
    }
}

