/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.meta;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderRegistry;
import org.jkiss.dbeaver.model.connection.DBPEditorContribution;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class DBXTreeFolder
extends DBXTreeNode {
    private String type;
    private String label;
    private String description;
    private List<String> contributedCategories = null;

    public DBXTreeFolder(AbstractDescriptor source, DBXTreeNode parent, IConfigurationElement config, String type, boolean navigable, boolean virtual, String visibleIf) {
        super(source, parent, config, navigable, false, virtual, false, visibleIf, null);
        this.type = type;
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
    }

    DBXTreeFolder(AbstractDescriptor source, DBXTreeNode parent, DBXTreeFolder folder) {
        super(source, parent, folder);
        this.type = folder.type;
        this.label = folder.label;
        this.description = folder.description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getNodeType(@Nullable DBPDataSource dataSource, @Nullable String locale) {
        if (locale == null) {
            return this.label;
        }
        return this.getConfig().getAttribute("label", locale);
    }

    @Override
    public String getChildrenType(@Nullable DBPDataSource dataSource, String locale) {
        return this.getNodeType(dataSource, locale);
    }

    @Override
    public boolean hasChildren(DBNNode context, boolean navigable) {
        boolean hasChildren = super.hasChildren(context, navigable);
        if (!hasChildren) {
            hasChildren = !CommonUtils.isEmpty(this.contributedCategories);
        }
        return hasChildren;
    }

    @Override
    @NotNull
    public List<DBXTreeNode> getChildren(DBNNode context) {
        List<DBXTreeNode> children = super.getChildren(context);
        if (!CommonUtils.isEmpty(this.contributedCategories) && context instanceof DBNDatabaseNode) {
            ArrayList<DBXTreeNode> childrenWithContributions = new ArrayList<DBXTreeNode>(children);
            DBPDataSourceProviderRegistry dspRegistry = DBWorkbench.getPlatform().getDataSourceProviderRegistry();
            DBPDataSourceContainer dataSource = ((DBNDatabaseNode)context).getDataSourceContainer();
            for (String category : this.contributedCategories) {
                DBPEditorContribution[] editors;
                DBPEditorContribution[] dBPEditorContributionArray = editors = dspRegistry.getContributedEditors(category, dataSource);
                int n = editors.length;
                int n2 = 0;
                while (n2 < n) {
                    DBPEditorContribution editor = dBPEditorContributionArray[n2];
                    DBXTreeObject editorNode = new DBXTreeObject(this.getSource(), null, null, null, editor.getLabel(), editor.getDescription(), editor.getEditorId());
                    editorNode.setDefaultIcon(editor.getIcon());
                    childrenWithContributions.add(editorNode);
                    ++n2;
                }
            }
            return childrenWithContributions;
        }
        return children;
    }

    @Override
    public String toString() {
        return "Folder " + this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getContributedCategories() {
        return CommonUtils.safeList(this.contributedCategories);
    }

    public void addContribution(String category) {
        if (this.contributedCategories == null) {
            this.contributedCategories = new ArrayList<String>();
        }
        this.contributedCategories.add(category);
    }
}

