/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data.handlers;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDValueDefaultGenerator;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCAbstractValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class JDBCStringValueHandler
extends JDBCAbstractValueHandler
implements DBDValueDefaultGenerator {
    public static final JDBCStringValueHandler INSTANCE = new JDBCStringValueHandler();
    private static final Log log = Log.getLog(JDBCStringValueHandler.class);

    @Override
    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws SQLException {
        return resultSet.getObject(index);
    }

    @Override
    public void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws SQLException {
        if (value == null) {
            statement.setNull(paramIndex, paramType.getTypeID());
        } else {
            statement.setString(paramIndex, value.toString());
        }
    }

    @NotNull
    public Class<String> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return String.class;
    }

    @Override
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        if (object == null || object instanceof String) {
            return object;
        }
        if (object instanceof char[]) {
            return new String((char[])object);
        }
        if (object instanceof byte[]) {
            return new String((byte[])object);
        }
        if (object instanceof DBDContent) {
            return ContentUtils.getContentStringValue(session.getProgressMonitor(), (DBDContent)object);
        }
        if (object.getClass().isArray()) {
            return GeneralUtils.makeDisplayString(object);
        }
        return object.toString();
    }

    @Override
    public String getDefaultValueLabel() {
        return "Empty string";
    }

    @Override
    public Object generateDefaultValue(DBSTypedObject type) {
        return "";
    }
}

