/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.xy;

import java.util.Iterator;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.axis.AxisMark;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.BytesAxisUtils;
import org.netbeans.lib.profiler.charts.axis.BytesMark;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemMarksComputer;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;

public class BytesXYItemMarksComputer
extends XYItemMarksComputer {
    private double scale = -1.0;
    private long step = -1L;
    private int radix = -1;

    public BytesXYItemMarksComputer(XYItem xYItem, XYItemPainter xYItemPainter, ChartContext chartContext, int n) {
        super(xYItem, xYItemPainter, chartContext, n);
    }

    @Override
    protected boolean refreshConfiguration() {
        double d = this.scale;
        this.scale = this.context.getViewWidth() == 0L ? -1.0 : this.painter.getItemValueScale(this.item, this.context);
        if (d != this.scale) {
            if (this.scale == -1.0) {
                this.step = -1L;
                this.radix = -1;
            } else {
                long[] lArray = BytesAxisUtils.getBytesUnits(this.scale, this.getMinMarksDistance());
                this.step = lArray[0];
                this.radix = this.step == -1L ? -1 : (int)lArray[1];
            }
            d = this.scale;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<AxisMark> marksIterator(int n, int n2) {
        if (this.step == -1L) {
            return EMPTY_ITERATOR;
        }
        final long l = (long)this.painter.getItemValue(n, this.item, this.context) / this.step * this.step;
        long l2 = (long)this.painter.getItemValue(n2, this.item, this.context) / this.step * this.step;
        final long l3 = Math.abs(l2 - l) / this.step + 2L;
        final long[] lArray = new long[]{0L};
        return new AxisMarksComputer.AbstractIterator(){

            @Override
            public boolean hasNext() {
                return lArray[0] < l3;
            }

            @Override
            public AxisMark next() {
                long l2 = BytesXYItemMarksComputer.this.reverse ? l - lArray[0] * BytesXYItemMarksComputer.this.step : l + lArray[0] * BytesXYItemMarksComputer.this.step;
                lArray[0] = lArray[0] + 1L;
                int n = Utils.checkedInt(Math.floor(BytesXYItemMarksComputer.this.painter.getItemView(l2, BytesXYItemMarksComputer.this.item, BytesXYItemMarksComputer.this.context)));
                return new BytesMark(l2, n, BytesXYItemMarksComputer.this.radix);
            }
        };
    }
}

