/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTPRawSender;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SendSSRCInfo;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.RTPPacket;
import com.sun.media.rtp.util.UDPPacketSender;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.media.Buffer;

public class RTPTransmitter {
    RTPRawSender sender;
    SSRCCache cache;

    public RTPTransmitter(SSRCCache cache) {
        this.cache = cache;
    }

    public RTPTransmitter(SSRCCache cache, RTPRawSender sender) {
        this(cache);
        this.setSender(sender);
    }

    public RTPTransmitter(SSRCCache cache, int port, String address) throws UnknownHostException, IOException {
        this(cache, new RTPRawSender(port, address));
    }

    public RTPTransmitter(SSRCCache cache, int port, String address, UDPPacketSender sender) throws UnknownHostException, IOException {
        this(cache, new RTPRawSender(port, address, sender));
    }

    public void setSender(RTPRawSender s) {
        this.sender = s;
    }

    public RTPRawSender getSender() {
        return this.sender;
    }

    public void close() {
        if (this.sender != null) {
            this.sender.closeConsumer();
        }
    }

    protected void transmit(RTPPacket p) {
        try {
            this.sender.sendTo(p);
        }
        catch (IOException e) {
            ++this.cache.sm.transstats.transmit_failed;
        }
    }

    public void TransmitPacket(Buffer b, SendSSRCInfo info) {
        info.rtptime = info.getTimeStamp(b);
        info.systime = b.getHeader() instanceof Long ? (Long)b.getHeader() : System.currentTimeMillis();
        RTPPacket p = this.MakeRTPPacket(b, info);
        if (p == null) {
            return;
        }
        this.transmit(p);
        ++info.stats.total_pdu;
        info.stats.total_bytes += b.getLength();
        ++this.cache.sm.transstats.rtp_sent;
        this.cache.sm.transstats.bytes_sent += b.getLength();
    }

    protected RTPPacket MakeRTPPacket(Buffer b, SendSSRCInfo info) {
        byte[] data = (byte[])b.getData();
        if (data == null) {
            return null;
        }
        Packet p = new Packet();
        p.data = data;
        p.offset = 0;
        p.length = b.getLength();
        p.received = false;
        RTPPacket rtp = new RTPPacket(p);
        rtp.marker = (b.getFlags() & 0x800) != 0 ? 1 : 0;
        info.packetsize += b.getLength();
        rtp.payloadType = info.payloadType;
        rtp.seqnum = (int)info.getSequenceNumber(b);
        rtp.timestamp = info.rtptime;
        rtp.ssrc = info.ssrc;
        rtp.payloadoffset = b.getOffset();
        rtp.payloadlength = b.getLength();
        info.bytesreceived += b.getLength();
        ++info.maxseq;
        info.lasttimestamp = rtp.timestamp;
        return rtp;
    }
}

