/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.SplashManager;
import com.intellij.notification.impl.IdeNotificationArea;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetProvider;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.CloseProjectWindowHelper;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.ProjectFrameBounds;
import com.intellij.openapi.wm.impl.Windows;
import com.intellij.openapi.wm.impl.status.ColumnSelectionModePanel;
import com.intellij.openapi.wm.impl.status.EncodingPanel;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.status.LineSeparatorPanel;
import com.intellij.openapi.wm.impl.status.PositionPanel;
import com.intellij.openapi.wm.impl.status.ToggleReadOnlyAttributePanel;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.mac.MacMainFrameDecorator;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.io.SuperUserStatus;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextAccessor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.PowerSupplyKit;

public final class IdeFrameImpl
extends JFrame
implements IdeFrameEx,
AccessibleContextAccessor,
DataProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.IdeFrameImpl");
    public static final String NORMAL_STATE_BOUNDS = "normalBounds";
    public static final Key<Boolean> SHOULD_OPEN_IN_FULL_SCREEN = Key.create((String)"should.open.in.full.screen");
    private static boolean ourUpdatingTitle;
    private String myTitle;
    private String myFileTitle;
    private File myCurrentFile;
    private Project myProject;
    private IdeRootPane myRootPane;
    private BalloonLayout myBalloonLayout;
    private IdeFrameDecorator myFrameDecorator;
    private boolean myRestoreFullScreen;
    private final LafManagerListener myLafListener;
    private final ComponentListener resizedListener;
    private boolean ready;
    private Image mySelfie;
    private final Set<String> widgetIDs = new HashSet<String>();

    public IdeFrameImpl() {
        this.updateTitle();
        final Runnable hideSplashTask = SplashManager.getHideTask();
        if (hideSplashTask != null) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    hideSplashTask.run();
                    IdeFrameImpl.this.removeWindowListener(this);
                }
            });
        }
        this.myRootPane = new IdeRootPane(this);
        this.setRootPane(this.myRootPane);
        this.setBackground(UIUtil.getPanelBackground());
        this.myLafListener = src -> this.setBackground(UIUtil.getPanelBackground());
        LafManager.getInstance().addLafManagerListener(this.myLafListener);
        this.resizedListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (IdeFrameImpl.this.getExtendedState() == 0) {
                    IdeFrameImpl.this.getRootPane().putClientProperty(IdeFrameImpl.NORMAL_STATE_BOUNDS, IdeFrameImpl.this.getBounds());
                }
            }
        };
        this.myRootPane.addComponentListener(this.resizedListener);
        Dimension size = ScreenUtil.getMainScreenBounds().getSize();
        size.width = Math.min(1400, size.width - 20);
        size.height = Math.min(1000, size.height - 40);
        this.setSize(size);
        this.setLocationRelativeTo(null);
        this.setMinimumSize(new Dimension(340, this.getMinimumSize().height));
        if (UIUtil.SUPPRESS_FOCUS_STEALING && Registry.is((String)"suppress.focus.stealing.auto.request.focus") && !ApplicationManager.getApplication().isActive()) {
            this.setAutoRequestFocus(false);
        }
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicyExt(){

            @Override
            public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                JComponent component;
                EditorWithProviderComposite editor;
                EditorWindow window;
                FileEditorManagerEx fileEditorManagerEx;
                if (IdeFrameImpl.this.myProject != null && (fileEditorManagerEx = FileEditorManagerEx.getInstanceEx(IdeFrameImpl.this.myProject)) != null && (window = fileEditorManagerEx.getCurrentWindow()) != null && (editor = window.getSelectedEditor()) != null && (component = editor.getPreferredFocusedComponent()) != null) {
                    return component;
                }
                return super.getComponentAfter(focusCycleRoot, aComponent);
            }
        });
        this.setupCloseAction();
        MnemonicHelper.init((Component)this);
        this.myBalloonLayout = new BalloonLayoutImpl(this.myRootPane, (Insets)JBUI.insets((int)8));
        MouseGestureManager.getInstance().add(this);
        this.myFrameDecorator = IdeFrameDecorator.decorate(this);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicyExt(){

            @Override
            protected Component getDefaultComponentImpl(Container focusCycleRoot) {
                Component component = IdeFrameImpl.this.findNextFocusComponent();
                return component == null ? super.getDefaultComponentImpl(focusCycleRoot) : component;
            }

            @Override
            protected Component getFirstComponentImpl(Container focusCycleRoot) {
                Component component = IdeFrameImpl.this.findNextFocusComponent();
                return component == null ? super.getFirstComponentImpl(focusCycleRoot) : component;
            }

            @Override
            protected Component getLastComponentImpl(Container focusCycleRoot) {
                Component component = IdeFrameImpl.this.findNextFocusComponent();
                return component == null ? super.getLastComponentImpl(focusCycleRoot) : component;
            }

            @Override
            protected Component getComponentAfterImpl(Container focusCycleRoot, Component aComponent) {
                Component component = IdeFrameImpl.this.findNextFocusComponent();
                return component == null ? super.getComponentAfterImpl(focusCycleRoot, aComponent) : component;
            }

            @Override
            public Component getInitialComponent(Window window) {
                Component component = IdeFrameImpl.this.findNextFocusComponent();
                return component == null ? super.getInitialComponent(window) : component;
            }

            @Override
            protected Component getComponentBeforeImpl(Container focusCycleRoot, Component aComponent) {
                Component component = IdeFrameImpl.this.findNextFocusComponent();
                return component == null ? super.getComponentBeforeImpl(focusCycleRoot, aComponent) : component;
            }
        });
    }

    public void init() {
        IdeRootPane rootPane = this.myRootPane;
        if (rootPane == null) {
            return;
        }
        rootPane.init(this);
        if (SystemInfo.isMac) {
            this.setIconImage(null);
        }
        AppUIUtil.updateWindowIcon(this);
    }

    private Component findNextFocusComponent() {
        if (this.myProject != null) {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            ToolWindowManagerEx toolWindowManagerEx = ToolWindowManagerEx.getInstanceEx(this.myProject);
            if (ToolWindowManagerEx.getInstanceEx(this.myProject).fallbackToEditor()) {
                JComponent preferredFocusedComponent;
                EditorWithProviderComposite selectedEditor;
                EditorWindow currentWindow = FileEditorManagerEx.getInstanceEx(this.myProject).getSplitters().getCurrentWindow();
                if (currentWindow != null && (selectedEditor = currentWindow.getSelectedEditor()) != null && (preferredFocusedComponent = selectedEditor.getPreferredFocusedComponent()) != null) {
                    return preferredFocusedComponent;
                }
            } else if (focusOwner != null && !Windows.ToolWindowProvider.isInToolWindow(focusOwner)) {
                Content content2;
                String toolWindowId = toolWindowManagerEx.getLastActiveToolWindowId();
                ToolWindow toolWindow = toolWindowManagerEx.getToolWindow(toolWindowId);
                Content content3 = content2 = toolWindow == null ? null : toolWindow.getContentManager().getContent(0);
                if (content2 != null) {
                    JComponent component = content2.getPreferredFocusableComponent();
                    if (component == null) {
                        LOG.warn("Set preferredFocusableComponent in '" + content2.getDisplayName() + "' content in " + toolWindowId + " tool window to avoid focus-related problems.");
                    }
                    return component == null ? IdeFrameImpl.getComponentToRequestFocus(toolWindow) : component;
                }
            }
        }
        return null;
    }

    @Nullable
    private static Component getComponentToRequestFocus(ToolWindow toolWindow) {
        JComponent container = toolWindow.getComponent();
        if (container == null || !container.isShowing()) {
            LOG.warn(toolWindow.getTitle() + " tool window - parent container is hidden");
            return null;
        }
        FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
        if (policy == null) {
            LOG.warn(toolWindow.getTitle() + " tool window does not provide focus traversal policy");
            return null;
        }
        Component component = policy.getDefaultComponent(container);
        if (component == null || !component.isShowing()) {
            LOG.debug(toolWindow.getTitle() + " tool window - default component is hidden");
            return null;
        }
        return component;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        PowerSupplyKit.checkPowerSupply();
    }

    @Override
    @NotNull
    public Insets getInsets() {
        Insets insets = SystemInfo.isMac && this.isInFullScreen() ? JBUI.emptyInsets() : super.getInsets();
        if (insets == null) {
            IdeFrameImpl.$$$reportNull$$$0(0);
        }
        return insets;
    }

    public JComponent getComponent() {
        return this.getRootPane();
    }

    @Nullable
    public static Window getActiveFrame() {
        for (Frame frame : IdeFrameImpl.getFrames()) {
            if (!frame.isActive()) continue;
            return frame;
        }
        return null;
    }

    @Override
    public void show() {
        super.show();
        SwingUtilities.invokeLater(() -> this.setFocusableWindowState(true));
    }

    @Override
    public synchronized void setMaximizedBounds(Rectangle bounds2) {
        super.setMaximizedBounds(null);
    }

    @Override
    public void setExtendedState(int state) {
        if (this.getExtendedState() == 0 && (state & 6) != 0) {
            this.getRootPane().putClientProperty(NORMAL_STATE_BOUNDS, this.getBounds());
        }
        super.setExtendedState(state);
    }

    private void setupCloseAction() {
        this.setDefaultCloseOperation(0);
        final CloseProjectWindowHelper helper = new CloseProjectWindowHelper();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(@NotNull WindowEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (IdeFrameImpl.this.isTemporaryDisposed() || LaterInvocator.isInModalContext()) {
                    return;
                }
                Application app = ApplicationManager.getApplication();
                if (app != null && !app.isDisposeInProgress() && !app.isDisposed()) {
                    helper.windowClosing(IdeFrameImpl.this.myProject);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/IdeFrameImpl$5", "windowClosing"));
            }
        });
    }

    public StatusBar getStatusBar() {
        return this.myRootPane == null ? null : this.myRootPane.getStatusBar();
    }

    @Override
    public void setTitle(String title) {
        if (ourUpdatingTitle) {
            super.setTitle(title);
        } else {
            this.myTitle = title;
        }
        this.updateTitle();
    }

    public void setFrameTitle(String text2) {
        super.setTitle(text2);
    }

    public void setFileTitle(@Nullable String fileTitle, @Nullable File file2) {
        this.myFileTitle = fileTitle;
        this.myCurrentFile = file2;
        this.updateTitle();
    }

    public IdeRootPaneNorthExtension getNorthExtension(String key) {
        return this.myRootPane.findByName(key);
    }

    private void updateTitle() {
        IdeFrameImpl.updateTitle(this, this.myTitle, this.myFileTitle, this.myCurrentFile);
    }

    @Nullable
    public static String getSuperUserSuffix() {
        return !SuperUserStatus.isSuperUser() ? null : (SystemInfo.isWindows ? "(Administrator)" : "(ROOT)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTitle(@NotNull JFrame frame, @Nullable String title, @Nullable String fileTitle, @Nullable File currentFile) {
        if (frame == null) {
            IdeFrameImpl.$$$reportNull$$$0(1);
        }
        if (ourUpdatingTitle) {
            return;
        }
        try {
            ourUpdatingTitle = true;
            if (Registry.is((String)"ide.show.fileType.icon.in.titleBar")) {
                frame.getRootPane().putClientProperty("Window.documentFile", currentFile);
            }
            Builder builder2 = new Builder().append(title).append(fileTitle);
            if (Boolean.getBoolean("ide.ui.version.in.title")) {
                builder2.append(ApplicationNamesInfo.getInstance().getFullProductName() + ' ' + ApplicationInfo.getInstance().getFullVersion());
            } else if (!SystemInfo.isMac && !SystemInfo.isGNOME || builder2.isEmpty()) {
                builder2.append(ApplicationNamesInfo.getInstance().getFullProductName());
            }
            builder2.append(IdeFrameImpl.getSuperUserSuffix(), " ");
            frame.setTitle(builder2.toString());
        }
        finally {
            ourUpdatingTitle = false;
        }
    }

    public void updateView() {
        ((IdeRootPane)this.getRootPane()).updateToolbar();
        ((IdeRootPane)this.getRootPane()).updateMainMenuActions();
        ((IdeRootPane)this.getRootPane()).updateNorthComponents();
    }

    public AccessibleContext getCurrentAccessibleContext() {
        return this.accessibleContext;
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            IdeFrameImpl.$$$reportNull$$$0(2);
        }
        if (CommonDataKeys.PROJECT.is(dataId) && this.myProject != null) {
            return this.myProject.isInitialized() ? this.myProject : null;
        }
        if (IdeFrame.KEY.getName().equals(dataId)) {
            return this;
        }
        return null;
    }

    public void setProject(@Nullable Project project) {
        if (this.myProject == project) {
            return;
        }
        this.myProject = project;
        if (project != null) {
            if (WindowManager.getInstance().isFullScreenSupportedInCurrentOS()) {
                boolean bl = this.myRestoreFullScreen = SHOULD_OPEN_IN_FULL_SCREEN.get((UserDataHolder)project) == Boolean.TRUE || ProjectFrameBounds.getInstance(project).isInFullScreen();
                if (!this.myRestoreFullScreen && PropertiesComponent.getInstance((Project)project).getBoolean("FullScreen")) {
                    this.myRestoreFullScreen = true;
                    PropertiesComponent.getInstance((Project)project).unsetValue("FullScreen");
                }
            }
            if (this.myRootPane != null) {
                this.myRootPane.installNorthComponents(project);
                StatusBar statusBar = this.myRootPane.getStatusBar();
                if (statusBar != null) {
                    project.getMessageBus().connect().subscribe(StatusBar.Info.TOPIC, (Object)statusBar);
                }
            }
            this.installDefaultProjectStatusBarWidgets(this.myProject);
            ProjectManager.getInstance().addProjectManagerListener(this.myProject, new ProjectManagerListener(){

                public void projectClosingBeforeSave(@NotNull Project project) {
                    if (project == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    IdeFrameImpl.this.takeASelfie();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/IdeFrameImpl$6", "projectClosingBeforeSave"));
                }
            });
            StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)((DumbAwareRunnable)() -> {
                this.ready = true;
            }));
        } else if (this.myRootPane != null) {
            this.myRootPane.deinstallNorthComponents();
        }
        if (this.myRestoreFullScreen && this.isVisible()) {
            this.toggleFullScreen(true);
            this.myRestoreFullScreen = false;
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b && this.myRestoreFullScreen) {
            SwingUtilities.invokeLater(() -> {
                this.toggleFullScreen(true);
                if (SystemInfo.isMacOSLion) {
                    this.setBounds(ScreenUtil.getScreenRectangle((Point)this.getLocationOnScreen()));
                }
                this.myRestoreFullScreen = false;
            });
        }
    }

    private void addWidget(StatusBar statusBar, StatusBarWidget widget, String anchor2) {
        if (!this.widgetIDs.add(widget.ID())) {
            LOG.error("Attempting to add more than one widget with ID: " + widget.ID());
            return;
        }
        statusBar.addWidget(widget, anchor2);
    }

    private void installDefaultProjectStatusBarWidgets(@NotNull Project project) {
        if (project == null) {
            IdeFrameImpl.$$$reportNull$$$0(3);
        }
        StatusBar statusBar = this.getStatusBar();
        this.addWidget(statusBar, new PositionPanel(project), StatusBar.Anchors.before((String)"FatalError"));
        this.addWidget(statusBar, (StatusBarWidget)new IdeNotificationArea(project), StatusBar.Anchors.before((String)"FatalError"));
        this.addWidget(statusBar, new EncodingPanel(project), StatusBar.Anchors.after((String)"Position"));
        this.addWidget(statusBar, new LineSeparatorPanel(project), StatusBar.Anchors.before((String)"Encoding"));
        this.addWidget(statusBar, new ColumnSelectionModePanel(project), StatusBar.Anchors.after((String)"Encoding"));
        this.addWidget(statusBar, (StatusBarWidget)new ToggleReadOnlyAttributePanel(project), StatusBar.Anchors.after((String)"InsertOverwrite"));
        for (StatusBarWidgetProvider widgetProvider : (StatusBarWidgetProvider[])StatusBarWidgetProvider.EP_NAME.getExtensions()) {
            StatusBarWidget widget = widgetProvider.getWidget(project);
            if (widget == null) continue;
            this.addWidget(statusBar, widget, widgetProvider.getAnchor());
        }
        Disposer.register((Disposable)project, () -> {
            for (String widgetID : this.widgetIDs) {
                statusBar.removeWidget(widgetID);
            }
            this.widgetIDs.clear();
            if (statusBar instanceof IdeStatusBarImpl) {
                ((IdeStatusBarImpl)statusBar).removeCustomIndicationComponents();
            }
        });
    }

    public Project getProject() {
        return this.myProject;
    }

    @Override
    public void dispose() {
        if (SystemInfo.isMac && this.isInFullScreen()) {
            ((MacMainFrameDecorator)this.myFrameDecorator).toggleFullScreenNow();
        }
        if (this.isTemporaryDisposed()) {
            super.dispose();
            return;
        }
        MouseGestureManager.getInstance().remove(this);
        if (this.myBalloonLayout != null) {
            ((BalloonLayoutImpl)this.myBalloonLayout).dispose();
            this.myBalloonLayout = null;
        }
        if (this.myRootPane != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.myRootPane.removeNotify();
            }
            this.myRootPane.removeComponentListener(this.resizedListener);
            this.setRootPane(new JRootPane());
            Disposer.dispose((Disposable)this.myRootPane);
            this.myRootPane = null;
        }
        if (this.myFrameDecorator != null) {
            Disposer.dispose((Disposable)this.myFrameDecorator);
            this.myFrameDecorator = null;
        }
        if (this.myLafListener != null) {
            LafManager.getInstance().removeLafManagerListener(this.myLafListener);
        }
        super.dispose();
    }

    private boolean isTemporaryDisposed() {
        return this.myRootPane != null && this.myRootPane.getClientProperty("dispose.temporary") != null;
    }

    public void storeFullScreenStateIfNeeded() {
        if (this.myProject != null) {
            this.doLayout();
        }
    }

    @Override
    public void paint(@NotNull Graphics g) {
        if (g == null) {
            IdeFrameImpl.$$$reportNull$$$0(4);
        }
        UISettings.setupAntialiasing((Graphics)g);
        if (this.shouldPaintSelfie()) {
            try {
                if (this.mySelfie == null) {
                    this.mySelfie = ImageUtil.ensureHiDPI((Image)ImageIO.read(this.getSelfieLocation()), (ScaleContext)ScaleContext.create((Component)this));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            StartupUiUtil.drawImage((Graphics)g, (Image)this.mySelfie, (int)0, (int)0, null);
            return;
        }
        this.mySelfie = null;
        super.paint(g);
    }

    private boolean shouldPaintSelfie() {
        return !this.ready && Registry.is((String)"ide.project.loading.show.last.state") && (this.myProject != null || ProjectManager.getInstance().getOpenProjects().length == 0);
    }

    public void takeASelfie() {
        if (this.myProject == null || !Registry.is((String)"ide.project.loading.show.last.state")) {
            return;
        }
        BufferedImage image = UIUtil.createImage((Component)this, (int)this.getWidth(), (int)this.getHeight(), (int)2);
        UISettings.setupAntialiasing((Graphics)image.getGraphics());
        this.paint(image.getGraphics());
        try {
            File selfie = this.getSelfieLocation();
            if (selfie.getParentFile().exists() || selfie.getParentFile().mkdirs()) {
                ImageIO.write((RenderedImage)image, "png", selfie);
                FileUtil.copy((File)selfie, (File)IdeFrameImpl.getLastSelfieLocation());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    private File getSelfieLocation() {
        File file2 = this.myProject != null ? ProjectUtil.getProjectCachePath((Project)this.myProject, (String)"selfies", (boolean)false, (String)".png").toFile() : IdeFrameImpl.getLastSelfieLocation();
        if (file2 == null) {
            IdeFrameImpl.$$$reportNull$$$0(5);
        }
        return file2;
    }

    @NotNull
    private static File getLastSelfieLocation() {
        File file2 = new File(PathManager.getSystemPath(), "selfies/last_closed_project.png");
        if (file2 == null) {
            IdeFrameImpl.$$$reportNull$$$0(6);
        }
        return file2;
    }

    public Rectangle suggestChildFrameBounds() {
        Rectangle b = this.getBounds();
        b.x += 100;
        b.width -= 200;
        b.y += 100;
        b.height -= 200;
        return b;
    }

    public final BalloonLayout getBalloonLayout() {
        return this.myBalloonLayout;
    }

    @Override
    public boolean isInFullScreen() {
        return this.myFrameDecorator != null && this.myFrameDecorator.isInFullScreen();
    }

    @Override
    @NotNull
    public ActionCallback toggleFullScreen(boolean state) {
        if (this.temporaryFixForIdea156004(state)) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                IdeFrameImpl.$$$reportNull$$$0(7);
            }
            return actionCallback;
        }
        if (this.myFrameDecorator != null) {
            ActionCallback actionCallback = this.myFrameDecorator.toggleFullScreen(state);
            if (actionCallback == null) {
                IdeFrameImpl.$$$reportNull$$$0(8);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            IdeFrameImpl.$$$reportNull$$$0(9);
        }
        return actionCallback;
    }

    private boolean temporaryFixForIdea156004(boolean state) {
        if (SystemInfo.isMac) {
            try {
                Field modalBlockerField = Window.class.getDeclaredField("modalBlocker");
                modalBlockerField.setAccessible(true);
                Window modalBlocker = (Window)modalBlockerField.get(this);
                if (modalBlocker != null) {
                    ApplicationManager.getApplication().invokeLater(() -> this.toggleFullScreen(state), ModalityState.NON_MODAL);
                    return true;
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LOG.error((Throwable)e);
            }
        }
        return false;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleIdeFrameImpl();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/IdeFrameImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsets";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/IdeFrameImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelfieLocation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastSelfieLocation";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toggleFullScreen";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateTitle";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installDefaultProjectStatusBarWidgets";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class AccessibleIdeFrameImpl
    extends JFrame.AccessibleJFrame {
        protected AccessibleIdeFrameImpl() {
            super(IdeFrameImpl.this);
        }

        @Override
        public String getAccessibleName() {
            StringBuilder builder2 = new StringBuilder();
            if (IdeFrameImpl.this.myProject != null) {
                builder2.append(IdeFrameImpl.this.myProject.getName());
                builder2.append(" - ");
            }
            builder2.append(ApplicationNamesInfo.getInstance().getFullProductName());
            return builder2.toString();
        }
    }

    private static final class Builder {
        private final StringBuilder sb = new StringBuilder();

        private Builder() {
        }

        Builder append(@Nullable String s) {
            return this.append(s, " - ");
        }

        Builder append(@Nullable String s, String separator) {
            if (!StringUtil.isEmptyOrSpaces((String)s)) {
                if (this.sb.length() > 0) {
                    this.sb.append(separator);
                }
                this.sb.append(s);
            }
            return this;
        }

        boolean isEmpty() {
            return this.sb.length() == 0;
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

