/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.text.ByteArrayCharSequence;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.impl.VfsData");
    private static final int SEGMENT_BITS = 9;
    private static final int SEGMENT_SIZE = 512;
    private static final int OFFSET_MASK = 511;
    private final Object myDeadMarker = ObjectUtils.sentinel((String)"dead file");
    private final ConcurrentIntObjectMap<Segment> mySegments = ContainerUtil.createConcurrentIntObjectMap();
    private final ConcurrentBitSet myInvalidatedIds = new ConcurrentBitSet();
    private TIntHashSet myDyingIds = new TIntHashSet();
    private final IntObjectMap<VirtualDirectoryImpl> myChangedParents = ContainerUtil.createConcurrentIntObjectMap();

    public VfsData() {
        ApplicationManager.getApplication().addApplicationListener(new ApplicationListener(){

            public void writeActionFinished(@NotNull Object action2) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
                    VfsData.this.killInvalidatedFiles();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/vfs/newvfs/impl/VfsData$1", "writeActionFinished"));
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killInvalidatedFiles() {
        Object object = this.myDeadMarker;
        synchronized (object) {
            if (!this.myDyingIds.isEmpty()) {
                for (int id : this.myDyingIds.toArray()) {
                    Segment segment = (Segment)ObjectUtils.assertNotNull((Object)this.getSegment(id, false));
                    segment.myObjectArray.set(VfsData.getOffset(id), this.myDeadMarker);
                    this.myChangedParents.remove(id);
                }
                this.myDyingIds = new TIntHashSet();
            }
        }
    }

    @Nullable
    VirtualFileSystemEntry getFileById(int id, @NotNull VirtualDirectoryImpl parent) {
        PersistentFSImpl persistentFS;
        VirtualFileSystemEntry dir;
        if (parent == null) {
            VfsData.$$$reportNull$$$0(0);
        }
        if ((dir = (persistentFS = (PersistentFSImpl)PersistentFS.getInstance()).getCachedDir(id)) != null) {
            return dir;
        }
        Segment segment = this.getSegment(id, false);
        if (segment == null) {
            return null;
        }
        int offset = VfsData.getOffset(id);
        Object o = segment.myObjectArray.get(offset);
        if (o == null) {
            return null;
        }
        if (o == this.myDeadMarker) {
            throw VfsData.reportDeadFileAccess(new VirtualFileImpl(id, segment, parent));
        }
        int nameId = segment.getNameId(id);
        if (nameId <= 0) {
            FSRecords.invalidateCaches();
            throw new AssertionError((Object)("nameId=" + nameId + "; data=" + o + "; parent=" + (Object)((Object)parent) + "; parent.id=" + parent.getId() + "; db.parent=" + FSRecords.getParent(id)));
        }
        return o instanceof DirectoryData ? persistentFS.getOrCacheDir(id, segment, (DirectoryData)o, parent) : new VirtualFileImpl(id, segment, parent);
    }

    private static InvalidVirtualFileAccessException reportDeadFileAccess(VirtualFileSystemEntry file2) {
        return new InvalidVirtualFileAccessException("Accessing dead virtual file: " + file2.getUrl());
    }

    private static int getOffset(int id) {
        return id & 0x1FF;
    }

    @Nullable
    @Contract(value="_,true->!null")
    public Segment getSegment(int id, boolean create2) {
        int key = id >>> 9;
        Segment segment = (Segment)this.mySegments.get(key);
        if (segment != null || !create2) {
            return segment;
        }
        return (Segment)this.mySegments.cacheOrGet(key, (Object)new Segment(this));
    }

    public boolean hasLoadedFile(int id) {
        Segment segment = this.getSegment(id, false);
        return segment != null && segment.myObjectArray.get(VfsData.getOffset(id)) != null;
    }

    public static void initFile(int id, Segment segment, int nameId, @NotNull Object data) throws FileAlreadyCreatedException {
        if (data == null) {
            VfsData.$$$reportNull$$$0(1);
        }
        assert (id > 0);
        int offset = VfsData.getOffset(id);
        segment.setNameId(id, nameId);
        Object existingData = segment.myObjectArray.get(offset);
        if (existingData != null) {
            FSRecords.invalidateCaches();
            int parent = FSRecords.getParent(id);
            String msg = "File already created: " + nameId + ", data=" + existingData + "; parentId=" + parent;
            if (parent > 0) {
                msg = msg + "; parent.name=" + FSRecords.getName(parent);
                msg = msg + "; parent.children=" + Arrays.toString(FSRecords.listAll(id));
            }
            throw new FileAlreadyCreatedException(msg);
        }
        segment.myObjectArray.set(offset, data);
    }

    @NotNull
    CharSequence getNameByFileId(int id) {
        CharSequence charSequence = FileNameCache.getVFileName(this.getNameId(id));
        if (charSequence == null) {
            VfsData.$$$reportNull$$$0(2);
        }
        return charSequence;
    }

    int getNameId(int id) {
        return ((Segment)ObjectUtils.assertNotNull((Object)this.getSegment(id, false))).getNameId(id);
    }

    boolean isFileValid(int id) {
        return !this.myInvalidatedIds.get(id);
    }

    @Nullable
    VirtualDirectoryImpl getChangedParent(int id) {
        return (VirtualDirectoryImpl)((Object)this.myChangedParents.get(id));
    }

    void changeParent(int id, VirtualDirectoryImpl parent) {
        this.myChangedParents.put(id, (Object)parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateFile(int id) {
        this.myInvalidatedIds.set(id);
        Object object = this.myDeadMarker;
        synchronized (object) {
            this.myDyingIds.add(id);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/VfsData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VfsData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameByFileId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFileById";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initFile";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DirectoryData {
        private static final AtomicFieldUpdater<DirectoryData, KeyFMap> MY_USER_MAP_UPDATER = AtomicFieldUpdater.forFieldOfType(DirectoryData.class, KeyFMap.class);
        @NotNull
        volatile KeyFMap myUserMap = KeyFMap.EMPTY_MAP;
        @NotNull
        volatile int[] myChildrenIds = ArrayUtilRt.EMPTY_INT_ARRAY;
        private volatile Set<CharSequence> myAdoptedNames;

        @NotNull
        VirtualFileSystemEntry[] getFileChildren(@NotNull VirtualDirectoryImpl parent) {
            if (parent == null) {
                DirectoryData.$$$reportNull$$$0(0);
            }
            int[] ids = this.myChildrenIds;
            VirtualFileSystemEntry[] children2 = new VirtualFileSystemEntry[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                int childId = ids[i];
                VirtualFileSystemEntry child2 = parent.mySegment.vfsData.getFileById(childId, parent);
                if (child2 == null) {
                    throw new AssertionError((Object)("No file for id " + childId + ", parentId = " + parent.myId));
                }
                children2[i] = child2;
            }
            if (children2 == null) {
                DirectoryData.$$$reportNull$$$0(1);
            }
            return children2;
        }

        boolean changeUserMap(KeyFMap oldMap, KeyFMap newMap) {
            return MY_USER_MAP_UPDATER.compareAndSet((Object)this, (Object)oldMap, (Object)newMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isAdoptedName(@NotNull CharSequence name) {
            Set<CharSequence> adopted;
            if (name == null) {
                DirectoryData.$$$reportNull$$$0(2);
            }
            if ((adopted = this.myAdoptedNames) == null) {
                return false;
            }
            Set<CharSequence> set = adopted;
            synchronized (set) {
                return adopted.contains(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeAdoptedName(@NotNull CharSequence name) {
            Set<CharSequence> adopted;
            if (name == null) {
                DirectoryData.$$$reportNull$$$0(3);
            }
            if ((adopted = this.myAdoptedNames) == null) {
                return;
            }
            Set<CharSequence> set = adopted;
            synchronized (set) {
                boolean removed = adopted.remove(name);
                if (removed && adopted.isEmpty()) {
                    this.myAdoptedNames = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addAdoptedName(@NotNull CharSequence name, boolean caseSensitive) {
            if (name == null) {
                DirectoryData.$$$reportNull$$$0(4);
            }
            Set<CharSequence> adopted = this.getOrCreateAdoptedNames(caseSensitive);
            CharSequence sequence = ByteArrayCharSequence.convertToBytesIfPossible((CharSequence)name);
            Set<CharSequence> set = adopted;
            synchronized (set) {
                adopted.add(sequence);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addAdoptedNames(@NotNull Collection<? extends CharSequence> names2, boolean caseSensitive) {
            Set<CharSequence> adopted;
            if (names2 == null) {
                DirectoryData.$$$reportNull$$$0(5);
            }
            Set<CharSequence> set = adopted = this.getOrCreateAdoptedNames(caseSensitive);
            synchronized (set) {
                adopted.addAll(names2);
            }
        }

        @NotNull
        private Set<CharSequence> getOrCreateAdoptedNames(boolean caseSensitive) {
            THashSet adopted = this.myAdoptedNames;
            if (adopted == null) {
                this.myAdoptedNames = adopted = new THashSet(0, (TObjectHashingStrategy)(caseSensitive ? CharSequenceHashingStrategy.CASE_SENSITIVE : CharSequenceHashingStrategy.CASE_INSENSITIVE));
            }
            THashSet tHashSet = adopted;
            if (tHashSet == null) {
                DirectoryData.$$$reportNull$$$0(6);
            }
            return tHashSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        List<String> getAdoptedNames() {
            Set<CharSequence> adopted = this.myAdoptedNames;
            if (adopted == null) {
                List<String> list2 = Collections.emptyList();
                if (list2 != null) return list2;
                DirectoryData.$$$reportNull$$$0(7);
                return list2;
            }
            Set<CharSequence> set = adopted;
            // MONITORENTER : set
            List list3 = ContainerUtil.map(adopted, (Function)Functions.TO_STRING());
            // MONITOREXIT : set
            if (list3 != null) return list3;
            DirectoryData.$$$reportNull$$$0(8);
            return list3;
        }

        void clearAdoptedNames() {
            this.myAdoptedNames = null;
        }

        public String toString() {
            return "DirectoryData{myUserMap=" + this.myUserMap + ", myChildrenIds=" + Arrays.toString(this.myChildrenIds) + ", myAdoptedNames=" + this.myAdoptedNames + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/VfsData$DirectoryData";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VfsData$DirectoryData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileChildren";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateAdoptedNames";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdoptedNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileChildren";
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAdoptedName";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "removeAdoptedName";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addAdoptedName";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addAdoptedNames";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Segment {
        private final AtomicReferenceArray<Object> myObjectArray;
        private final AtomicIntegerArray myIntArray;
        @NotNull
        final VfsData vfsData;

        Segment(@NotNull VfsData vfsData) {
            if (vfsData == null) {
                Segment.$$$reportNull$$$0(0);
            }
            this.myObjectArray = new AtomicReferenceArray(512);
            this.myIntArray = new AtomicIntegerArray(1024);
            this.vfsData = vfsData;
        }

        int getNameId(int fileId) {
            return this.myIntArray.get(VfsData.getOffset(fileId) * 2);
        }

        void setNameId(int fileId, int nameId) {
            this.myIntArray.set(VfsData.getOffset(fileId) * 2, nameId);
        }

        void setUserMap(int fileId, @NotNull KeyFMap map2) {
            if (map2 == null) {
                Segment.$$$reportNull$$$0(1);
            }
            this.myObjectArray.set(VfsData.getOffset(fileId), map2);
        }

        KeyFMap getUserMap(VirtualFileSystemEntry file2, int id) {
            Object o = this.myObjectArray.get(VfsData.getOffset(id));
            if (!(o instanceof KeyFMap)) {
                throw VfsData.reportDeadFileAccess(file2);
            }
            return (KeyFMap)o;
        }

        boolean changeUserMap(int fileId, KeyFMap oldMap, KeyFMap newMap) {
            return this.myObjectArray.compareAndSet(VfsData.getOffset(fileId), oldMap, newMap);
        }

        boolean getFlag(int id, int mask) {
            assert ((mask & 0xFFFFFF) == 0) : "Unexpected flag";
            return (this.myIntArray.get(VfsData.getOffset(id) * 2 + 1) & mask) != 0;
        }

        void setFlag(int id, int mask, boolean value) {
            int updated;
            int oldInt;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Set flag " + Integer.toHexString(mask) + "=" + value + " for id=" + id);
            }
            assert ((mask & 0xFFFFFF) == 0) : "Unexpected flag";
            int offset = VfsData.getOffset(id) * 2 + 1;
            while (!this.myIntArray.compareAndSet(offset, oldInt = this.myIntArray.get(offset), updated = BitUtil.set((int)oldInt, (int)mask, (boolean)value))) {
            }
        }

        long getModificationStamp(int id) {
            return this.myIntArray.get(VfsData.getOffset(id) * 2 + 1) & 0xFFFFFF;
        }

        void setModificationStamp(int id, long stamp) {
            int updated;
            int oldInt;
            int offset = VfsData.getOffset(id) * 2 + 1;
            while (!this.myIntArray.compareAndSet(offset, oldInt = this.myIntArray.get(offset), updated = oldInt & 0xFF000000 | (int)stamp & 0xFFFFFF)) {
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vfsData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VfsData$Segment";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setUserMap";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FileAlreadyCreatedException
    extends Exception {
        private FileAlreadyCreatedException(String message) {
            super(message);
        }
    }
}

