/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.FileDownloadingAdapter;
import com.intellij.openapi.vfs.impl.http.FileDownloadingListener;
import com.intellij.openapi.vfs.impl.http.RemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.RemoteFileManagerImpl;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class RemoteFileInfoImpl
implements RemoteContentProvider.DownloadingCallback,
RemoteFileInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.http.RemoteFileInfoImpl");
    private final Object myLock;
    private final Url myUrl;
    private final RemoteFileManagerImpl myManager;
    @Nullable
    private RemoteContentProvider myContentProvider;
    private File myLocalFile;
    private VirtualFile myLocalVirtualFile;
    private VirtualFile myPrevLocalFile;
    private RemoteFileState myState;
    private String myErrorMessage;
    private final AtomicBoolean myCancelled;
    private final List<FileDownloadingListener> myListeners;

    public RemoteFileInfoImpl(@NotNull Url url, @NotNull RemoteFileManagerImpl manager) {
        if (url == null) {
            RemoteFileInfoImpl.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            RemoteFileInfoImpl.$$$reportNull$$$0(1);
        }
        this.myLock = new Object();
        this.myState = RemoteFileState.DOWNLOADING_NOT_STARTED;
        this.myCancelled = new AtomicBoolean();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myUrl = url;
        this.myManager = manager;
    }

    @Override
    public void addDownloadingListener(@NotNull FileDownloadingListener listener2) {
        if (listener2 == null) {
            RemoteFileInfoImpl.$$$reportNull$$$0(2);
        }
        this.myListeners.add(listener2);
    }

    @Override
    public void removeDownloadingListener(@NotNull FileDownloadingListener listener2) {
        if (listener2 == null) {
            RemoteFileInfoImpl.$$$reportNull$$$0(3);
        }
        this.myListeners.remove(listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartDownloading() {
        Object object = this.myLock;
        synchronized (object) {
            this.myErrorMessage = null;
            this.myPrevLocalFile = this.myLocalVirtualFile;
            this.myLocalVirtualFile = null;
            this.myState = RemoteFileState.DOWNLOADING_NOT_STARTED;
            this.myLocalFile = null;
            this.startDownloading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startDownloading() {
        File localFile;
        LOG.debug("Downloading requested");
        Iterator<FileDownloadingListener> iterator = this.myLock;
        synchronized (iterator) {
            if (this.myState != RemoteFileState.DOWNLOADING_NOT_STARTED) {
                LOG.debug("File already downloaded: file = " + this.myLocalVirtualFile + ", state = " + (Object)((Object)this.myState));
                return;
            }
            this.myState = RemoteFileState.DOWNLOADING_IN_PROGRESS;
            try {
                this.myLocalFile = this.myManager.getStorage().createLocalFile(this.myUrl);
                LOG.debug("Local file created: " + this.myLocalFile.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.errorOccurred(VfsBundle.message((String)"cannot.create.local.file", (Object[])new Object[]{e.getMessage()}), false);
                return;
            }
            this.myCancelled.set(false);
            localFile = this.myLocalFile;
        }
        for (FileDownloadingListener listener2 : this.myListeners) {
            listener2.downloadingStarted();
        }
        if (this.myContentProvider == null) {
            this.myContentProvider = this.myManager.findContentProvider(this.myUrl);
        }
        this.myContentProvider.saveContent(this.myUrl, localFile, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(@Nullable FileType fileType) {
        File localIOFile;
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("Downloading finished, size = " + this.myLocalFile.length() + ", file type=" + (fileType != null ? fileType.getName() : "null"));
            if (fileType != null) {
                String fileName2 = this.myLocalFile.getName();
                int dot = fileName2.lastIndexOf(46);
                String extension = fileType.getDefaultExtension();
                if (dot == -1 || !extension.regionMatches(true, 0, fileName2, dot + 1, extension.length())) {
                    File newFile = FileUtil.findSequentNonexistentFile((File)this.myLocalFile.getParentFile(), (String)fileName2, (String)extension);
                    try {
                        FileUtil.rename((File)this.myLocalFile, (File)newFile);
                        this.myLocalFile = newFile;
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                    }
                }
            }
            localIOFile = this.myLocalFile;
        }
        VirtualFile localFile = (VirtualFile)WriteAction.computeAndWait(() -> {
            VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(localIOFile);
            if (file2 != null) {
                file2.refresh(false, false);
            }
            return file2;
        });
        LOG.assertTrue(localFile != null, (Object)("Virtual local file not found for " + localIOFile.getAbsolutePath()));
        LOG.debug("Virtual local file: " + localFile + ", size = " + localFile.getLength());
        Iterator<FileDownloadingListener> iterator = this.myLock;
        synchronized (iterator) {
            this.myLocalVirtualFile = localFile;
            this.myPrevLocalFile = null;
            this.myState = RemoteFileState.DOWNLOADED;
            this.myErrorMessage = null;
        }
        for (FileDownloadingListener listener2 : this.myListeners) {
            listener2.fileDownloaded(localFile);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.myCancelled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getErrorMessage() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myErrorMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void errorOccurred(@NotNull String errorMessage, boolean cancelled) {
        if (errorMessage == null) {
            RemoteFileInfoImpl.$$$reportNull$$$0(4);
        }
        LOG.debug("Error: " + errorMessage);
        Iterator<FileDownloadingListener> iterator = this.myLock;
        synchronized (iterator) {
            this.myLocalVirtualFile = null;
            this.myPrevLocalFile = null;
            this.myState = RemoteFileState.ERROR_OCCURRED;
            this.myErrorMessage = errorMessage;
        }
        for (FileDownloadingListener listener2 : this.myListeners) {
            if (cancelled) continue;
            listener2.errorOccurred(errorMessage);
        }
    }

    @Override
    public void setProgressFraction(double fraction) {
        for (FileDownloadingListener listener2 : this.myListeners) {
            listener2.progressFractionChanged(fraction);
        }
    }

    @Override
    public void setProgressText(@NotNull String text2, boolean indeterminate) {
        if (text2 == null) {
            RemoteFileInfoImpl.$$$reportNull$$$0(5);
        }
        for (FileDownloadingListener listener2 : this.myListeners) {
            listener2.progressMessageChanged(indeterminate, text2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualFile getLocalFile() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myLocalVirtualFile;
        }
    }

    public String toString() {
        String errorMessage = this.getErrorMessage();
        return "state=" + (Object)((Object)this.getState()) + ", local file=" + this.myLocalFile + (errorMessage != null ? ", error=" + errorMessage : "") + (this.isCancelled() ? ", cancelled" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteFileState getState() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelDownloading() {
        Iterator<FileDownloadingListener> iterator = this.myLock;
        synchronized (iterator) {
            this.myCancelled.set(true);
            if (this.myPrevLocalFile != null) {
                this.myLocalVirtualFile = this.myPrevLocalFile;
                this.myLocalFile = VfsUtilCore.virtualToIoFile((VirtualFile)this.myLocalVirtualFile);
                this.myState = RemoteFileState.DOWNLOADED;
                this.myErrorMessage = null;
            } else {
                this.myState = RemoteFileState.ERROR_OCCURRED;
            }
        }
        for (FileDownloadingListener listener2 : this.myListeners) {
            listener2.downloadingCancelled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(@Nullable Runnable postRunnable) {
        VirtualFile localVirtualFile;
        Object object = this.myLock;
        synchronized (object) {
            localVirtualFile = this.myLocalVirtualFile;
        }
        RemoteContentProvider contentProvider = this.myManager.findContentProvider(this.myUrl);
        if (localVirtualFile == null || !contentProvider.equals(this.myContentProvider) || !contentProvider.isUpToDate(this.myUrl, localVirtualFile)) {
            this.myContentProvider = contentProvider;
            this.addDownloadingListener(new MyRefreshingDownloadingListener(postRunnable));
            this.restartDownloading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Promise<VirtualFile> download() {
        Object object = this.myLock;
        // MONITORENTER : object
        switch (this.getState()) {
            case DOWNLOADING_NOT_STARTED: {
                this.startDownloading();
                Promise<VirtualFile> promise = RemoteFileInfoImpl.createDownloadedCallback(this);
                // MONITOREXIT : object
                if (promise != null) return promise;
                RemoteFileInfoImpl.$$$reportNull$$$0(6);
                return promise;
            }
            case DOWNLOADING_IN_PROGRESS: {
                Promise<VirtualFile> promise = RemoteFileInfoImpl.createDownloadedCallback(this);
                // MONITOREXIT : object
                if (promise != null) return promise;
                RemoteFileInfoImpl.$$$reportNull$$$0(7);
                return promise;
            }
            case DOWNLOADED: {
                Promise promise = Promises.resolvedPromise((Object)this.myLocalVirtualFile);
                // MONITOREXIT : object
                if (promise != null) return promise;
                RemoteFileInfoImpl.$$$reportNull$$$0(8);
                return promise;
            }
        }
        Promise promise = Promises.rejectedPromise((String)"errorOccurred");
        // MONITOREXIT : object
        if (promise != null) return promise;
        RemoteFileInfoImpl.$$$reportNull$$$0(9);
        return promise;
    }

    @NotNull
    private static Promise<VirtualFile> createDownloadedCallback(final @NotNull RemoteFileInfo remoteFileInfo) {
        if (remoteFileInfo == null) {
            RemoteFileInfoImpl.$$$reportNull$$$0(10);
        }
        final AsyncPromise promise = new AsyncPromise();
        remoteFileInfo.addDownloadingListener(new FileDownloadingAdapter(){

            @Override
            public void fileDownloaded(@NotNull VirtualFile localFile) {
                if (localFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    remoteFileInfo.removeDownloadingListener(this);
                }
                finally {
                    promise.setResult((Object)localFile);
                }
            }

            @Override
            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
                try {
                    remoteFileInfo.removeDownloadingListener(this);
                }
                finally {
                    promise.setError(errorMessage);
                }
            }

            @Override
            public void downloadingCancelled() {
                try {
                    remoteFileInfo.removeDownloadingListener(this);
                }
                finally {
                    promise.setError("Cancelled");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "localFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/vfs/impl/http/RemoteFileInfoImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDownloaded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            RemoteFileInfoImpl.$$$reportNull$$$0(11);
        }
        return asyncPromise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/http/RemoteFileInfoImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFileInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/http/RemoteFileInfoImpl";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "download";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDownloadedCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addDownloadingListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeDownloadingListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "errorOccurred";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setProgressText";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDownloadedCallback";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyRefreshingDownloadingListener
    extends FileDownloadingAdapter {
        private final Runnable myPostRunnable;

        MyRefreshingDownloadingListener(Runnable postRunnable) {
            this.myPostRunnable = postRunnable;
        }

        @Override
        public void downloadingCancelled() {
            RemoteFileInfoImpl.this.removeDownloadingListener(this);
            if (this.myPostRunnable != null) {
                this.myPostRunnable.run();
            }
        }

        @Override
        public void fileDownloaded(@NotNull VirtualFile localFile) {
            if (localFile == null) {
                MyRefreshingDownloadingListener.$$$reportNull$$$0(0);
            }
            RemoteFileInfoImpl.this.removeDownloadingListener(this);
            if (this.myPostRunnable != null) {
                this.myPostRunnable.run();
            }
        }

        @Override
        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                MyRefreshingDownloadingListener.$$$reportNull$$$0(1);
            }
            RemoteFileInfoImpl.this.removeDownloadingListener(this);
            if (this.myPostRunnable != null) {
                this.myPostRunnable.run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/impl/http/RemoteFileInfoImpl$MyRefreshingDownloadingListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDownloaded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorOccurred";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

