/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.settings;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.BeforeRunTaskImporter;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationHandler;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationHandlerKt;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationImporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\r\u001a\u00020\u000e*\u0004\u0018\u00010\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationHandler;", "Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationHandler;", "()V", "apply", "", "module", "Lcom/intellij/openapi/module/Module;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "configuration", "Lcom/intellij/openapi/externalSystem/model/project/settings/ConfigurationData;", "project", "Lcom/intellij/openapi/project/Project;", "isTrue", "", "", "intellij.platform.externalSystem.impl"})
public final class RunConfigurationHandler
implements ConfigurationHandler {
    private final boolean isTrue(@Nullable Object $this$isTrue) {
        return $this$isTrue != null && $this$isTrue instanceof Boolean && (Boolean)$this$isTrue != false;
    }

    public void apply(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ConfigurationData configuration) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
    }

    public void apply(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ConfigurationData configuration) {
        Object $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Object runCfgMap = configuration.find("runConfigurations");
        if (!(runCfgMap instanceof List)) {
            return;
        }
        RunManagerEx runManagerEx = RunManagerEx.getInstanceEx(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)runManagerEx), (String)"RunManagerEx.getInstanceEx(project)");
        RunManagerEx runManager = runManagerEx;
        Iterable $this$filterIsInstance$iv = (Iterable)runCfgMap;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv222 = new ArrayList();
        boolean $i$f$filterIsInstanceTo3222 = false;
        Object object = $this$filterIsInstanceTo$iv$iv.iterator();
        while (object.hasNext()) {
            Object element$iv$iv = object.next();
            if (!(element$iv$iv instanceof Map)) continue;
            destination$iv$iv222.add(element$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv222;
        boolean $i$f$sortedByDescending2 = false;
        $this$filterIsInstanceTo$iv$iv = $this$sortedByDescending$iv;
        boolean destination$iv$iv222 = false;
        Comparator $i$f$filterIsInstanceTo3222 = new Comparator<T>(this){
            final /* synthetic */ RunConfigurationHandler this$0;
            {
                this.this$0 = runConfigurationHandler;
            }

            public final int compare(T a, T b) {
                boolean bl = false;
                Map it = (Map)b;
                boolean bl2 = false;
                Map map2 = it;
                String string = "defaults";
                RunConfigurationHandler runConfigurationHandler = this.this$0;
                boolean bl3 = false;
                V v = map2.get(string);
                it = (Map)a;
                Comparable comparable = Boolean.valueOf(RunConfigurationHandler.access$isTrue(runConfigurationHandler, v));
                bl2 = false;
                map2 = it;
                string = "defaults";
                runConfigurationHandler = this.this$0;
                bl3 = false;
                v = map2.get(string);
                Boolean bl4 = RunConfigurationHandler.access$isTrue(runConfigurationHandler, v);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)bl4);
            }
        };
        Iterator iterator = CollectionsKt.sortedWith((Iterable)$this$filterIsInstanceTo$iv$iv, (Comparator)$i$f$filterIsInstanceTo3222).iterator();
        while (iterator.hasNext()) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings;
            String typeName;
            String string;
            Map cfg;
            Map $i$f$sortedByDescending2 = cfg = (Map)iterator.next();
            $this$filterIsInstanceTo$iv$iv = "name";
            destination$iv$iv222 = false;
            Object v = $i$f$sortedByDescending2.get($this$filterIsInstanceTo$iv$iv);
            if (!(v instanceof String)) {
                v = null;
            }
            if ((string = (String)v) == null) {
                string = "";
            }
            String name = string;
            $this$filterIsInstanceTo$iv$iv = cfg;
            String destination$iv$iv222 = "type";
            boolean $i$f$filterIsInstanceTo3222 = false;
            Object v2 = $this$filterIsInstanceTo$iv$iv.get(destination$iv$iv222);
            if (!(v2 instanceof String)) {
                v2 = null;
            }
            if ((typeName = (String)v2) == null) {
                RunConfigurationHandlerKt.getLOG().warn("Missing type for run configuration: '" + name + "', skipping");
                continue;
            }
            RunConfigurationImporter importer = RunConfigurationHandlerKt.access$handlerForType(typeName);
            if (importer == null) {
                RunConfigurationHandlerKt.getLOG().warn("No importers for run configuration '" + name + "' with type '" + typeName + "', skipping");
                continue;
            }
            Map $i$f$filterIsInstanceTo3222 = cfg;
            object = "defaults";
            RunConfigurationHandler runConfigurationHandler = this;
            boolean bl = false;
            Object v3 = $i$f$filterIsInstanceTo3222.get(object);
            boolean isDefaults = runConfigurationHandler.isTrue(v3);
            if (isDefaults) {
                ConfigurationFactory configurationFactory = importer.getConfigurationFactory();
                Intrinsics.checkExpressionValueIsNotNull((Object)configurationFactory, (String)"importer.configurationFactory");
                runnerAndConfigurationSettings = runManager.getConfigurationTemplate(configurationFactory);
            } else {
                ConfigurationFactory configurationFactory = importer.getConfigurationFactory();
                Intrinsics.checkExpressionValueIsNotNull((Object)configurationFactory, (String)"importer.configurationFactory");
                runnerAndConfigurationSettings = runManager.createConfiguration(name, configurationFactory);
            }
            RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = runnerAndConfigurationSettings;
            try {
                List tasksList;
                Object v4;
                Map map2 = cfg;
                if (map2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
                }
                importer.process(project, runnerAndConfigurationSettings2.getConfiguration(), map2, modelsProvider);
                if (!isDefaults) {
                    runManager.addConfiguration(runnerAndConfigurationSettings2);
                }
                if (!((v4 = cfg.get("beforeRun")) instanceof List)) {
                    v4 = null;
                }
                List list2 = (List)v4;
                if (list2 == null) continue;
                object = list2;
                bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)runnerAndConfigurationSettings2.getConfiguration().getBeforeRunTasks(), (String)"runnerAndConfigurationSe\u2026ation.getBeforeRunTasks()");
                Iterator iterator2 = CollectionsKt.filterIsInstance((Iterable)((Iterable)it), Map.class).iterator();
                while (iterator2.hasNext()) {
                    String typeName2;
                    Map beforeRunConfig;
                    Map map3 = beforeRunConfig = (Map)iterator2.next();
                    String string2 = "type";
                    boolean bl4 = false;
                    Object v5 = map3.get(string2);
                    if (!(v5 instanceof String)) {
                        v5 = null;
                    }
                    if ((String)v5 == null) {
                        continue;
                    }
                    BeforeRunTaskImporter beforeRunTaskImporter = RunConfigurationHandlerKt.access$importerForType(typeName2);
                    if (beforeRunTaskImporter == null) continue;
                    map3 = beforeRunTaskImporter;
                    boolean bl5 = false;
                    bl4 = false;
                    Map importer2 = map3;
                    boolean bl6 = false;
                    Map map4 = beforeRunConfig;
                    if (map4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, *>");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)importer2.process(project, modelsProvider, runnerAndConfigurationSettings2.getConfiguration(), tasksList, TypeIntrinsics.asMutableMap((Object)map4)), (String)"importer.process(project\u2026as MutableMap<String, *>)");
                }
                runManager.setBeforeRunTasks(runnerAndConfigurationSettings2.getConfiguration(), tasksList);
            }
            catch (Exception e) {
                RunConfigurationHandlerKt.getLOG().warn("Error occurred when importing run configuration " + name + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static final /* synthetic */ boolean access$isTrue(RunConfigurationHandler $this, Object $this$access_u24isTrue) {
        return $this.isTrue($this$access_u24isTrue);
    }
}

