/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.RecentLocationsAction;
import com.intellij.ide.actions.SwitcherToolWindowsListRenderer;
import com.intellij.ide.actions.ToolWindowsGroup;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsState;
import com.intellij.ide.util.gotoByName.QuickSearchComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.SpeedSearchObjectWithWeight;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.PopupUpdateProcessorBase;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Switcher
extends AnAction
implements DumbAware {
    private static final Key<SwitcherPanel> SWITCHER_KEY = Key.create((String)"SWITCHER_KEY");
    private static final Color SEPARATOR_COLOR = JBColor.namedColor((String)"Popup.separatorColor", (Color)new JBColor((Color)Gray.xC0, (Color)Gray.x4B));
    private static final String TOGGLE_CHECK_BOX_ACTION_ID = "SwitcherRecentEditedChangedToggleCheckBox";
    private static final int MINIMUM_HEIGHT = JBUIScale.scale((int)100);
    private static final Color ON_MOUSE_OVER_BG_COLOR = new JBColor(new Color(231, 242, 249), new Color(77, 80, 84));

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            Switcher.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            Switcher.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        SwitcherPanel switcher = (SwitcherPanel)SWITCHER_KEY.get((UserDataHolder)project);
        boolean isNewSwitcher = false;
        if (switcher != null && switcher.isPinnedMode()) {
            switcher.cancel();
            switcher = null;
        }
        if (switcher == null) {
            isNewSwitcher = true;
            switcher = Switcher.createAndShowSwitcher(project, "Switcher", "Switcher", false, false);
            FeatureUsageTracker.getInstance().triggerFeatureUsed("switcher");
        }
        if (!switcher.isPinnedMode()) {
            if (e.getInputEvent() != null && e.getInputEvent().isShiftDown()) {
                switcher.goBack();
            } else if (isNewSwitcher && !FileEditorManagerEx.getInstanceEx(project).hasOpenedFile()) {
                switcher.files.setSelectedIndex(0);
            } else {
                switcher.goForward();
            }
        }
    }

    @Deprecated
    @Nullable
    public static SwitcherPanel createAndShowSwitcher(@NotNull AnActionEvent e, @NotNull String title, boolean pinned, @Nullable VirtualFile[] vFiles) {
        if (e == null) {
            Switcher.$$$reportNull$$$0(2);
        }
        if (title == null) {
            Switcher.$$$reportNull$$$0(3);
        }
        return Switcher.createAndShowSwitcher(e, title, "RecentFiles", pinned, vFiles != null);
    }

    @Nullable
    public static SwitcherPanel createAndShowSwitcher(@NotNull AnActionEvent e, @NotNull String title, @NotNull String actionId, boolean onlyEdited, boolean pinned) {
        Project project;
        if (e == null) {
            Switcher.$$$reportNull$$$0(4);
        }
        if (title == null) {
            Switcher.$$$reportNull$$$0(5);
        }
        if (actionId == null) {
            Switcher.$$$reportNull$$$0(6);
        }
        if ((project = e.getProject()) == null) {
            return null;
        }
        SwitcherPanel switcher = (SwitcherPanel)SWITCHER_KEY.get((UserDataHolder)project);
        if (switcher != null) {
            boolean sameShortcut = Comparing.equal((String)switcher.myTitle, (String)title);
            if (sameShortcut) {
                if (switcher.isCheckboxMode() && e.getInputEvent() instanceof KeyEvent && KeymapUtil.isEventForAction((KeyEvent)((KeyEvent)e.getInputEvent()), (String)TOGGLE_CHECK_BOX_ACTION_ID)) {
                    switcher.toggleShowEditedFiles();
                } else {
                    switcher.goForward();
                }
                return null;
            }
            if (switcher.isCheckboxMode()) {
                switcher.setShowOnlyEditedFiles(onlyEdited);
                return null;
            }
        }
        return Switcher.createAndShowSwitcher(project, title, actionId, onlyEdited, pinned);
    }

    @NotNull
    private static SwitcherPanel createAndShowSwitcher(@NotNull Project project, @NotNull String title, @NotNull String actionId, boolean onlyEdited, boolean pinned) {
        if (project == null) {
            Switcher.$$$reportNull$$$0(7);
        }
        if (title == null) {
            Switcher.$$$reportNull$$$0(8);
        }
        if (actionId == null) {
            Switcher.$$$reportNull$$$0(9);
        }
        SwitcherPanel switcher = new SwitcherPanel(project, title, actionId, onlyEdited, pinned);
        SWITCHER_KEY.set((UserDataHolder)project, (Object)switcher);
        SwitcherPanel switcherPanel = switcher;
        if (switcherPanel == null) {
            Switcher.$$$reportNull$$$0(10);
        }
        return switcherPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/Switcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/Switcher";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndShowSwitcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAndShowSwitcher";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileInfo
    extends Pair<VirtualFile, EditorWindow> {
        private final Project myProject;
        private String myNameForRendering;

        FileInfo(VirtualFile first, EditorWindow second, Project project) {
            super((Object)first, (Object)second);
            this.myProject = project;
        }

        String getNameForRendering() {
            if (this.myNameForRendering == null) {
                this.myNameForRendering = EditorTabPresentationUtil.getUniqueEditorTabTitle(this.myProject, (VirtualFile)this.first, (EditorWindow)this.second);
            }
            return this.myNameForRendering;
        }
    }

    private static class VirtualFilesRenderer
    extends ColoredListCellRenderer<FileInfo> {
        private final SwitcherPanel mySwitcherPanel;
        boolean open;

        VirtualFilesRenderer(@NotNull SwitcherPanel switcherPanel) {
            if (switcherPanel == null) {
                VirtualFilesRenderer.$$$reportNull$$$0(0);
            }
            this.mySwitcherPanel = switcherPanel;
        }

        protected void customizeCellRenderer(@NotNull JList<? extends FileInfo> list2, FileInfo value, int index, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                VirtualFilesRenderer.$$$reportNull$$$0(1);
            }
            Project project = this.mySwitcherPanel.project;
            VirtualFile virtualFile = (VirtualFile)value.getFirst();
            String renderedName = value.getNameForRendering();
            this.setIcon(IconUtil.getIcon((VirtualFile)virtualFile, (int)2, (Project)project));
            FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(virtualFile);
            this.open = FileEditorManager.getInstance((Project)project).isFileOpen(virtualFile);
            boolean hasProblem = WolfTheProblemSolver.getInstance((Project)project).isProblemFile(virtualFile);
            TextAttributes attributes = new TextAttributes(fileStatus.getColor(), null, (Color)(hasProblem ? JBColor.red : null), EffectType.WAVE_UNDERSCORE, 0);
            this.append(renderedName, SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
            Color color = EditorTabPresentationUtil.getFileBackgroundColor(project, virtualFile);
            if (!selected2 && color != null) {
                this.setBackground(color);
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)this.mySwitcherPanel, (SimpleColoredComponent)this, (boolean)false, (boolean)selected2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switcherPanel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/Switcher$VirtualFilesRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyCheckBox
    extends JBCheckBox {
        private MyCheckBox(@NotNull String actionId, boolean selected2) {
            if (actionId == null) {
                MyCheckBox.$$$reportNull$$$0(0);
            }
            super(MyCheckBox.layoutText(actionId), selected2);
            this.setOpaque(false);
            this.setFocusable(false);
        }

        private static String layoutText(@NotNull String actionId) {
            if (actionId == null) {
                MyCheckBox.$$$reportNull$$$0(1);
            }
            ShortcutSet shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)actionId);
            return "<html>" + IdeBundle.message((String)"recent.files.checkbox.label", (Object[])new Object[0]) + " <font color=\"" + RecentLocationsAction.SHORTCUT_HEX_COLOR + "\">" + KeymapUtil.getShortcutsText((Shortcut[])shortcuts.getShortcuts()) + "</font></html>";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "actionId";
            objectArray2[1] = "com/intellij/ide/actions/Switcher$MyCheckBox";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "layoutText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SwitcherPanel
    extends JPanel
    implements KeyListener,
    MouseListener,
    MouseMotionListener,
    DataProvider,
    QuickSearchComponent {
        final JBPopup myPopup;
        final JBList<ToolWindow> toolWindows;
        final JBList<FileInfo> files;
        final JPanel separator;
        final ToolWindowManager twManager;
        final JBCheckBox myShowOnlyEditedFilesCheckBox;
        final JLabel pathLabel;
        final JPanel myTopPanel;
        final JPanel descriptions;
        final Project project;
        final boolean myPinned;
        final Map<String, ToolWindow> twShortcuts;
        final Alarm myAlarm;
        final SwitcherSpeedSearch mySpeedSearch;
        final String myTitle;
        final int myBaseModifier;
        private JBPopup myHint;
        final ClickListener myClickListener;
        KeyEvent lastEvent;
        private boolean mouseMovedFirstTime;
        private JList mouseMoveSrc;
        private int mouseMoveListIndex;

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            List list2;
            if (dataId == null) {
                SwitcherPanel.$$$reportNull$$$0(0);
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.project;
            }
            if (PlatformDataKeys.SELECTED_ITEM.is(dataId)) {
                List list3 = this.getSelectedList().getSelectedValuesList();
                Object o = ContainerUtil.getOnlyItem((Collection)list3);
                return o instanceof FileInfo ? ((FileInfo)((Object)o)).first : null;
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId) && !(list2 = this.getSelectedList().getSelectedValuesList()).isEmpty()) {
                ArrayList<Object> vFiles = new ArrayList<Object>();
                for (Object o : list2) {
                    if (!(o instanceof FileInfo)) continue;
                    vFiles.add(((FileInfo)((Object)o)).first);
                }
                return vFiles.isEmpty() ? null : vFiles.toArray(VirtualFile.EMPTY_ARRAY);
            }
            return null;
        }

        private static void exchangeSelectionState(JBList toClear, JBList toSelect2) {
            if (toSelect2.getModel().getSize() > 0) {
                int index = Math.min(toClear.getSelectedIndex(), toSelect2.getModel().getSize() - 1);
                toSelect2.setSelectedIndex(index);
                toSelect2.ensureIndexIsVisible(index);
                toClear.clearSelection();
            }
        }

        SwitcherPanel(@NotNull Project project, @NotNull String title, @NotNull String actionId, boolean onlyEdited, boolean pinned) {
            Window window;
            if (project == null) {
                SwitcherPanel.$$$reportNull$$$0(1);
            }
            if (title == null) {
                SwitcherPanel.$$$reportNull$$$0(2);
            }
            if (actionId == null) {
                SwitcherPanel.$$$reportNull$$$0(3);
            }
            this.pathLabel = new JLabel(" ");
            this.myClickListener = new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (myPinned && (e.isControlDown() || e.isMetaDown() || e.isShiftDown())) {
                        return false;
                    }
                    Object source = e.getSource();
                    if (source instanceof JList) {
                        JList jList = (JList)source;
                        if (jList.getSelectedIndex() == -1 && jList.getAnchorSelectionIndex() != -1) {
                            jList.setSelectedIndex(jList.getAnchorSelectionIndex());
                        }
                        if (jList.getSelectedIndex() != -1) {
                            this.navigate(e);
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$1", "onClick"));
                }
            };
            this.mouseMovedFirstTime = true;
            this.mouseMoveSrc = null;
            this.mouseMoveListIndex = -1;
            this.setLayout(new SwitcherLayouter());
            this.project = project;
            this.myTitle = title;
            this.myPinned = pinned;
            this.mySpeedSearch = pinned ? new SwitcherSpeedSearch(this) : null;
            this.setBorder((Border)JBUI.Borders.empty());
            this.setBackground(JBColor.background());
            this.pathLabel.setHorizontalAlignment(2);
            Font font = this.pathLabel.getFont();
            this.pathLabel.setFont(font.deriveFont(Math.max(10.0f, (float)font.getSize() - 4.0f)));
            this.descriptions = new JPanel(new BorderLayout());
            this.pathLabel.setBorder(JBUI.CurrentTheme.Advertiser.border());
            this.pathLabel.setForeground(JBUI.CurrentTheme.Advertiser.foreground());
            this.pathLabel.setBackground(JBUI.CurrentTheme.Advertiser.background());
            this.pathLabel.setOpaque(true);
            this.descriptions.setBorder((Border)new CustomLineBorder(JBUI.CurrentTheme.Advertiser.borderColor(), (Insets)JBUI.insetsTop((int)1)));
            this.descriptions.add((Component)this.pathLabel, "Center");
            this.twManager = ToolWindowManager.getInstance((Project)project);
            CollectionListModel twModel = new CollectionListModel((Object[])new ToolWindow[0]);
            List<ActivateToolWindowAction> actions = ToolWindowsGroup.getToolWindowActions(project, true);
            ArrayList<ToolWindow> windows = new ArrayList<ToolWindow>();
            for (Object action2 : actions) {
                ToolWindow tw = this.twManager.getToolWindow(action2.getToolWindowId());
                if (!tw.isAvailable()) continue;
                windows.add(tw);
            }
            this.twShortcuts = SwitcherPanel.createShortcuts(windows);
            Map map2 = ContainerUtil.reverseMap(this.twShortcuts);
            Collections.sort(windows, (o1, o2) -> StringUtil.compare((String)((String)map2.get(o1)), (String)((String)map2.get(o2)), (boolean)false));
            for (ToolWindow window2 : windows) {
                twModel.add((Object)window2);
            }
            this.toolWindows = SwitcherPanel.createList(twModel, ToolWindow::getStripeTitle, this.mySpeedSearch, pinned);
            this.toolWindows.addFocusListener((FocusListener)new MyToolWindowsListFocusListener());
            this.toolWindows.setBorder((Border)JBUI.Borders.empty((int)5, (int)5, (int)5, (int)20));
            this.toolWindows.setSelectionMode(pinned ? 2 : 0);
            this.toolWindows.setCellRenderer((ListCellRenderer)((Object)new SwitcherToolWindowsListRenderer(this.mySpeedSearch, map2, this.myPinned){

                @NotNull
                public Component getListCellRendererComponent(@NotNull JList<? extends ToolWindow> list2, ToolWindow value, int index, boolean selected2, boolean hasFocus) {
                    if (list2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    JComponent renderer2 = (JComponent)super.getListCellRendererComponent(list2, (Object)value, index, selected2, selected2);
                    if (selected2) {
                        JComponent jComponent = renderer2;
                        if (jComponent == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return jComponent;
                    }
                    Color bgColor = list2 == mouseMoveSrc && index == mouseMoveListIndex ? ON_MOUSE_OVER_BG_COLOR : list2.getBackground();
                    UIUtil.changeBackGround((Component)renderer2, (Color)bgColor);
                    JComponent jComponent = renderer2;
                    if (jComponent == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return jComponent;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "list";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/actions/Switcher$SwitcherPanel$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/actions/Switcher$SwitcherPanel$2";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getListCellRendererComponent";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getListCellRendererComponent";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }));
            this.toolWindows.addKeyListener((KeyListener)this);
            ScrollingUtil.installActions(this.toolWindows);
            this.toolWindows.addMouseListener((MouseListener)this);
            this.toolWindows.addMouseMotionListener((MouseMotionListener)this);
            ScrollingUtil.ensureSelectionExists(this.toolWindows);
            this.myClickListener.installOn(this.toolWindows);
            this.toolWindows.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(@NotNull ListSelectionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (!toolWindows.isSelectionEmpty() && !files.isSelectionEmpty()) {
                        files.clearSelection();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$3", "valueChanged"));
                }
            });
            this.separator = new JPanel();
            this.separator.setBorder((Border)new CustomLineBorder(SEPARATOR_COLOR, (Insets)JBUI.insetsLeft((int)1)));
            this.separator.setPreferredSize((Dimension)JBUI.size((int)9, (int)10));
            this.separator.setBackground(this.toolWindows.getBackground());
            Pair<List<FileInfo>, Integer> filesAndSelection = SwitcherPanel.getFilesToShowAndSelectionIndex(project, SwitcherPanel.collectFiles(project, onlyEdited), this.toolWindows.getModel().getSize(), pinned);
            int selectionIndex = (Integer)filesAndSelection.getSecond();
            CollectionListModel filesModel = new CollectionListModel((Object[])new FileInfo[0]);
            for (FileInfo editor : (List)filesAndSelection.getFirst()) {
                filesModel.add((Object)editor);
            }
            VirtualFilesRenderer filesRenderer = new VirtualFilesRenderer(this){
                final JPanel myPanel;
                {
                    super(switcherPanel);
                    this.myPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
                    this.myPanel.setBackground(UIUtil.getListBackground());
                }

                @NotNull
                public Component getListCellRendererComponent(@NotNull JList<? extends FileInfo> list2, FileInfo value, int index, boolean selected2, boolean hasFocus) {
                    if (list2 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    Component c2 = super.getListCellRendererComponent(list2, (Object)value, index, selected2, selected2);
                    this.myPanel.removeAll();
                    this.myPanel.add(c2, "Center");
                    this.myPanel.getAccessibleContext().setAccessibleName(c2.getAccessibleContext().getAccessibleName());
                    VirtualFile file2 = (VirtualFile)value.first;
                    String presentableUrl = ((VirtualFile)ObjectUtils.notNull((Object)file2.getParent(), (Object)file2)).getPresentableUrl();
                    String location = FileUtil.getLocationRelativeToUserHome((String)presentableUrl);
                    this.myPanel.getAccessibleContext().setAccessibleDescription(location);
                    if (!selected2 && list2 == mouseMoveSrc && index == mouseMoveListIndex) {
                        this.setBackground(ON_MOUSE_OVER_BG_COLOR);
                    }
                    JPanel jPanel = this.myPanel;
                    if (jPanel == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return jPanel;
                }

                @Override
                protected void customizeCellRenderer(@NotNull JList<? extends FileInfo> list2, FileInfo value, int index, boolean selected2, boolean hasFocus) {
                    if (list2 == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    this.setPaintFocusBorder(false);
                    super.customizeCellRenderer(list2, value, index, selected2, hasFocus);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "list";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/actions/Switcher$SwitcherPanel$4";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/actions/Switcher$SwitcherPanel$4";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getListCellRendererComponent";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getListCellRendererComponent";
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "customizeCellRenderer";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            ListSelectionListener filesSelectionListener = new ListSelectionListener(){

                @Nullable
                private String getTitle2Text(@Nullable String fullText) {
                    int labelWidth = pathLabel.getWidth();
                    if (fullText == null || fullText.length() == 0) {
                        return " ";
                    }
                    while (pathLabel.getFontMetrics(pathLabel.getFont()).stringWidth(fullText) > labelWidth) {
                        int sep = fullText.indexOf(File.separatorChar, 4);
                        if (sep < 0) {
                            return fullText;
                        }
                        fullText = "..." + fullText.substring(sep);
                    }
                    return fullText;
                }

                @Override
                public void valueChanged(@NotNull ListSelectionEvent e) {
                    PopupUpdateProcessorBase popupUpdater;
                    if (e == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    FileInfo selectedInfo = (FileInfo)((Object)ContainerUtil.getOnlyItem((Collection)files.getSelectedValuesList()));
                    if (selectedInfo != null) {
                        String presentableUrl = ((VirtualFile)ObjectUtils.notNull((Object)((VirtualFile)selectedInfo.first).getParent(), (Object)selectedInfo.first)).getPresentableUrl();
                        pathLabel.setText(this.getTitle2Text(FileUtil.getLocationRelativeToUserHome((String)presentableUrl)));
                    } else {
                        pathLabel.setText(" ");
                    }
                    PopupUpdateProcessorBase popupUpdateProcessorBase = popupUpdater = myHint == null || !myHint.isVisible() ? null : (PopupUpdateProcessorBase)myHint.getUserData(PopupUpdateProcessorBase.class);
                    if (popupUpdater != null) {
                        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
                        popupUpdater.updatePopup(CommonDataKeys.PSI_ELEMENT.getData(dataContext));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$5", "valueChanged"));
                }
            };
            this.files = SwitcherPanel.createList(filesModel, FileInfo::getNameForRendering, this.mySpeedSearch, pinned);
            this.files.setSelectionMode(pinned ? 2 : 0);
            this.files.getSelectionModel().addListSelectionListener(e -> {
                if (!this.files.isSelectionEmpty() && !this.toolWindows.isSelectionEmpty()) {
                    this.toolWindows.getSelectionModel().clearSelection();
                }
            });
            this.files.getSelectionModel().addListSelectionListener(filesSelectionListener);
            this.files.setCellRenderer((ListCellRenderer)((Object)filesRenderer));
            this.files.setBorder(JBUI.Borders.empty((int)5));
            this.files.addKeyListener((KeyListener)this);
            ScrollingUtil.installActions(this.files);
            this.files.addMouseListener((MouseListener)this);
            this.files.addMouseMotionListener((MouseMotionListener)this);
            this.files.addFocusListener((FocusListener)new MyFilesListFocusListener());
            this.myClickListener.installOn(this.files);
            ScrollingUtil.ensureSelectionExists(this.files);
            this.myShowOnlyEditedFilesCheckBox = new MyCheckBox(ToggleCheckBoxAction.isEnabled() ? Switcher.TOGGLE_CHECK_BOX_ACTION_ID : actionId, onlyEdited);
            this.myTopPanel = SwitcherPanel.createTopPanel(this.myShowOnlyEditedFilesCheckBox, this.isCheckboxMode() ? IdeBundle.message((String)"title.popup.recent.files", (Object[])new Object[0]) : title, pinned);
            if (this.isCheckboxMode()) {
                this.myShowOnlyEditedFilesCheckBox.addActionListener(e -> this.setShowOnlyEditedFiles(this.myShowOnlyEditedFilesCheckBox.isSelected()));
            } else {
                this.myShowOnlyEditedFilesCheckBox.setEnabled(false);
                this.myShowOnlyEditedFilesCheckBox.setVisible(false);
            }
            this.add((Component)this.myTopPanel, "North");
            this.add((Component)this.toolWindows, "West");
            if (filesModel.getSize() > 0) {
                this.files.setAlignmentY(1.0f);
                JScrollPane pane2 = ScrollPaneFactory.createScrollPane(this.files, (boolean)true);
                pane2.setPreferredSize(new Dimension(Math.max(this.myTopPanel.getPreferredSize().width - this.toolWindows.getPreferredSize().width, this.files.getPreferredSize().width), 400));
                this.add((Component)pane2, "East");
                if (selectionIndex > -1) {
                    this.files.setSelectedIndex(selectionIndex);
                }
                this.add((Component)this.separator, "Center");
            }
            this.add((Component)this.descriptions, "South");
            ShortcutSet shortcutSet = ActionManager.getInstance().getAction("Switcher").getShortcutSet();
            int modifiers = SwitcherPanel.getModifiers(shortcutSet);
            boolean isAlt = (modifiers & 8) != 0;
            this.myBaseModifier = isAlt ? 18 : 17;
            this.files.addKeyListener((KeyListener)ArrayUtil.getLastElement((Object[])this.getKeyListeners()));
            this.toolWindows.addKeyListener((KeyListener)ArrayUtil.getLastElement((Object[])this.getKeyListeners()));
            KeymapUtil.reassignAction(this.toolWindows, (KeyStroke)KeyStroke.getKeyStroke(38, 0), (KeyStroke)KeyStroke.getKeyStroke(38, 128), (int)0, (boolean)false);
            KeymapUtil.reassignAction(this.toolWindows, (KeyStroke)KeyStroke.getKeyStroke(40, 0), (KeyStroke)KeyStroke.getKeyStroke(40, 128), (int)0, (boolean)false);
            KeymapUtil.reassignAction(this.files, (KeyStroke)KeyStroke.getKeyStroke(38, 0), (KeyStroke)KeyStroke.getKeyStroke(38, 128), (int)0, (boolean)false);
            KeymapUtil.reassignAction(this.files, (KeyStroke)KeyStroke.getKeyStroke(40, 0), (KeyStroke)KeyStroke.getKeyStroke(40, 128), (int)0, (boolean)false);
            this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this, filesModel.getSize() > 0 ? this.files : this.toolWindows).setResizable(pinned).setModalContext(false).setFocusable(true).setRequestFocus(true).setCancelOnWindowDeactivation(true).setCancelOnOtherWindowOpen(true).setCancelOnClickOutside(true).setMovable(pinned).setKeyEventHandler(this::keyEvent).setMinSize(new Dimension(this.myTopPanel.getMinimumSize().width, MINIMUM_HEIGHT)).setCancelKeyEnabled(false).setCancelCallback(() -> {
                Container popupFocusAncestor = this.getPopupFocusAncestor();
                if (popupFocusAncestor != null) {
                    popupFocusAncestor.setFocusTraversalPolicy(null);
                }
                SWITCHER_KEY.set((UserDataHolder)project, null);
                return true;
            }).createPopup();
            if (this.isPinnedMode()) {
                new DumbAwareAction(null, null, null){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        if (mySpeedSearch != null && mySpeedSearch.isPopupActive()) {
                            mySpeedSearch.hidePopup();
                            Object[] elements2 = mySpeedSearch.getAllElements();
                            if (elements2 != null && elements2.length > 0) {
                                mySpeedSearch.selectElement(elements2[0], "");
                            }
                        } else {
                            myPopup.cancel();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$6", "actionPerformed"));
                    }
                }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ESCAPE"}), (JComponent)this, (Disposable)this.myPopup);
            }
            if ((window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) == null) {
                window = WindowManager.getInstance().getFrame(project);
            }
            this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myPopup);
            IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
            this.myPopup.showInCenterOf((Component)window);
            Container popupFocusAncestor = this.getPopupFocusAncestor();
            popupFocusAncestor.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
            SwitcherPanel.addFocusTraversalKeys(popupFocusAncestor, 0, "RIGHT");
            SwitcherPanel.addFocusTraversalKeys(popupFocusAncestor, 1, "LEFT");
            SwitcherPanel.addFocusTraversalKeys(popupFocusAncestor, 0, "control RIGHT");
            SwitcherPanel.addFocusTraversalKeys(popupFocusAncestor, 1, "control LEFT");
            SwitcherPanel.fromListToList(this.toolWindows, this.files);
            SwitcherPanel.fromListToList(this.files, this.toolWindows);
        }

        private boolean keyEvent(KeyEvent event) {
            ToolWindow tw;
            if (this.isPinnedMode()) {
                return false;
            }
            if (event.getID() == 402 && event.getKeyCode() == this.myBaseModifier) {
                event.consume();
                ApplicationManager.getApplication().invokeLater(() -> this.navigate(null), ModalityState.current());
                return true;
            }
            if (event.getID() == 401 && (tw = this.twShortcuts.get(String.valueOf((char)event.getKeyCode()))) != null) {
                event.consume();
                this.myPopup.closeOk(null);
                tw.activate(null, true, true);
                return true;
            }
            return false;
        }

        public void registerHint(@NotNull JBPopup h) {
            if (h == null) {
                SwitcherPanel.$$$reportNull$$$0(4);
            }
            if (this.myHint != null && this.myHint.isVisible() && this.myHint != h) {
                this.myHint.cancel();
            }
            this.myHint = h;
        }

        public void unregisterHint() {
            this.myHint = null;
        }

        @NotNull
        private static <T> JBList<T> createList(CollectionListModel<T> baseModel, Function<? super T, String> namer, SwitcherSpeedSearch speedSearch, boolean pinned) {
            NameFilteringListModel listModel = pinned ? new NameFilteringListModel(baseModel, namer, s -> !speedSearch.isPopupActive() || StringUtil.isEmpty((String)speedSearch.getEnteredPrefix()) || speedSearch.getComparator().matchingFragments(speedSearch.getEnteredPrefix(), (String)s) != null, () -> StringUtil.notNullize((String)speedSearch.getEnteredPrefix())) : baseModel;
            JBList jBList = new JBList(listModel);
            if (jBList == null) {
                SwitcherPanel.$$$reportNull$$$0(5);
            }
            return jBList;
        }

        private static void fromListToList(JBList from, final JBList to) {
            AbstractAction action2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    to.requestFocus();
                }
            };
            ActionMap map2 = from.getActionMap();
            map2.put("selectPreviousColumn", action2);
            map2.put("selectNextColumn", action2);
        }

        private Container getPopupFocusAncestor() {
            return this.myPopup.isDisposed() ? null : this.myPopup.getContent().getFocusCycleRootAncestor();
        }

        @NotNull
        private static List<VirtualFile> collectFiles(@NotNull Project project, boolean onlyEdited) {
            if (project == null) {
                SwitcherPanel.$$$reportNull$$$0(6);
            }
            List<VirtualFile> list2 = onlyEdited ? Arrays.asList(IdeDocumentHistory.getInstance(project).getChangedFiles()) : SwitcherPanel.getRecentFiles(project);
            if (list2 == null) {
                SwitcherPanel.$$$reportNull$$$0(7);
            }
            return list2;
        }

        @NotNull
        private static Pair<List<FileInfo>, Integer> getFilesToShowAndSelectionIndex(@NotNull Project project, @NotNull List<VirtualFile> filesForInit, int toolWindowsCount, boolean pinned) {
            if (project == null) {
                SwitcherPanel.$$$reportNull$$$0(8);
            }
            if (filesForInit == null) {
                SwitcherPanel.$$$reportNull$$$0(9);
            }
            int selectionIndex = -1;
            FileEditorManagerImpl editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)project);
            ArrayList<FileInfo> filesData = new ArrayList<FileInfo>();
            ArrayList<FileInfo> editors = new ArrayList<FileInfo>();
            if (!pinned && UISettings.getInstance().getEditorTabPlacement() != 0) {
                for (Pair<VirtualFile, EditorWindow> pair : editorManager.getSelectionHistory()) {
                    editors.add(new FileInfo((VirtualFile)pair.first, (EditorWindow)pair.second, project));
                }
            }
            if (editors.size() < 2) {
                int maxFiles = Math.max(editors.size(), filesForInit.size());
                int minIndex = pinned ? 0 : filesForInit.size() - Math.min(toolWindowsCount, maxFiles);
                boolean firstRecentMarked = false;
                List<VirtualFile> selectedFiles = Arrays.asList(editorManager.getSelectedFiles());
                for (int i = filesForInit.size() - 1; i >= minIndex; --i) {
                    if (pinned && selectedFiles.contains(filesForInit.get(i)) && UISettings.getInstance().getEditorTabPlacement() != 0) continue;
                    FileInfo info = new FileInfo(filesForInit.get(i), null, project);
                    boolean add = true;
                    if (pinned) {
                        for (FileInfo fileInfo : filesData) {
                            if (!((VirtualFile)fileInfo.first).equals(info.first)) continue;
                            add = false;
                            break;
                        }
                    }
                    if (!add) continue;
                    filesData.add(info);
                    if (firstRecentMarked || (selectionIndex = filesData.size() - 1) == 0 && UISettings.getInstance().getEditorTabPlacement() == 0 && pinned && !selectedFiles.isEmpty()) continue;
                    firstRecentMarked = true;
                }
                if (editors.size() == 1 && (filesData.isEmpty() || !((VirtualFile)((FileInfo)((Object)editors.get(0))).getFirst()).equals(((FileInfo)((Object)filesData.get(0))).getFirst()))) {
                    filesData.add(0, (FileInfo)((Object)editors.get(0)));
                }
            } else {
                for (int i = 0; i < Math.min(30, editors.size()); ++i) {
                    filesData.add((FileInfo)((Object)editors.get(i)));
                }
            }
            Pair pair = Pair.create(filesData, (Object)selectionIndex);
            if (pair == null) {
                SwitcherPanel.$$$reportNull$$$0(10);
            }
            return pair;
        }

        @NotNull
        private static JPanel createTopPanel(@NotNull JBCheckBox showOnlyEditedFilesCheckBox, @NotNull String title, boolean isMovable) {
            if (showOnlyEditedFilesCheckBox == null) {
                SwitcherPanel.$$$reportNull$$$0(11);
            }
            if (title == null) {
                SwitcherPanel.$$$reportNull$$$0(12);
            }
            CaptionPanel topPanel = new CaptionPanel();
            JBLabel titleLabel = new JBLabel(title);
            titleLabel.setFont(titleLabel.getFont().deriveFont(1));
            topPanel.add((Component)titleLabel, "West");
            topPanel.add((Component)showOnlyEditedFilesCheckBox, "East");
            Dimension size = topPanel.getPreferredSize();
            size.height = JBUIScale.scale((int)29);
            size.width = titleLabel.getPreferredSize().width + showOnlyEditedFilesCheckBox.getPreferredSize().width + JBUIScale.scale((int)50);
            topPanel.setPreferredSize(size);
            topPanel.setMinimumSize(size);
            topPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)8));
            if (isMovable) {
                WindowMoveListener moveListener = new WindowMoveListener((Component)topPanel);
                topPanel.addMouseListener(moveListener);
                topPanel.addMouseMotionListener(moveListener);
            }
            CaptionPanel captionPanel = topPanel;
            if (captionPanel == null) {
                SwitcherPanel.$$$reportNull$$$0(13);
            }
            return captionPanel;
        }

        private static void addFocusTraversalKeys(Container focusCycleRoot, int focusTraversalType, String keyStroke) {
            Set<AWTKeyStroke> focusTraversalKeySet = focusCycleRoot.getFocusTraversalKeys(focusTraversalType);
            HashSet<AWTKeyStroke> set = new HashSet<AWTKeyStroke>(focusTraversalKeySet);
            set.add(KeyStroke.getKeyStroke(keyStroke));
            focusCycleRoot.setFocusTraversalKeys(focusTraversalType, set);
        }

        @NotNull
        private static List<VirtualFile> getRecentFiles(@NotNull Project project) {
            if (project == null) {
                SwitcherPanel.$$$reportNull$$$0(14);
            }
            List<VirtualFile> recentFiles = EditorHistoryManager.getInstance(project).getFileList();
            Object[] openFiles = FileEditorManager.getInstance((Project)project).getOpenFiles();
            HashSet<VirtualFile> recentFilesSet = new HashSet<VirtualFile>(recentFiles);
            HashSet openFilesSet = ContainerUtil.newHashSet((Object[])openFiles);
            int index = 0;
            for (int i = 0; i < recentFiles.size(); ++i) {
                if (!openFilesSet.contains(recentFiles.get(i))) continue;
                index = i;
                break;
            }
            ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(recentFiles);
            result2.addAll(index, ContainerUtil.filter((Object[])openFiles, it -> !recentFilesSet.contains(it)));
            ArrayList<VirtualFile> arrayList = result2;
            if (arrayList == null) {
                SwitcherPanel.$$$reportNull$$$0(15);
            }
            return arrayList;
        }

        @NotNull
        private static Map<String, ToolWindow> createShortcuts(@NotNull List<ToolWindow> windows) {
            if (windows == null) {
                SwitcherPanel.$$$reportNull$$$0(16);
            }
            HashMap<String, ToolWindow> keymap = new HashMap<String, ToolWindow>(windows.size());
            ArrayList<ToolWindow> otherTW = new ArrayList<ToolWindow>();
            for (ToolWindow window : windows) {
                int index = ActivateToolWindowAction.getMnemonicForToolWindow(((ToolWindowImpl)window).getId());
                if (index >= 48 && index <= 57) {
                    keymap.put(SwitcherPanel.getIndexShortcut(index - 48), window);
                    continue;
                }
                otherTW.add(window);
            }
            int i = 0;
            for (ToolWindow window : otherTW) {
                String bestShortcut = SwitcherPanel.getSmartShortcut(window, keymap);
                if (bestShortcut != null) {
                    keymap.put(bestShortcut, window);
                    continue;
                }
                while (keymap.get(SwitcherPanel.getIndexShortcut(i)) != null) {
                    ++i;
                }
                keymap.put(SwitcherPanel.getIndexShortcut(i), window);
                ++i;
            }
            HashMap<String, ToolWindow> hashMap = keymap;
            if (hashMap == null) {
                SwitcherPanel.$$$reportNull$$$0(17);
            }
            return hashMap;
        }

        @Nullable
        private static String getSmartShortcut(ToolWindow window, Map<String, ToolWindow> keymap) {
            String title = window.getStripeTitle();
            if (StringUtil.isEmpty((String)title)) {
                return null;
            }
            for (int i = 0; i < title.length(); ++i) {
                String shortcut;
                char c2 = title.charAt(i);
                if (!Character.isUpperCase(c2) || keymap.get(shortcut = String.valueOf(c2)) != null) continue;
                return shortcut;
            }
            return null;
        }

        private static String getIndexShortcut(int index) {
            return StringUtil.toUpperCase((String)Integer.toString(index, index + 1));
        }

        private static int getModifiers(@Nullable ShortcutSet shortcutSet) {
            if (shortcutSet == null || shortcutSet.getShortcuts().length == 0 || !(shortcutSet.getShortcuts()[0] instanceof KeyboardShortcut)) {
                return 2;
            }
            return ((KeyboardShortcut)shortcutSet.getShortcuts()[0]).getFirstKeyStroke().getModifiers();
        }

        @Override
        public void keyTyped(@NotNull KeyEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(18);
            }
        }

        @Override
        public void keyReleased(@NotNull KeyEvent e) {
            boolean ctrl;
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(19);
            }
            boolean bl = ctrl = e.getKeyCode() == this.myBaseModifier;
            if (ctrl && this.isAutoHide()) {
                this.navigate(e);
            }
        }

        @Override
        public void keyPressed(@NotNull KeyEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(20);
            }
            if (this.mySpeedSearch != null && this.mySpeedSearch.isPopupActive() || this.lastEvent == e) {
                return;
            }
            this.lastEvent = e;
            switch (e.getKeyCode()) {
                case 8: 
                case 81: 
                case 127: {
                    this.closeTabOrToolWindow();
                    break;
                }
                case 27: {
                    this.cancel();
                    break;
                }
                case 10: {
                    if (this.mySpeedSearch != null) break;
                    this.navigate(e);
                }
            }
        }

        private void closeTabOrToolWindow() {
            JBList<?> selectedList = this.getSelectedList();
            int[] selected2 = selectedList.getSelectedIndices();
            Arrays.sort(selected2);
            int selectedIndex = 0;
            for (int i = selected2.length - 1; i >= 0; --i) {
                selectedIndex = selected2[i];
                Object value = selectedList.getModel().getElementAt(selectedIndex);
                if (value instanceof FileInfo) {
                    FileInfo info = (FileInfo)((Object)value);
                    VirtualFile virtualFile = (VirtualFile)info.first;
                    FileEditorManagerImpl editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)this.project);
                    JBList<?> jList = this.getSelectedList();
                    EditorWindow wnd = SwitcherPanel.findAppropriateWindow(info);
                    if (wnd == null) {
                        editorManager.closeFile(virtualFile, false, false);
                    } else {
                        editorManager.closeFile(virtualFile, wnd, false);
                    }
                    IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.project);
                    this.myAlarm.cancelAllRequests();
                    this.myAlarm.addRequest(() -> {
                        Object focusTarget = selectedList;
                        if (selectedList.getModel().getSize() == 0) {
                            focusTarget = selectedList == this.files ? this.toolWindows : this.files;
                        }
                        focusManager.requestFocus((Component)focusTarget, true);
                    }, 300);
                    if (jList.getModel().getSize() == 1) {
                        SwitcherPanel.removeElementAt(jList, selectedIndex);
                        this.remove((Component)jList);
                        this.remove(this.separator);
                        Dimension size = this.toolWindows.getSize();
                        this.myPopup.setSize(new Dimension(size.width, this.myPopup.getSize().height));
                    } else {
                        SwitcherPanel.removeElementAt(jList, selectedIndex);
                        jList.setSize(jList.getPreferredSize());
                    }
                    if (!this.isPinnedMode()) continue;
                    EditorHistoryManager.getInstance(this.project).removeFile(virtualFile);
                    continue;
                }
                if (!(value instanceof ToolWindow)) continue;
                ToolWindow toolWindow = (ToolWindow)value;
                if (this.twManager instanceof ToolWindowManagerImpl) {
                    ToolWindowManagerImpl manager = (ToolWindowManagerImpl)this.twManager;
                    manager.hideToolWindow(((ToolWindowImpl)toolWindow).getId(), false, false);
                    continue;
                }
                toolWindow.hide(null);
            }
            this.pack();
            this.myPopup.getContent().revalidate();
            this.myPopup.getContent().repaint();
            if (this.getSelectedList().getModel().getSize() > selectedIndex) {
                this.getSelectedList().setSelectedIndex(selectedIndex);
                this.getSelectedList().ensureIndexIsVisible(selectedIndex);
            }
        }

        private static void removeElementAt(@NotNull JList<?> jList, int index) {
            if (jList == null) {
                SwitcherPanel.$$$reportNull$$$0(21);
            }
            ListUtil.removeItem(jList.getModel(), (int)index);
        }

        private void pack() {
            this.setSize(this.getPreferredSize());
            JRootPane rootPane = SwingUtilities.getRootPane(this);
            Container container = this;
            do {
                container = container.getParent();
                container.setSize(container.getPreferredSize());
            } while (container != rootPane);
            container.getParent().setSize(container.getPreferredSize());
        }

        private boolean isFilesSelected() {
            return this.getSelectedList() == this.files;
        }

        private boolean isFilesVisible() {
            return this.files.getModel().getSize() > 0;
        }

        private void cancel() {
            this.myPopup.cancel();
        }

        public void go(boolean forward) {
            JBList<?> selected2;
            Object list2 = selected2 = this.getSelectedList();
            int index = list2.getSelectedIndex();
            index = forward ? ++index : --index;
            if (forward && index >= list2.getModel().getSize() || !forward && index < 0) {
                if (this.isFilesVisible()) {
                    list2 = this.isFilesSelected() ? this.toolWindows : this.files;
                }
                index = forward ? 0 : list2.getModel().getSize() - 1;
            }
            list2.setSelectedIndex(index);
            list2.ensureIndexIsVisible(index);
            if (selected2 != list2) {
                IdeFocusManager.findInstanceByComponent(list2).requestFocus(list2, true);
            }
        }

        public void goForward() {
            this.go(true);
        }

        public void goBack() {
            this.go(false);
        }

        public JBList<?> getSelectedList() {
            return this.getSelectedList(this.files);
        }

        @Nullable
        JBList getSelectedList(@Nullable JBList preferable) {
            return this.files.hasFocus() ? this.files : (this.toolWindows.hasFocus() ? this.toolWindows : preferable);
        }

        boolean isCheckboxMode() {
            return this.isPinnedMode() && Experiments.isFeatureEnabled((String)"recent.and.edited.files.together");
        }

        void toggleShowEditedFiles() {
            this.myShowOnlyEditedFilesCheckBox.doClick();
        }

        void setShowOnlyEditedFiles(boolean onlyEdited) {
            if (this.myShowOnlyEditedFilesCheckBox.isSelected() != onlyEdited) {
                this.myShowOnlyEditedFilesCheckBox.setSelected(onlyEdited);
            }
            boolean listWasSelected = this.files.getSelectedIndex() != -1;
            Pair<List<FileInfo>, Integer> filesAndSelection = SwitcherPanel.getFilesToShowAndSelectionIndex(this.project, SwitcherPanel.collectFiles(this.project, onlyEdited), this.toolWindows.getModel().getSize(), this.isPinnedMode());
            int selectionIndex = (Integer)filesAndSelection.getSecond();
            ListModel model2 = this.files.getModel();
            this.files.clearSelection();
            ListUtil.removeAllItems((ListModel)model2);
            ListUtil.addAllItems((ListModel)model2, (List)((List)filesAndSelection.getFirst()));
            if (selectionIndex > -1 && listWasSelected) {
                this.files.setSelectedIndex(selectionIndex);
            }
            this.files.revalidate();
            this.files.repaint();
        }

        void navigate(InputEvent e) {
            boolean openInNewWindow = e != null && e.isShiftDown() && e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 10;
            List values = this.getSelectedList().getSelectedValuesList();
            String searchQuery = this.mySpeedSearch != null ? this.mySpeedSearch.getEnteredPrefix() : null;
            this.myPopup.cancel(null);
            if (values.isEmpty()) {
                this.tryToOpenFileSearch(e, searchQuery);
            } else if (values.get(0) instanceof ToolWindow) {
                ToolWindow toolWindow = (ToolWindow)values.get(0);
                IdeFocusManager.getInstance((Project)this.project).doWhenFocusSettlesDown(() -> toolWindow.activate(null, true, true), ModalityState.current());
            } else {
                IdeFocusManager.getInstance((Project)this.project).doWhenFocusSettlesDown(() -> {
                    FileEditorManagerImpl manager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)this.project);
                    for (Object value : values) {
                        if (!(value instanceof FileInfo)) continue;
                        FileInfo info = (FileInfo)((Object)((Object)value));
                        VirtualFile file2 = (VirtualFile)info.first;
                        if (openInNewWindow) {
                            manager.openFileInNewWindow(file2);
                            continue;
                        }
                        if (info.second != null) {
                            EditorWindow wnd = SwitcherPanel.findAppropriateWindow(info);
                            if (wnd == null) continue;
                            manager.openFileImpl2(wnd, file2, true);
                            manager.addSelectionRecord(file2, wnd);
                            continue;
                        }
                        UISettingsState settings = UISettings.getInstance().getState();
                        boolean oldValue = settings.getReuseNotModifiedTabs();
                        settings.setReuseNotModifiedTabs(false);
                        manager.openFile(file2, true, UISettings.getInstance().getEditorTabPlacement() != 0);
                        if (!oldValue) continue;
                        CommandProcessor.getInstance().executeCommand(this.project, () -> settings.setReuseNotModifiedTabs(true), "", null);
                    }
                }, ModalityState.current());
            }
        }

        private void tryToOpenFileSearch(InputEvent e, String fileName2) {
            AnAction gotoFile = ActionManager.getInstance().getAction("GotoFile");
            if (gotoFile == null || StringUtil.isEmpty((String)fileName2)) {
                return;
            }
            this.myPopup.cancel();
            ApplicationManager.getApplication().invokeLater(() -> DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(fromFocus -> {
                DataContext dataContext = SimpleDataContext.getSimpleContext(PlatformDataKeys.PREDEFINED_TEXT.getName(), fileName2, fromFocus);
                AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)gotoFile, (InputEvent)e, (String)"EditorPopup", (DataContext)dataContext);
                gotoFile.actionPerformed(event);
            }), ModalityState.current());
        }

        @Nullable
        private static EditorWindow findAppropriateWindow(@NotNull FileInfo info) {
            if (info == null) {
                SwitcherPanel.$$$reportNull$$$0(22);
            }
            if (info.second == null) {
                return null;
            }
            Object[] windows = ((EditorWindow)info.second).getOwner().getWindows();
            return ArrayUtil.contains((Object)info.second, (Object[])windows) ? (EditorWindow)info.second : (windows.length > 0 ? windows[0] : null);
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(23);
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            JList list2;
            int index;
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(24);
            }
            if (this.mouseMovedFirstTime) {
                this.mouseMovedFirstTime = false;
                return;
            }
            Object source = e.getSource();
            boolean changed = false;
            if (source instanceof JList && 0 <= (index = (list2 = (JList)source).locationToIndex(e.getPoint())) && index < list2.getModel().getSize()) {
                this.mouseMoveSrc = list2;
                this.mouseMoveListIndex = index;
                changed = true;
            }
            if (!changed) {
                this.mouseMoveSrc = null;
                this.mouseMoveListIndex = -1;
            }
            this.repaintLists();
        }

        private void repaintLists() {
            this.toolWindows.repaint();
            this.files.repaint();
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(25);
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(26);
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(27);
            }
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(28);
            }
            this.mouseMoveSrc = null;
            this.mouseMoveListIndex = -1;
            this.repaintLists();
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(29);
            }
        }

        public boolean isAutoHide() {
            return !this.myPinned;
        }

        public boolean isPinnedMode() {
            return this.myPinned;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 7: 
                case 10: 
                case 13: 
                case 15: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 7: 
                case 10: 
                case 13: 
                case 15: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 1: 
                case 6: 
                case 8: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "h";
                    break;
                }
                case 5: 
                case 7: 
                case 10: 
                case 13: 
                case 15: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/Switcher$SwitcherPanel";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filesForInit";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "showOnlyEditedFilesCheckBox";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "windows";
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jList";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/Switcher$SwitcherPanel";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createList";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectFiles";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilesToShowAndSelectionIndex";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTopPanel";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecentFiles";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createShortcuts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "registerHint";
                    break;
                }
                case 5: 
                case 7: 
                case 10: 
                case 13: 
                case 15: 
                case 17: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "collectFiles";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilesToShowAndSelectionIndex";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "createTopPanel";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getRecentFiles";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "createShortcuts";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "keyTyped";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "keyReleased";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "keyPressed";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "removeElementAt";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "findAppropriateWindow";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseClicked";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseMoved";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "mousePressed";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseReleased";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseEntered";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseExited";
                    break;
                }
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseDragged";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 7: 
                case 10: 
                case 13: 
                case 15: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class SwitcherLayouter
        extends BorderLayout {
            private Rectangle sBounds;
            private Rectangle tBounds;
            private Rectangle fBounds;
            private Rectangle dBounds;
            private Rectangle headerBounds;

            private SwitcherLayouter() {
            }

            @Override
            public void layoutContainer(@NotNull Container target2) {
                JBList<FileInfo> scrollPane;
                JBList<FileInfo> filesPane;
                if (target2 == null) {
                    SwitcherLayouter.$$$reportNull$$$0(0);
                }
                JBList<FileInfo> jBList = filesPane = (scrollPane = (JBList<FileInfo>)ComponentUtil.getParentOfType(JScrollPane.class, SwitcherPanel.this.files)) != null ? scrollPane : SwitcherPanel.this.files;
                if (this.sBounds == null || !target2.isShowing()) {
                    super.layoutContainer(target2);
                    this.sBounds = SwitcherPanel.this.separator.getBounds();
                    this.tBounds = SwitcherPanel.this.toolWindows.getBounds();
                    this.fBounds = filesPane.getBounds();
                    this.dBounds = SwitcherPanel.this.descriptions.getBounds();
                    this.headerBounds = SwitcherPanel.this.myTopPanel.getBounds();
                } else {
                    int h = target2.getHeight();
                    int w = target2.getWidth();
                    this.sBounds.height = h - this.dBounds.height - this.headerBounds.height;
                    this.tBounds.height = h - this.dBounds.height - this.headerBounds.height;
                    this.fBounds.height = h - this.dBounds.height - this.headerBounds.height;
                    this.fBounds.width = w - this.sBounds.width - this.tBounds.width;
                    this.dBounds.width = w;
                    this.headerBounds.width = w;
                    this.dBounds.y = h - this.dBounds.height;
                    SwitcherPanel.this.separator.setBounds(this.sBounds);
                    SwitcherPanel.this.toolWindows.setBounds(this.tBounds);
                    filesPane.setBounds(this.fBounds);
                    SwitcherPanel.this.descriptions.setBounds(this.dBounds);
                    SwitcherPanel.this.myTopPanel.setBounds(this.headerBounds);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/ide/actions/Switcher$SwitcherPanel$SwitcherLayouter", "layoutContainer"));
            }
        }

        private static class SwitcherSpeedSearch
        extends SpeedSearchBase<SwitcherPanel> {
            SwitcherSpeedSearch(@NotNull SwitcherPanel switcher) {
                if (switcher == null) {
                    SwitcherSpeedSearch.$$$reportNull$$$0(0);
                }
                super(switcher);
                this.setComparator(new SpeedSearchComparator(false, true));
            }

            @Override
            protected void processKeyEvent(@NotNull KeyEvent e) {
                int keyCode;
                if (e == null) {
                    SwitcherSpeedSearch.$$$reportNull$$$0(1);
                }
                if ((keyCode = e.getKeyCode()) == 10) {
                    ((SwitcherPanel)this.myComponent).navigate(e);
                    e.consume();
                    return;
                }
                if (keyCode == 37 || keyCode == 39) {
                    return;
                }
                super.processKeyEvent(e);
            }

            @Override
            protected int getSelectedIndex() {
                return ((SwitcherPanel)this.myComponent).isFilesSelected() ? ((SwitcherPanel)this.myComponent).files.getSelectedIndex() : ((SwitcherPanel)this.myComponent).files.getModel().getSize() + ((SwitcherPanel)this.myComponent).toolWindows.getSelectedIndex();
            }

            @Override
            @NotNull
            protected Object[] getAllElements() {
                ListModel filesModel = ((SwitcherPanel)this.myComponent).files.getModel();
                Object[] files2 = new Object[filesModel.getSize()];
                for (int i = 0; i < files2.length; ++i) {
                    files2[i] = filesModel.getElementAt(i);
                }
                ListModel twModel = ((SwitcherPanel)this.myComponent).toolWindows.getModel();
                Object[] toolWindows = new Object[twModel.getSize()];
                for (int i = 0; i < toolWindows.length; ++i) {
                    toolWindows[i] = twModel.getElementAt(i);
                }
                Object[] elements2 = new Object[files2.length + toolWindows.length];
                System.arraycopy(files2, 0, elements2, 0, files2.length);
                System.arraycopy(toolWindows, 0, elements2, files2.length, toolWindows.length);
                if (elements2 == null) {
                    SwitcherSpeedSearch.$$$reportNull$$$0(2);
                }
                return elements2;
            }

            @Override
            protected String getElementText(Object element) {
                if (element instanceof ToolWindow) {
                    return ((ToolWindow)element).getStripeTitle();
                }
                if (element instanceof FileInfo) {
                    return ((FileInfo)((Object)element)).getNameForRendering();
                }
                return "";
            }

            @Override
            protected void selectElement(Object element, String selectedText) {
                if (element instanceof FileInfo) {
                    if (!((SwitcherPanel)this.myComponent).toolWindows.isSelectionEmpty()) {
                        ((SwitcherPanel)this.myComponent).toolWindows.clearSelection();
                    }
                    ((SwitcherPanel)this.myComponent).files.clearSelection();
                    ((SwitcherPanel)this.myComponent).files.setSelectedValue(element, true);
                    ((SwitcherPanel)this.myComponent).files.requestFocusInWindow();
                } else {
                    if (!((SwitcherPanel)this.myComponent).files.isSelectionEmpty()) {
                        ((SwitcherPanel)this.myComponent).files.clearSelection();
                    }
                    ((SwitcherPanel)this.myComponent).toolWindows.clearSelection();
                    ((SwitcherPanel)this.myComponent).toolWindows.setSelectedValue(element, true);
                    ((SwitcherPanel)this.myComponent).toolWindows.requestFocusInWindow();
                }
            }

            @Override
            @Nullable
            protected Object findElement(String s) {
                List<SpeedSearchObjectWithWeight> elements2 = SpeedSearchObjectWithWeight.findElement(s, this);
                return elements2.isEmpty() ? null : elements2.get((int)0).node;
            }

            @Override
            protected void onSearchFieldUpdated(String pattern) {
                if (((SwitcherPanel)this.myComponent).project.isDisposed()) {
                    ((SwitcherPanel)this.myComponent).myPopup.cancel();
                    return;
                }
                ((NameFilteringListModel)((SwitcherPanel)this.myComponent).files.getModel()).refilter();
                ((NameFilteringListModel)((SwitcherPanel)this.myComponent).toolWindows.getModel()).refilter();
                if (((SwitcherPanel)this.myComponent).files.getModel().getSize() + ((SwitcherPanel)this.myComponent).toolWindows.getModel().getSize() == 0) {
                    ((SwitcherPanel)this.myComponent).toolWindows.getEmptyText().setText("");
                    ((SwitcherPanel)this.myComponent).files.getEmptyText().setText("Press 'Enter' to search in Project");
                } else {
                    ((SwitcherPanel)this.myComponent).files.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT);
                    ((SwitcherPanel)this.myComponent).toolWindows.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT);
                }
                this.refreshSelection();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "switcher";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/actions/Switcher$SwitcherPanel$SwitcherSpeedSearch";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/actions/Switcher$SwitcherPanel$SwitcherSpeedSearch";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAllElements";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "processKeyEvent";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private class MyFilesListFocusListener
        extends FocusAdapter {
            private MyFilesListFocusListener() {
            }

            @Override
            public void focusGained(FocusEvent e) {
                SwitcherPanel.exchangeSelectionState(SwitcherPanel.this.toolWindows, SwitcherPanel.this.files);
            }
        }

        private class MyToolWindowsListFocusListener
        extends FocusAdapter {
            private MyToolWindowsListFocusListener() {
            }

            @Override
            public void focusGained(FocusEvent e) {
                SwitcherPanel.exchangeSelectionState(SwitcherPanel.this.files, SwitcherPanel.this.toolWindows);
            }
        }

        private class MyFocusTraversalPolicy
        extends FocusTraversalPolicy {
            private MyFocusTraversalPolicy() {
            }

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                return aComponent == SwitcherPanel.this.toolWindows ? SwitcherPanel.this.files : SwitcherPanel.this.toolWindows;
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                return aComponent == SwitcherPanel.this.toolWindows ? SwitcherPanel.this.files : SwitcherPanel.this.toolWindows;
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                return SwitcherPanel.this.toolWindows;
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                return SwitcherPanel.this.files;
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return SwitcherPanel.this.files;
            }
        }
    }

    public static class ToggleCheckBoxAction
    extends DumbAwareAction
    implements DumbAware {
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleCheckBoxAction.$$$reportNull$$$0(0);
            }
            Project project = e.getProject();
            SwitcherPanel switcherPanel = (SwitcherPanel)SWITCHER_KEY.get((UserDataHolder)project);
            if (switcherPanel != null) {
                switcherPanel.toggleShowEditedFiles();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleCheckBoxAction.$$$reportNull$$$0(1);
            }
            Project project = e.getProject();
            e.getPresentation().setEnabledAndVisible(SWITCHER_KEY.get((UserDataHolder)project) != null);
        }

        static boolean isEnabled() {
            return KeymapUtil.getActiveKeymapShortcuts((String)Switcher.TOGGLE_CHECK_BOX_ACTION_ID).getShortcuts().length > 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/actions/Switcher$ToggleCheckBoxAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

