/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.help.impl;

import com.intellij.help.impl.MacHelpUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.help.WebHelpProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import org.jetbrains.annotations.Nullable;

public class HelpManagerImpl
extends HelpManager {
    private static final ExtensionPointName<WebHelpProvider> WEB_HELP_PROVIDER_EP_NAME = ExtensionPointName.create((String)"com.intellij.webHelpProvider");

    public void invokeHelp(@Nullable String id) {
        id = StringUtil.notNullize((String)id, (String)"top");
        for (WebHelpProvider provider : (WebHelpProvider[])WEB_HELP_PROVIDER_EP_NAME.getExtensions()) {
            String url;
            if (!id.startsWith(provider.getHelpTopicPrefix()) || (url = provider.getHelpPageUrl(id)) == null) continue;
            BrowserUtil.browse((String)url);
            return;
        }
        if (MacHelpUtil.isApplicable() && MacHelpUtil.invokeHelp(id)) {
            return;
        }
        ApplicationInfoEx info = ApplicationInfoEx.getInstanceEx();
        String productVersion = info.getMajorVersion() + "." + info.getMinorVersionMainPart();
        String url = info.getWebHelpUrl();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = url + productVersion + "/?" + URLUtil.encodeURIComponent((String)id);
        BrowserUtil.browse((String)IdeUrlTrackingParametersProvider.getInstance().augmentUrl(url));
    }
}

