/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.BrowserLauncherApplessKt;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.UrlOpener;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 +2\u00020\u0001:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJK\u0010\r\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J<\u0010\u0014\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001aH\u0014J[\u0010\u001b\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u001d2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0014\u0010\u001f\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u000e2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010#\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\"\u0010$\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010%\u001a\u00020&2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014JH\u0010'\u001a\u00020\u00042\b\u0010(\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\b2\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001aH\u0014J\u0010\u0010*\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006,"}, d2={"Lcom/intellij/ide/browsers/BrowserLauncherAppless;", "Lcom/intellij/ide/browsers/BrowserLauncher;", "()V", "browse", "", "file", "Ljava/io/File;", "url", "", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "project", "Lcom/intellij/openapi/project/Project;", "browseUsingPath", "", "browserPath", "openInNewWindow", "additionalParameters", "", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/ide/browsers/WebBrowser;Lcom/intellij/openapi/project/Project;Z[Ljava/lang/String;)Z", "checkCreatedProcess", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "process", "Ljava/lang/Process;", "launchTask", "Lkotlin/Function0;", "doLaunch", "command", "", "(Ljava/lang/String;Ljava/util/List;Lcom/intellij/ide/browsers/WebBrowser;Lcom/intellij/openapi/project/Project;[Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Z", "getEffectiveBrowser", "open", "openOrBrowse", "_url", "openWithDefaultBrowser", "openWithExplicitBrowser", "settings", "Lcom/intellij/ide/GeneralSettings;", "showError", "error", "title", "signUrl", "Companion", "intellij.platform.ide"})
public class BrowserLauncherAppless
extends BrowserLauncher {
    public static final Companion Companion = new Companion(null);

    @Override
    public void open(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        BrowserLauncherAppless.openOrBrowse$default(this, url, false, null, 4, null);
    }

    @Override
    public void browse(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String path2 = file.getAbsolutePath();
        if (SystemInfo.isWindows && path2.charAt(0) != '/') {
            path2 = '/' + path2;
        }
        BrowserLauncherAppless.openOrBrowse$default(this, "file://" + path2, true, null, 4, null);
    }

    protected void openWithExplicitBrowser(@NotNull String url, @NotNull GeneralSettings settings, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        BrowserLauncher.browseUsingPath$default(this, url, settings.getBrowserPath(), null, project, false, null, 52, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void openOrBrowse(String _url, boolean browse, Project project) {
        void $this$trim$iv;
        String string = _url;
        BrowserLauncherAppless browserLauncherAppless = this;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = it <= ' ';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        String url = browserLauncherAppless.signUrl(string2);
        Logger $this$debug$iv = BrowserLauncherApplessKt.access$getLOG$p();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            browserLauncherAppless = $this$debug$iv;
            boolean bl = false;
            string2 = "opening [" + url + ']';
            browserLauncherAppless.debug(string2, e$iv);
        }
        if (StringsKt.startsWith$default((String)url, (String)"mailto:", (boolean)false, (int)2, null) && Desktop.getDesktop().isSupported(Desktop.Action.MAIL)) {
            try {
                BrowserLauncherApplessKt.access$getLOG$p().debug("Trying Desktop#mail");
                Desktop.getDesktop().mail(new URI(url));
            }
            catch (Exception e) {
                BrowserLauncherApplessKt.access$getLOG$p().warn('[' + url + ']', (Throwable)e);
            }
            return;
        }
        if (!BrowserUtil.isAbsoluteURL(url)) {
            File file = new File(url);
            if (!browse && BrowserLauncherApplessKt.access$isDesktopActionSupported(Desktop.Action.OPEN)) {
                if (!file.exists()) {
                    BrowserLauncherAppless.showError$default(this, IdeBundle.message("error.file.does.not.exist", file.getPath()), null, project, null, null, 26, null);
                    return;
                }
                try {
                    BrowserLauncherApplessKt.access$getLOG$p().debug("Trying Desktop#open");
                    Desktop.getDesktop().open(file);
                    return;
                }
                catch (IOException e) {
                    BrowserLauncherApplessKt.access$getLOG$p().warn('[' + url + ']', (Throwable)e);
                }
            }
            this.browse(file);
            return;
        }
        GeneralSettings settings = BrowserLauncherApplessKt.access$getGeneralSettings$p();
        if (settings.isUseDefaultBrowser()) {
            this.openWithDefaultBrowser(url, project);
        } else {
            this.openWithExplicitBrowser(url, settings, project);
        }
    }

    static /* synthetic */ void openOrBrowse$default(BrowserLauncherAppless browserLauncherAppless, String string, boolean bl, Project project, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openOrBrowse");
        }
        if ((n & 4) != 0) {
            project = null;
        }
        browserLauncherAppless.openOrBrowse(string, bl, project);
    }

    private final void openWithDefaultBrowser(String url, Project project) {
        List command;
        block6: {
            if (BrowserLauncherApplessKt.access$isDesktopActionSupported(Desktop.Action.BROWSE)) {
                URI uri = VfsUtil.toUri(url);
                if (uri == null) {
                    BrowserLauncherAppless.showError$default(this, IdeBundle.message("error.malformed.url", url), null, project, null, null, 26, null);
                    return;
                }
                try {
                    BrowserLauncherApplessKt.access$getLOG$p().debug("Trying Desktop#browse");
                    Desktop.getDesktop().browse(uri);
                    return;
                }
                catch (Exception e) {
                    BrowserLauncherApplessKt.access$getLOG$p().warn('[' + url + ']', (Throwable)e);
                    if (!SystemInfo.isMac) break block6;
                    String string = e.getMessage();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"Error code: -10814", (boolean)false, (int)2, null)) break block6;
                    return;
                }
            }
        }
        if ((command = BrowserLauncherApplessKt.access$getDefaultBrowserCommand$p()) == null) {
            BrowserLauncherAppless.showError$default(this, IdeBundle.message("browser.default.not.supported", new Object[0]), null, project, null, null, 26, null);
            return;
        }
        BrowserLauncherAppless.doLaunch$default(this, url, command, null, project, null, null, 48, null);
    }

    @NotNull
    protected String signUrl(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return url;
    }

    @Override
    public final void browse(@NotNull String url, @Nullable WebBrowser browser, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        WebBrowser effectiveBrowser = this.getEffectiveBrowser(browser);
        if (effectiveBrowser == null || browser == null && !StringsKt.startsWith$default((String)url, (String)"http", (boolean)false, (int)2, null)) {
            this.openOrBrowse(url, true, project);
        } else {
            ExtensionPointName<UrlOpener> extensionPointName = UrlOpener.EP_NAME;
            Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"UrlOpener.EP_NAME");
            Object[] objectArray = extensionPointName.getExtensions();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"UrlOpener.EP_NAME.extensions");
            Object[] $this$any$iv = objectArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                UrlOpener it = (UrlOpener)element$iv;
                boolean bl = false;
                if (it.openUrl(effectiveBrowser, this.signUrl(url), project)) break;
            }
        }
    }

    @Override
    public boolean browseUsingPath(@Nullable String url, @Nullable String browserPath, @Nullable WebBrowser browser, @Nullable Project project, boolean openInNewWindow, @NotNull String[] additionalParameters) {
        String string;
        boolean byName;
        Intrinsics.checkParameterIsNotNull((Object)additionalParameters, (String)"additionalParameters");
        boolean bl = byName = browserPath == null && browser != null;
        if (byName) {
            WebBrowser webBrowser = browser;
            if (webBrowser == null) {
                Intrinsics.throwNpe();
            }
            string = PathUtil.toSystemDependentName(webBrowser.getPath());
        } else {
            string = browserPath;
        }
        String effectivePath = string;
        Function0 launchTask2 = byName ? (Function0)new Function0<Unit>(this, url, browser, project, openInNewWindow, additionalParameters){
            final /* synthetic */ BrowserLauncherAppless this$0;
            final /* synthetic */ String $url;
            final /* synthetic */ WebBrowser $browser;
            final /* synthetic */ Project $project;
            final /* synthetic */ boolean $openInNewWindow;
            final /* synthetic */ String[] $additionalParameters;

            public final void invoke() {
                WebBrowser webBrowser = this.$browser;
                if (webBrowser == null) {
                    Intrinsics.throwNpe();
                }
                this.this$0.browseUsingPath(this.$url, null, webBrowser, this.$project, this.$openInNewWindow, this.$additionalParameters);
            }
            {
                this.this$0 = browserLauncherAppless;
                this.$url = string;
                this.$browser = webBrowser;
                this.$project = project;
                this.$openInNewWindow = bl;
                this.$additionalParameters = stringArray;
                super(0);
            }
        } : null;
        CharSequence charSequence = effectivePath;
        boolean bl2 = false;
        boolean bl3 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            Object object = browser;
            if (object == null || (object = ((WebBrowser)object).getBrowserNotFoundMessage()) == null) {
                object = IdeBundle.message("error.please.specify.path.to.web.browser", CommonBundle.settingsActionPath());
            }
            Object message = object;
            this.showError((String)message, browser, project, IdeBundle.message("title.browser.not.found", new Object[0]), (Function0<Unit>)launchTask2);
            return false;
        }
        List<String> list = BrowserUtil.getOpenBrowserCommand(effectivePath, openInNewWindow);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"BrowserUtil.getOpenBrows\u2026ivePath, openInNewWindow)");
        return this.doLaunch(url, list, browser, project, additionalParameters, (Function0<Unit>)launchTask2);
    }

    private final boolean doLaunch(String url, List<String> command, WebBrowser browser, Project project, String[] additionalParameters, Function0<Unit> launchTask2) {
        boolean bl;
        BrowserSpecificSettings browserSpecificSettings;
        if (url != null && StringsKt.startsWith$default((String)url, (String)"jar:", (boolean)false, (int)2, null)) {
            return false;
        }
        List commandWithUrl = CollectionsKt.toMutableList((Collection)command);
        if (url != null) {
            if (browser != null) {
                browser.addOpenUrlParameter(commandWithUrl, url);
            } else {
                commandWithUrl.add(url);
            }
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(commandWithUrl);
        WebBrowser webBrowser = browser;
        BrowserSpecificSettings browserSpecificSettings2 = browserSpecificSettings = webBrowser != null ? webBrowser.getSpecificSettings() : null;
        if (browserSpecificSettings != null) {
            Map<String, String> map = commandLine.getEnvironment();
            Map<String, String> map2 = browserSpecificSettings.getEnvironmentVariables();
            Intrinsics.checkExpressionValueIsNotNull(map2, (String)"browserSpecificSettings.environmentVariables");
            map.putAll(map2);
        }
        BrowserLauncherApplessKt.access$addArgs(commandLine, browserSpecificSettings, additionalParameters);
        try {
            Process process = commandLine.createProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"commandLine.createProcess()");
            this.checkCreatedProcess(browser, project, commandLine, process, launchTask2);
            bl = true;
        }
        catch (ExecutionException e) {
            this.showError(e.getMessage(), browser, project, null, null);
            bl = false;
        }
        return bl;
    }

    static /* synthetic */ boolean doLaunch$default(BrowserLauncherAppless browserLauncherAppless, String string, List list, WebBrowser webBrowser, Project project, String[] stringArray, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doLaunch");
        }
        if ((n & 0x10) != 0) {
            Intrinsics.checkExpressionValueIsNotNull((Object)ArrayUtil.EMPTY_STRING_ARRAY, (String)"ArrayUtil.EMPTY_STRING_ARRAY");
            stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if ((n & 0x20) != 0) {
            function0 = null;
        }
        return browserLauncherAppless.doLaunch(string, list, webBrowser, project, stringArray, (Function0<Unit>)function0);
    }

    protected void checkCreatedProcess(@Nullable WebBrowser browser, @Nullable Project project, @NotNull GeneralCommandLine commandLine, @NotNull Process process, @Nullable Function0<Unit> launchTask2) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)process, (String)"process");
    }

    protected void showError(@Nullable String error, @Nullable WebBrowser browser, @Nullable Project project, @Nullable String title, @Nullable Function0<Unit> launchTask2) {
        BrowserLauncherApplessKt.access$getLOG$p().warn(error);
    }

    public static /* synthetic */ void showError$default(BrowserLauncherAppless browserLauncherAppless, String string, WebBrowser webBrowser, Project project, String string2, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showError");
        }
        if ((n & 2) != 0) {
            webBrowser = null;
        }
        if ((n & 4) != 0) {
            project = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            function0 = null;
        }
        browserLauncherAppless.showError(string, webBrowser, project, string2, (Function0<Unit>)function0);
    }

    @Nullable
    protected WebBrowser getEffectiveBrowser(@Nullable WebBrowser browser) {
        return browser;
    }

    @JvmStatic
    public static final boolean canUseSystemDefaultBrowserPolicy() {
        return Companion.canUseSystemDefaultBrowserPolicy();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/browsers/BrowserLauncherAppless$Companion;", "", "()V", "canUseSystemDefaultBrowserPolicy", "", "isOpenCommandUsed", "command", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.platform.ide"})
    public static final class Companion {
        @JvmStatic
        public final boolean canUseSystemDefaultBrowserPolicy() {
            return BrowserLauncherApplessKt.access$isDesktopActionSupported(Desktop.Action.BROWSE) || SystemInfo.isMac || SystemInfo.isWindows || SystemInfo.isUnix && SystemInfo.hasXdgOpen();
        }

        public final boolean isOpenCommandUsed(@NotNull GeneralCommandLine command) {
            Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
            return SystemInfo.isMac && Intrinsics.areEqual((Object)ExecUtil.getOpenCommandPath(), (Object)command.getExePath());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

