/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.sh.ShTypes;
import com.intellij.sh.psi.ShGenericCommandDirective;
import com.intellij.sh.psi.ShLiteral;
import com.intellij.sh.statistics.ShFeatureUsagesCollector;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShDocumentationProvider
extends AbstractDocumentationProvider {
    private static final int TIMEOUT_IN_MILLISECONDS = 3000;
    private static final Logger LOG = Logger.getInstance(ShDocumentationProvider.class);
    private static final String FEATURE_ACTION_ID = "DocumentationProviderUsed";
    private static final NullableLazyValue<String> myManExecutable = new AtomicNullableLazyValue<String>(){

        @Nullable
        protected String compute() {
            String path = EnvironmentUtil.getValue((String)"PATH");
            if (path != null) {
                for (String dir : StringUtil.tokenize((String)path, (String)File.pathSeparator)) {
                    File file = new File(dir, "info");
                    if (!file.canExecute()) continue;
                    return file.getAbsolutePath();
                }
            }
            return null;
        }
    };
    private final ConcurrentHashMap<String, String> myManCache = new ConcurrentHashMap();

    public String generateDoc(PsiElement o, PsiElement originalElement) {
        if (!ShDocumentationProvider.wordWithDocumentation(o)) {
            return null;
        }
        ShFeatureUsagesCollector.logFeatureUsage(FEATURE_ACTION_ID);
        return ShDocumentationProvider.wrapIntoHtml(this.fetchInfo(o.getText()));
    }

    private static boolean wordWithDocumentation(@Nullable PsiElement o) {
        return o instanceof LeafPsiElement && ((LeafPsiElement)o).getElementType() == ShTypes.WORD && o.getParent() instanceof ShLiteral && o.getParent().getParent() instanceof ShGenericCommandDirective;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement) {
        ASTNode node;
        if (editor == null) {
            ShDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ShDocumentationProvider.$$$reportNull$$$0(1);
        }
        ASTNode aSTNode = node = contextElement == null ? null : contextElement.getNode();
        if (node == null || TreeUtil.isWhitespaceOrComment((ASTNode)node) || node.getElementType() == ShTypes.LINEFEED) {
            PsiElement at;
            int offset = editor.getCaretModel().getPrimaryCaret().getOffset();
            PsiElement psiElement = at = offset > 0 ? file.findElementAt(offset - 1) : null;
            if (ShDocumentationProvider.wordWithDocumentation(at)) {
                return at;
            }
        }
        return contextElement;
    }

    private String fetchInfo(@Nullable String commandName) {
        if (commandName == null) {
            return null;
        }
        String manExecutable = (String)myManExecutable.getValue();
        if (manExecutable == null) {
            return "Can't find info in your $PATH";
        }
        return this.myManCache.computeIfAbsent(commandName, s -> {
            try {
                return (String)ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{manExecutable}).withParameters(new String[]{commandName});
                    ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine, (int)3000);
                    return output.getExitCode() != 0 ? output.getStderr() : output.getStdout();
                }).get(3000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                return null;
            }
        });
    }

    @Nullable
    private static String wrapIntoHtml(@Nullable String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer("<html><body><pre>");
        try {
            Matcher m = URLUtil.URL_PATTERN.matcher(StringUtil.escapeXmlEntities((String)s));
            while (m.find()) {
                if (m.groupCount() <= 0) continue;
                String url = m.group(0);
                m.appendReplacement(sb, "<a href='" + url + "'>" + url + "</a>");
            }
            m.appendTail(sb);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        sb.append("</pre></body></html>");
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/sh/ShDocumentationProvider";
        objectArray[2] = "getCustomDocumentationElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

