/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeModifier;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirtyScopeImpl
extends VcsModifiableDirtyScope {
    private static final TObjectHashingStrategy<FilePath> CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY = new TObjectHashingStrategy<FilePath>(){

        public int computeHashCode(@Nullable FilePath path) {
            if (path == null) {
                return 0;
            }
            return Objects.hash(path.getPath(), path.isDirectory(), path.isNonLocal());
        }

        public boolean equals(@Nullable FilePath path1, @Nullable FilePath path2) {
            if (path1 == null || path2 == null) {
                return path1 == path2;
            }
            return path1.isDirectory() == path2.isDirectory() && path1.isNonLocal() == path2.isNonLocal() && path1.getPath().equals(path2.getPath());
        }
    };
    private final Map<VirtualFile, THashSet<FilePath>> myDirtyFiles = new HashMap<VirtualFile, THashSet<FilePath>>();
    private final Map<VirtualFile, THashSet<FilePath>> myDirtyDirectoriesRecursively = new HashMap<VirtualFile, THashSet<FilePath>>();
    private final Set<VirtualFile> myAffectedContentRoots = new THashSet();
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    private final AbstractVcs myVcs;
    private final VcsDirtyScopeModifier myVcsDirtyScopeModifier;
    private final boolean myWasEverythingDirty;

    public VcsDirtyScopeImpl(AbstractVcs vcs, Project project) {
        this(vcs, project, false);
    }

    public VcsDirtyScopeImpl(AbstractVcs vcs, Project project, boolean wasEverythingDirty) {
        this.myProject = project;
        this.myVcs = vcs;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myWasEverythingDirty = wasEverythingDirty;
        this.myVcsDirtyScopeModifier = new VcsDirtyScopeModifier(){

            @NotNull
            public Iterator<FilePath> getDirtyFilesIterator() {
                Iterator<FilePath> iterator = this.iterateMap(VcsDirtyScopeImpl.this.myDirtyFiles);
                if (iterator == null) {
                    2.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            @NotNull
            public Iterator<FilePath> getDirtyDirectoriesIterator() {
                Iterator<FilePath> iterator = this.iterateMap(VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively);
                if (iterator == null) {
                    2.$$$reportNull$$$0(1);
                }
                return iterator;
            }

            public void recheckDirtyKeys() {
                this.recheckMap(VcsDirtyScopeImpl.this.myDirtyDirectoriesRecursively);
                this.recheckMap(VcsDirtyScopeImpl.this.myDirtyFiles);
            }

            @NotNull
            private Iterator<FilePath> iterateMap(@NotNull Map<VirtualFile, THashSet<FilePath>> map2) {
                if (map2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                Iterator iterator = ContainerUtil.concatIterators((Collection)ContainerUtil.map(map2.values(), THashSet::iterator));
                if (iterator == null) {
                    2.$$$reportNull$$$0(3);
                }
                return iterator;
            }

            private void recheckMap(@NotNull Map<VirtualFile, THashSet<FilePath>> map2) {
                if (map2 == null) {
                    2.$$$reportNull$$$0(4);
                }
                Iterator<THashSet<FilePath>> iterator = map2.values().iterator();
                while (iterator.hasNext()) {
                    THashSet<FilePath> next = iterator.next();
                    if (!next.isEmpty()) continue;
                    iterator.remove();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl$2";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDirtyFilesIterator";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDirtyDirectoriesIterator";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "iterateMap";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "iterateMap";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "recheckMap";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public Collection<VirtualFile> getAffectedContentRoots() {
        return this.myAffectedContentRoots;
    }

    public Project getProject() {
        return this.myProject;
    }

    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public Set<FilePath> getDirtyFiles() {
        THashSet<FilePath> result2 = VcsDirtyScopeImpl.newFilePathsSet();
        for (THashSet<FilePath> paths : this.myDirtyFiles.values()) {
            result2.addAll(paths);
        }
        for (THashSet<FilePath> paths : this.myDirtyFiles.values()) {
            for (FilePath filePath : paths) {
                VirtualFile vFile = filePath.getVirtualFile();
                if (vFile == null || !vFile.isValid() || !vFile.isDirectory()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    result2.add((Object)VcsUtil.getFilePath((VirtualFile)child));
                }
            }
        }
        return result2;
    }

    public Set<FilePath> getDirtyFilesNoExpand() {
        THashSet<FilePath> paths = VcsDirtyScopeImpl.newFilePathsSet();
        for (THashSet<FilePath> filePaths : this.myDirtyFiles.values()) {
            paths.addAll(filePaths);
        }
        return paths;
    }

    public Set<FilePath> getRecursivelyDirtyDirectories() {
        THashSet<FilePath> result2 = VcsDirtyScopeImpl.newFilePathsSet();
        for (THashSet<FilePath> dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
            result2.addAll(dirsByRoot);
        }
        return result2;
    }

    public boolean isRecursivelyDirty(VirtualFile vf) {
        for (THashSet<FilePath> dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
            for (FilePath dir : dirsByRoot) {
                VirtualFile dirVf = dir.getVirtualFile();
                if (dirVf == null || !VfsUtilCore.isAncestor((VirtualFile)dirVf, (VirtualFile)vf, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public void addDirtyData(@NotNull Collection<? extends FilePath> dirs, @NotNull Collection<? extends FilePath> files2) {
        if (dirs == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(0);
        }
        if (files2 == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(1);
        }
        HashMap<VirtualFile, THashSet<FilePath>> perRootDirs = new HashMap<VirtualFile, THashSet<FilePath>>();
        HashMap<VirtualFile, THashSet<FilePath>> perRootFiles = new HashMap<VirtualFile, THashSet<FilePath>>();
        for (Map.Entry<VirtualFile, THashSet<FilePath>> entry : this.myDirtyDirectoriesRecursively.entrySet()) {
            perRootDirs.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<VirtualFile, THashSet<FilePath>> entry : this.myDirtyFiles.entrySet()) {
            perRootFiles.put(entry.getKey(), entry.getValue());
        }
        this.addFilePathsToMap(dirs, perRootDirs);
        this.addFilePathsToMap(files2, perRootFiles);
        this.myAffectedContentRoots.addAll(perRootDirs.keySet());
        this.myAffectedContentRoots.addAll(perRootFiles.keySet());
        for (VirtualFile root : this.myAffectedContentRoots) {
            Set rootDirs = ContainerUtil.notNullize((Set)((Set)perRootDirs.get(root)));
            Set rootFiles = ContainerUtil.notNullize((Set)((Set)perRootFiles.get(root)));
            THashSet<FilePath> filteredDirs = VcsDirtyScopeImpl.removeAncestorsRecursive(rootDirs);
            THashSet<FilePath> filteredFiles = VcsDirtyScopeImpl.removeAncestorsNonRecursive(filteredDirs, rootFiles);
            this.myDirtyDirectoriesRecursively.put(root, filteredDirs);
            this.myDirtyFiles.put(root, filteredFiles);
        }
    }

    private void addFilePathsToMap(@NotNull Collection<? extends FilePath> paths, @NotNull Map<VirtualFile, THashSet<FilePath>> pathsMap) {
        if (paths == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(2);
        }
        if (pathsMap == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(3);
        }
        for (FilePath filePath : paths) {
            VirtualFile vcsRoot = this.myVcsManager.getVcsRootFor(filePath);
            if (vcsRoot == null) continue;
            THashSet<FilePath> set = pathsMap.get(vcsRoot);
            if (set == null) {
                set = VcsDirtyScopeImpl.newFilePathsSet();
                pathsMap.put(vcsRoot, set);
            }
            set.add((Object)filePath);
        }
    }

    @NotNull
    private static THashSet<FilePath> removeAncestorsRecursive(@NotNull Collection<? extends FilePath> dirs) {
        if (dirs == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(4);
        }
        List paths = ContainerUtil.sorted(dirs, Comparator.comparingInt(it -> it.getPath().length()));
        THashSet<FilePath> result2 = VcsDirtyScopeImpl.newFilePathsSet();
        for (FilePath path : paths) {
            if (VcsDirtyScopeImpl.hasAncestor(result2, path)) continue;
            result2.add((Object)path);
        }
        THashSet<FilePath> tHashSet = result2;
        if (tHashSet == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(5);
        }
        return tHashSet;
    }

    @NotNull
    private static THashSet<FilePath> removeAncestorsNonRecursive(@NotNull Set<? extends FilePath> dirs, @NotNull Set<? extends FilePath> files2) {
        if (dirs == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(6);
        }
        if (files2 == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(7);
        }
        THashSet<FilePath> result2 = VcsDirtyScopeImpl.newFilePathsSet();
        for (FilePath filePath : files2) {
            if (VcsDirtyScopeImpl.hasAncestor(dirs, filePath) || !filePath.isDirectory() && files2.contains(filePath.getParentPath())) continue;
            result2.add((Object)filePath);
        }
        THashSet<FilePath> tHashSet = result2;
        if (tHashSet == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(8);
        }
        return tHashSet;
    }

    private static boolean hasAncestor(@NotNull Set<? extends FilePath> dirs, @NotNull FilePath filePath) {
        if (dirs == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(9);
        }
        if (filePath == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(10);
        }
        for (FilePath filePath2 : dirs) {
            if (!VcsDirtyScopeImpl.isAncestor(filePath, filePath2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAncestor(@NotNull FilePath filePath, @NotNull FilePath parent) {
        if (filePath == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(11);
        }
        if (parent == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(12);
        }
        return FileUtil.startsWith((String)filePath.getPath(), (String)parent.getPath());
    }

    @NotNull
    private static THashSet<FilePath> newFilePathsSet() {
        THashSet tHashSet = new THashSet(CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY);
        if (tHashSet == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(13);
        }
        return tHashSet;
    }

    public void addDirtyDirRecursively(FilePath newcomer) {
        VirtualFile vcsRoot = this.myVcsManager.getVcsRootFor(newcomer);
        if (vcsRoot == null) {
            return;
        }
        this.myAffectedContentRoots.add(vcsRoot);
        for (Map.Entry<VirtualFile, THashSet<FilePath>> entry : this.myDirtyFiles.entrySet()) {
            THashSet<FilePath> files2;
            VirtualFile groupRoot = entry.getKey();
            if (groupRoot == null || !VfsUtilCore.isAncestor((VirtualFile)vcsRoot, (VirtualFile)groupRoot, (boolean)false) || (files2 = entry.getValue()) == null) continue;
            Iterator it = files2.iterator();
            while (it.hasNext()) {
                FilePath oldBoy = (FilePath)it.next();
                if (!VcsDirtyScopeImpl.isAncestor(oldBoy, newcomer)) continue;
                it.remove();
            }
        }
        THashSet<FilePath> dirsByRoot = this.myDirtyDirectoriesRecursively.get(vcsRoot);
        if (dirsByRoot == null) {
            dirsByRoot = VcsDirtyScopeImpl.newFilePathsSet();
            this.myDirtyDirectoriesRecursively.put(vcsRoot, dirsByRoot);
        } else {
            Iterator it = dirsByRoot.iterator();
            while (it.hasNext()) {
                FilePath oldBoy = (FilePath)it.next();
                if (VcsDirtyScopeImpl.isAncestor(newcomer, oldBoy)) {
                    return;
                }
                if (!VcsDirtyScopeImpl.isAncestor(oldBoy, newcomer)) continue;
                it.remove();
            }
        }
        dirsByRoot.add((Object)newcomer);
    }

    public void addDirtyFile(FilePath newcomer) {
        FilePath parent;
        VirtualFile vcsRoot = this.myVcsManager.getVcsRootFor(newcomer);
        if (vcsRoot == null) {
            return;
        }
        this.myAffectedContentRoots.add(vcsRoot);
        THashSet<FilePath> dirsByRoot = this.myDirtyDirectoriesRecursively.get(vcsRoot);
        if (dirsByRoot != null && VcsDirtyScopeImpl.hasAncestor(dirsByRoot, newcomer)) {
            return;
        }
        THashSet<FilePath> dirtyFiles = this.myDirtyFiles.get(vcsRoot);
        if (dirtyFiles == null) {
            dirtyFiles = VcsDirtyScopeImpl.newFilePathsSet();
            this.myDirtyFiles.put(vcsRoot, dirtyFiles);
        } else if (newcomer.isDirectory()) {
            Iterator iterator = dirtyFiles.iterator();
            while (iterator.hasNext()) {
                FilePath oldBoy = (FilePath)iterator.next();
                if (oldBoy.isDirectory() || !CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals((Object)oldBoy.getParentPath(), (Object)newcomer)) continue;
                iterator.remove();
            }
        } else if (!dirtyFiles.isEmpty() && (parent = newcomer.getParentPath()) != null && dirtyFiles.contains((Object)parent)) {
            return;
        }
        dirtyFiles.add((Object)newcomer);
    }

    public void iterate(Processor<? super FilePath> iterator) {
        VirtualFile vFile;
        if (this.myProject.isDisposed()) {
            return;
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> dirsByRoot = this.myDirtyDirectoriesRecursively.get(root);
            if (dirsByRoot == null) continue;
            for (FilePath dir : dirsByRoot) {
                vFile = dir.getVirtualFile();
                if (vFile == null || !vFile.isValid()) continue;
                this.myVcsManager.iterateVcsRoot(vFile, iterator);
            }
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> files2 = this.myDirtyFiles.get(root);
            if (files2 == null) continue;
            for (FilePath file : files2) {
                iterator.process((Object)file);
                vFile = file.getVirtualFile();
                if (vFile == null || !vFile.isValid() || !vFile.isDirectory()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    iterator.process((Object)VcsUtil.getFilePath((VirtualFile)child));
                }
            }
        }
    }

    public void iterateExistingInsideScope(Processor<? super VirtualFile> processor) {
        VirtualFile vFile;
        if (this.myProject.isDisposed()) {
            return;
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> dirsByRoot = this.myDirtyDirectoriesRecursively.get(root);
            if (dirsByRoot == null) continue;
            for (FilePath dir : dirsByRoot) {
                vFile = VcsDirtyScopeImpl.obtainVirtualFile(dir);
                if (vFile == null || !vFile.isValid()) continue;
                this.myVcsManager.iterateVfUnderVcsRoot(vFile, processor);
            }
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> files2 = this.myDirtyFiles.get(root);
            if (files2 == null) continue;
            for (FilePath file : files2) {
                vFile = VcsDirtyScopeImpl.obtainVirtualFile(file);
                if (vFile == null || !vFile.isValid()) continue;
                processor.process((Object)vFile);
                if (!vFile.isDirectory()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    processor.process((Object)child);
                }
            }
        }
    }

    @Nullable
    private static VirtualFile obtainVirtualFile(FilePath file) {
        VirtualFile vFile = file.getVirtualFile();
        return vFile == null ? VfsUtil.findFileByIoFile((File)file.getIOFile(), (boolean)false) : vFile;
    }

    public boolean isEmpty() {
        return this.myDirtyDirectoriesRecursively.isEmpty() && this.myDirtyFiles.isEmpty();
    }

    public boolean belongsTo(FilePath path, Consumer<? super AbstractVcs> vcsConsumer) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        VcsRoot rootObject = this.myVcsManager.getVcsRootObjectFor(path);
        if (vcsConsumer != null && rootObject != null) {
            vcsConsumer.consume((Object)rootObject.getVcs());
        }
        if (rootObject == null || rootObject.getVcs() != this.myVcs) {
            return false;
        }
        VirtualFile vcsRoot = rootObject.getPath();
        if (vcsRoot != null) {
            boolean pathIsRoot = vcsRoot.equals(path.getVirtualFile());
            for (VirtualFile contentRoot : this.myAffectedContentRoots) {
                THashSet<FilePath> dirsByRoot;
                boolean strict;
                if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)vcsRoot, (boolean)(strict = pathIsRoot && !this.myVcs.areDirectoriesVersionedItems())) || (dirsByRoot = this.myDirtyDirectoriesRecursively.get(contentRoot)) == null || !VcsDirtyScopeImpl.hasAncestor(dirsByRoot, path)) continue;
                return true;
            }
        }
        if (!this.myDirtyFiles.isEmpty()) {
            FilePath parent = path.getParentPath();
            return this.isInDirtyFiles(path) || this.isInDirtyFiles(parent);
        }
        return false;
    }

    private boolean isInDirtyFiles(FilePath path) {
        THashSet<FilePath> files2;
        VcsRoot rootObject = this.myVcsManager.getVcsRootObjectFor(path);
        return rootObject != null && this.myVcs.equals((Object)rootObject.getVcs()) && (files2 = this.myDirtyFiles.get(rootObject.getPath())) != null && files2.contains((Object)path);
    }

    public boolean belongsTo(FilePath path) {
        return this.belongsTo(path, null);
    }

    @NonNls
    public String toString() {
        StringBuilder result2 = new StringBuilder("VcsDirtyScope[");
        if (!this.myDirtyFiles.isEmpty()) {
            result2.append(" files: ");
            for (THashSet<FilePath> paths : this.myDirtyFiles.values()) {
                for (FilePath file : paths) {
                    result2.append(file).append(" ");
                }
            }
        }
        if (!this.myDirtyDirectoriesRecursively.isEmpty()) {
            result2.append("\ndirs: ");
            for (THashSet<FilePath> dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
                for (FilePath file : dirsByRoot) {
                    result2.append(file).append(" ");
                }
            }
        }
        result2.append("\naffected roots: ");
        for (VirtualFile contentRoot : this.myAffectedContentRoots) {
            result2.append(contentRoot.getPath()).append(" ");
        }
        result2.append("]");
        return result2.toString();
    }

    public VcsDirtyScopeModifier getModifier() {
        return this.myVcsDirtyScopeModifier;
    }

    public boolean wasEveryThingDirty() {
        return this.myWasEverythingDirty;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsMap";
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "removeAncestorsRecursive";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "removeAncestorsNonRecursive";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "newFilePathsSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addDirtyData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFilePathsToMap";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeAncestorsRecursive";
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeAncestorsNonRecursive";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasAncestor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

