/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyMakeMethodStaticQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.NAME.make.static", new Object[0]);
        if (string == null) {
            PyMakeMethodStaticQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement element;
        PyFunction problemFunction;
        if (project == null) {
            PyMakeMethodStaticQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            PyMakeMethodStaticQuickFix.$$$reportNull$$$0(2);
        }
        if ((problemFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)(element = descriptor2.getPsiElement()), PyFunction.class)) == null) {
            return;
        }
        List<UsageInfo> usages = PyRefactoringUtil.findUsages(problemFunction, false);
        PyParameter[] parameters = problemFunction.getParameterList().getParameters();
        if (parameters.length > 0) {
            parameters[0].delete();
        }
        PyUtil.addDecorator(problemFunction, "@staticmethod");
        for (UsageInfo usage : usages) {
            PsiElement usageElement = usage.getElement();
            if (!(usageElement instanceof PyReferenceExpression)) continue;
            PyMakeMethodStaticQuickFix.updateUsage((PyReferenceExpression)usageElement);
        }
    }

    private static void updateUsage(@NotNull PyReferenceExpression element) {
        PyExpression qualifier;
        if (element == null) {
            PyMakeMethodStaticQuickFix.$$$reportNull$$$0(3);
        }
        if ((qualifier = element.getQualifier()) == null) {
            return;
        }
        PsiReference reference = qualifier.getReference();
        if (reference == null) {
            return;
        }
        PsiElement resolved = reference.resolve();
        if (resolved instanceof PyClass) {
            PyMakeMethodStaticQuickFix.updateArgumentList(element);
        }
    }

    private static void updateArgumentList(@NotNull PyReferenceExpression element) {
        PyCallExpression callExpression;
        if (element == null) {
            PyMakeMethodStaticQuickFix.$$$reportNull$$$0(4);
        }
        if ((callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class)) == null) {
            return;
        }
        PyArgumentList argumentList = callExpression.getArgumentList();
        if (argumentList == null) {
            return;
        }
        PyExpression[] arguments = argumentList.getArguments();
        if (arguments.length > 0) {
            arguments[0].delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyMakeMethodStaticQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyMakeMethodStaticQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateUsage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateArgumentList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

