/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.sender;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.stats.network.UtilsKt;
import com.intellij.stats.network.service.RequestService;
import com.intellij.stats.network.service.ResponseData;
import com.intellij.stats.sender.DailyLimitSendingWatcher;
import com.intellij.stats.sender.PersistentSentDataInfo;
import com.intellij.stats.sender.StatisticSender;
import com.intellij.stats.storage.FilePathProvider;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/stats/sender/StatisticSenderImpl;", "Lcom/intellij/stats/sender/StatisticSender;", "requestService", "Lcom/intellij/stats/network/service/RequestService;", "filePathProvider", "Lcom/intellij/stats/storage/FilePathProvider;", "(Lcom/intellij/stats/network/service/RequestService;Lcom/intellij/stats/storage/FilePathProvider;)V", "limitWatcher", "Lcom/intellij/stats/sender/DailyLimitSendingWatcher;", "sendContent", "", "url", "", "file", "Ljava/io/File;", "sendStatsData", "", "Companion", "intellij.statsCollector"})
public final class StatisticSenderImpl
implements StatisticSender {
    private final DailyLimitSendingWatcher limitWatcher;
    private final RequestService requestService;
    private final FilePathProvider filePathProvider;
    public static final int DAILY_LIMIT = 0xF00000;
    public static final Companion Companion = new Companion(null);

    @Override
    public void sendStatsData(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        UtilsKt.assertNotEDT();
        if (this.limitWatcher.isLimitReached()) {
            return;
        }
        List<File> filesToSend = this.filePathProvider.getDataFiles();
        Iterable $this$forEach$iv = filesToSend;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.length() <= 0L || this.limitWatcher.isLimitReached()) continue;
            boolean isSentSuccessfully = this.sendContent(url, it);
            if (isSentSuccessfully) {
                it.delete();
                continue;
            }
            return;
        }
    }

    private final boolean sendContent(String url, File file) {
        ResponseData data = this.requestService.postZipped(url, file);
        if (data != null && data.getCode() >= 200 && data.getCode() < 300) {
            if (data.getSentDataSize() != null) {
                this.limitWatcher.dataSent(data.getSentDataSize());
            }
            return true;
        }
        return false;
    }

    public StatisticSenderImpl(@NotNull RequestService requestService, @NotNull FilePathProvider filePathProvider) {
        Intrinsics.checkParameterIsNotNull((Object)requestService, (String)"requestService");
        Intrinsics.checkParameterIsNotNull((Object)filePathProvider, (String)"filePathProvider");
        this.requestService = requestService;
        this.filePathProvider = filePathProvider;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)propertiesComponent, (String)"PropertiesComponent.getInstance()");
        this.limitWatcher = new DailyLimitSendingWatcher(0xF00000, new PersistentSentDataInfo(propertiesComponent));
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/stats/sender/StatisticSenderImpl$Companion;", "", "()V", "DAILY_LIMIT", "", "intellij.statsCollector"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

