/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import processing.app.Language;
import processing.app.Platform;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.syntax.SyntaxDocument;
import processing.app.ui.Toolkit;
import processing.mode.java.JavaEditor;
import processing.mode.java.pdex.ASTUtils;
import processing.mode.java.pdex.PreprocessedSketch;
import processing.mode.java.pdex.PreprocessingService;
import processing.mode.java.pdex.ShowUsage;

class Rename {
    final JavaEditor editor;
    final PreprocessingService pps;
    final ShowUsage showUsage;
    final JDialog window;
    final JTextField textField;
    final JLabel oldNameLabel;
    IBinding binding;
    PreprocessedSketch ps;

    Rename(JavaEditor editor, PreprocessingService pps, ShowUsage showUsage) {
        this.editor = editor;
        this.pps = pps;
        this.showUsage = showUsage;
        JMenuItem renameItem = new JMenuItem(Language.text((String)"editor.popup.rename"));
        renameItem.addActionListener(e -> this.handleRename());
        editor.getTextArea().getRightClickPopup().add(renameItem);
        this.window = new JDialog((Frame)((Object)editor));
        JRootPane rootPane = this.window.getRootPane();
        this.window.setTitle("Rename");
        this.window.setDefaultCloseOperation(1);
        Toolkit.registerWindowCloseKeys((JRootPane)rootPane, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rename.this.window.setVisible(false);
            }
        });
        Toolkit.setIcon((Window)this.window);
        this.window.setModal(true);
        this.window.setResizable(false);
        this.window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                Rename.this.binding = null;
                Rename.this.ps = null;
            }
        });
        Box windowBox = Box.createVerticalBox();
        Toolkit.setBorder((JComponent)windowBox);
        int GAP = Toolkit.zoom((int)5);
        Box oldBox = Box.createHorizontalBox();
        this.oldNameLabel = new JLabel("Current Name: ");
        oldBox.add(this.oldNameLabel);
        oldBox.add(Box.createHorizontalGlue());
        windowBox.add(oldBox);
        windowBox.add(Box.createVerticalStrut(GAP));
        Box newBox = Box.createHorizontalBox();
        JLabel newNameLabel = new JLabel("New Name: ");
        newBox.add(newNameLabel);
        this.textField = new JTextField(20);
        newBox.add(this.textField);
        newBox.add(Box.createHorizontalGlue());
        windowBox.add(newBox);
        windowBox.add(Box.createVerticalStrut(GAP * 2));
        JButton showUsageButton = new JButton("Show Usage");
        showUsageButton.addActionListener(e -> {
            showUsage.findUsageAndUpdateTree(this.ps, this.binding);
            this.window.setVisible(false);
        });
        JButton renameButton = new JButton("Rename");
        renameButton.addActionListener(e -> {
            String newName = this.textField.getText().trim();
            if (!newName.isEmpty()) {
                if (newName.length() >= 1 && newName.chars().limit(1L).allMatch(Character::isUnicodeIdentifierStart) && newName.chars().skip(1L).allMatch(Character::isUnicodeIdentifierPart)) {
                    this.rename(this.ps, this.binding, newName);
                    this.window.setVisible(false);
                } else {
                    String msg = String.format("'%s' is not a valid name", newName);
                    JOptionPane.showMessageDialog((Component)((Object)editor), msg, "Naming is Hard", -1);
                }
            }
        });
        rootPane.setDefaultButton(renameButton);
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(showUsageButton);
        if (!Platform.isMacOS()) {
            buttonBox.add(Box.createHorizontalStrut(GAP));
        }
        buttonBox.add(renameButton);
        buttonBox.add(Box.createHorizontalGlue());
        Dimension showDim = showUsageButton.getPreferredSize();
        Dimension renameDim = renameButton.getPreferredSize();
        int niceSize = Math.max(showDim.width, renameDim.width) + GAP;
        Dimension buttonDim = new Dimension(niceSize, showDim.height);
        showUsageButton.setPreferredSize(buttonDim);
        renameButton.setPreferredSize(buttonDim);
        windowBox.add(buttonBox);
        this.window.add(windowBox);
        this.window.pack();
    }

    void handleRename() {
        int startOffset = this.editor.getSelectionStart();
        int stopOffset = this.editor.getSelectionStop();
        int tabIndex = this.editor.getSketch().getCurrentCodeIndex();
        this.pps.whenDoneBlocking(ps -> this.handleRename((PreprocessedSketch)ps, tabIndex, startOffset, stopOffset));
    }

    void handleRename(PreprocessedSketch ps, int tabIndex, int startTabOffset, int stopTabOffset) {
        int stopJavaOffset;
        if (ps.hasSyntaxErrors) {
            this.editor.statusMessage("Cannot rename until syntax errors are fixed", 3);
            return;
        }
        CompilationUnit root = ps.compilationUnit;
        int startJavaOffset = ps.tabOffsetToJavaOffset(tabIndex, startTabOffset);
        SimpleName name = ASTUtils.getSimpleNameAt((ASTNode)root, startJavaOffset, stopJavaOffset = ps.tabOffsetToJavaOffset(tabIndex, stopTabOffset));
        if (name == null) {
            this.editor.statusMessage("Highlight the class/function/variable name first", 0);
            return;
        }
        IBinding binding = ASTUtils.resolveBinding(name);
        if (binding == null) {
            this.editor.statusMessage(String.valueOf(name.getIdentifier()) + " isn't defined in this sketch, " + "so it cannot be renamed", 1);
            return;
        }
        ASTNode decl = ps.compilationUnit.findDeclaringNode(binding.getKey());
        if (decl == null) {
            this.editor.statusMessage(String.valueOf(name.getIdentifier()) + " isn't defined in this sketch, " + "so it cannot be renamed", 1);
            return;
        }
        EventQueue.invokeLater(() -> {
            if (!this.window.isVisible()) {
                this.ps = ps;
                this.binding = binding;
                this.oldNameLabel.setText("Current name: " + binding.getName());
                this.textField.setText(binding.getName());
                this.textField.requestFocus();
                this.textField.selectAll();
                int x = this.editor.getX() + (this.editor.getWidth() - this.window.getWidth()) / 2;
                int y = this.editor.getY() + (this.editor.getHeight() - this.window.getHeight()) / 2;
                this.window.setLocation(x, y);
                this.window.setVisible(true);
                this.window.toFront();
            }
        });
    }

    void rename(PreprocessedSketch ps, IBinding binding, String newName) {
        ASTNode decl;
        IMethodBinding method;
        CompilationUnit root = ps.compilationUnit;
        if (binding.getKind() == 4 && (method = (IMethodBinding)binding).isConstructor()) {
            binding = method.getDeclaringClass();
        }
        if ((decl = root.findDeclaringNode(binding.getKey())) == null) {
            return;
        }
        this.showUsage.hide();
        ArrayList<SimpleName> occurrences = new ArrayList<SimpleName>();
        occurrences.addAll(ASTUtils.findAllOccurrences((ASTNode)root, binding.getKey()));
        if (binding.getKind() == 2) {
            ITypeBinding type = (ITypeBinding)binding;
            IMethodBinding[] methods = type.getDeclaredMethods();
            Arrays.stream(methods).filter(IMethodBinding::isConstructor).flatMap(c -> ASTUtils.findAllOccurrences((ASTNode)root, c.getKey()).stream()).forEach(occurrences::add);
        }
        Map<Integer, List<PreprocessedSketch.SketchInterval>> mappedNodes = occurrences.stream().map(ps::mapJavaToSketch).filter(ps::inRange).collect(Collectors.groupingBy(interval -> interval.tabIndex));
        Sketch sketch = ps.sketch;
        this.editor.startCompoundEdit();
        mappedNodes.entrySet().forEach(entry -> {
            int tabIndex = (Integer)entry.getKey();
            SketchCode sketchCode = sketch.getCode(tabIndex);
            SyntaxDocument document = (SyntaxDocument)sketchCode.getDocument();
            List nodes = (List)entry.getValue();
            nodes.stream().sorted(Comparator.comparing(si -> si.startTabOffset).reversed()).forEach(si -> {
                int documentLength = document.getLength();
                if (si.startTabOffset >= 0 && si.startTabOffset <= documentLength && si.stopTabOffset >= 0 && si.stopTabOffset <= documentLength) {
                    int length = si.stopTabOffset - si.startTabOffset;
                    try {
                        document.remove(si.startTabOffset, length);
                        document.insertString(si.startTabOffset, newName, null);
                    }
                    catch (BadLocationException badLocationException) {}
                }
            });
            try {
                sketchCode.setProgram(document.getText(0, document.getLength()));
            }
            catch (BadLocationException badLocationException) {}
            sketchCode.setModified(true);
        });
        this.editor.stopCompoundEdit();
        this.editor.repaintHeader();
        int currentTabIndex = sketch.getCurrentCodeIndex();
        int currentOffset = this.editor.getCaretOffset();
        int precedingIntervals = (int)mappedNodes.getOrDefault(currentTabIndex, Collections.emptyList()).stream().filter(interval -> interval.stopTabOffset < currentOffset).count();
        int intervalLengthDiff = newName.length() - binding.getName().length();
        int offsetDiff = precedingIntervals * intervalLengthDiff;
        this.editor.getTextArea().setCaretPosition(currentOffset + offsetDiff);
    }

    void dispose() {
        if (this.window != null) {
            this.window.dispose();
        }
    }
}

