/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.prefix.model;

import org.apache.commons.lang3.StringUtils;

public final class NameGenerationRequest {
    private Integer page = null;
    private Integer fileNumber = null;
    private String bookmark = null;
    private String originalName = null;
    private String extension = null;
    private String text = null;

    private NameGenerationRequest(String extension) {
        if (StringUtils.isBlank((CharSequence)extension)) {
            throw new IllegalArgumentException("Extension cannot be blank.");
        }
        this.extension = extension;
    }

    public static NameGenerationRequest nameRequest() {
        return new NameGenerationRequest("pdf");
    }

    public static NameGenerationRequest nameRequest(String extension) {
        return new NameGenerationRequest(extension);
    }

    public NameGenerationRequest page(int page) {
        this.page = page;
        return this;
    }

    public NameGenerationRequest fileNumber(int fileNumber) {
        this.fileNumber = fileNumber;
        return this;
    }

    public NameGenerationRequest bookmark(String bookmark) {
        this.bookmark = StringUtils.trim((String)bookmark);
        return this;
    }

    public NameGenerationRequest originalName(String originalName) {
        if (StringUtils.isBlank((CharSequence)originalName)) {
            throw new IllegalArgumentException("Original name cannot be blank");
        }
        this.originalName = originalName.lastIndexOf(46) >= 1 ? originalName.substring(0, originalName.lastIndexOf(46)) : originalName;
        return this;
    }

    public NameGenerationRequest text(String text) {
        this.text = text;
        return this;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getFileNumber() {
        return this.fileNumber;
    }

    public String getBookmark() {
        return this.bookmark;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getText() {
        return this.text;
    }
}

