/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.encryption;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSBoolean;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.cos.DirectCOSObject;
import org.sejda.sambox.pdmodel.common.PDDictionaryWrapper;
import org.sejda.sambox.pdmodel.encryption.PDCryptFilterDictionary;
import org.sejda.sambox.pdmodel.encryption.SecurityHandler;
import org.sejda.sambox.pdmodel.encryption.SecurityHandlerFactory;

public class PDEncryption
extends PDDictionaryWrapper {
    public static final int VERSION0_UNDOCUMENTED_UNSUPPORTED = 0;
    public static final int VERSION1_40_BIT_ALGORITHM = 1;
    public static final int VERSION2_VARIABLE_LENGTH_ALGORITHM = 2;
    public static final int VERSION3_UNPUBLISHED_ALGORITHM = 3;
    public static final int VERSION4_SECURITY_HANDLER = 4;
    public static final int DEFAULT_LENGTH = 40;
    public static final int DEFAULT_VERSION = 0;
    private SecurityHandler securityHandler;

    public PDEncryption() {
    }

    public PDEncryption(COSDictionary dictionary) {
        super(dictionary);
        this.securityHandler = SecurityHandlerFactory.INSTANCE.newSecurityHandlerForFilter(this.getFilter());
    }

    public SecurityHandler getSecurityHandler() throws IOException {
        if (this.securityHandler == null) {
            throw new IOException("No security handler for filter " + this.getFilter());
        }
        return this.securityHandler;
    }

    public void setSecurityHandler(SecurityHandler securityHandler) {
        this.securityHandler = securityHandler;
    }

    public boolean hasSecurityHandler() {
        return this.securityHandler == null;
    }

    @Deprecated
    public COSDictionary getCOSDictionary() {
        return this.getCOSObject();
    }

    public void setFilter(String filter) {
        this.getCOSObject().setItem(COSName.FILTER, (COSBase)COSName.getPDFName(filter));
    }

    public final String getFilter() {
        return this.getCOSObject().getNameAsString(COSName.FILTER);
    }

    public String getSubFilter() {
        return this.getCOSObject().getNameAsString(COSName.SUB_FILTER);
    }

    public void setSubFilter(String subfilter) {
        this.getCOSObject().setName(COSName.SUB_FILTER, subfilter);
    }

    public void setVersion(int version) {
        this.getCOSObject().setInt(COSName.V, version);
    }

    public int getVersion() {
        return this.getCOSObject().getInt(COSName.V, 0);
    }

    public void setLength(int length) {
        this.getCOSObject().setInt(COSName.LENGTH, length);
    }

    public int getLength() {
        return this.getCOSObject().getInt(COSName.LENGTH, 40);
    }

    public void setRevision(int revision) {
        this.getCOSObject().setInt(COSName.R, revision);
    }

    public int getRevision() {
        return this.getCOSObject().getInt(COSName.R, 0);
    }

    public void setOwnerKey(byte[] o) {
        this.getCOSObject().setItem(COSName.O, (COSBase)COSString.newInstance(o));
    }

    public byte[] getOwnerKey() {
        byte[] o = null;
        COSString owner = (COSString)this.getCOSObject().getDictionaryObject(COSName.O);
        if (owner != null) {
            o = owner.getBytes();
        }
        return o;
    }

    public void setUserKey(byte[] u) {
        this.getCOSObject().setItem(COSName.U, (COSBase)COSString.newInstance(u));
    }

    public byte[] getUserKey() {
        byte[] u = null;
        COSString user = (COSString)this.getCOSObject().getDictionaryObject(COSName.U);
        if (user != null) {
            u = user.getBytes();
        }
        return u;
    }

    public void setOwnerEncryptionKey(byte[] oe) {
        this.getCOSObject().setItem(COSName.OE, (COSBase)COSString.newInstance(oe));
    }

    public byte[] getOwnerEncryptionKey() {
        byte[] oe = null;
        COSString ownerEncryptionKey = (COSString)this.getCOSObject().getDictionaryObject(COSName.OE);
        if (ownerEncryptionKey != null) {
            oe = ownerEncryptionKey.getBytes();
        }
        return oe;
    }

    public void setUserEncryptionKey(byte[] ue) {
        this.getCOSObject().setItem(COSName.UE, (COSBase)COSString.newInstance(ue));
    }

    public byte[] getUserEncryptionKey() {
        byte[] ue = null;
        COSString userEncryptionKey = (COSString)this.getCOSObject().getDictionaryObject(COSName.UE);
        if (userEncryptionKey != null) {
            ue = userEncryptionKey.getBytes();
        }
        return ue;
    }

    public void setPermissions(int permissions) {
        this.getCOSObject().setInt(COSName.P, permissions);
    }

    public int getPermissions() {
        return this.getCOSObject().getInt(COSName.P, 0);
    }

    public boolean isEncryptMetaData() {
        boolean encryptMetaData = true;
        COSBase value = this.getCOSObject().getDictionaryObject(COSName.ENCRYPT_META_DATA);
        if (value instanceof COSBoolean) {
            encryptMetaData = ((COSBoolean)value).getValue();
        }
        return encryptMetaData;
    }

    public void setRecipients(byte[][] recipients) {
        COSArray array = new COSArray();
        for (byte[] recipient : recipients) {
            array.add(COSString.newInstance(recipient));
        }
        this.getCOSObject().setItem(COSName.RECIPIENTS, (COSBase)DirectCOSObject.asDirectObject(array));
    }

    public int getRecipientsLength() {
        COSArray array = (COSArray)this.getCOSObject().getItem(COSName.RECIPIENTS);
        return array.size();
    }

    public COSString getRecipientStringAt(int i) {
        COSArray array = (COSArray)this.getCOSObject().getItem(COSName.RECIPIENTS);
        return (COSString)array.get(i);
    }

    public PDCryptFilterDictionary getStdCryptFilterDictionary() {
        return this.getCryptFilterDictionary(COSName.STD_CF);
    }

    public PDCryptFilterDictionary getDefaultCryptFilterDictionary() {
        return this.getCryptFilterDictionary(COSName.DEFAULT_CRYPT_FILTER);
    }

    public PDCryptFilterDictionary getCryptFilterDictionary(COSName cryptFilterName) {
        COSDictionary stdCryptFilterDictionary;
        COSDictionary cryptFilterDictionary = this.getCOSObject().getDictionaryObject(COSName.CF, COSDictionary.class);
        if (cryptFilterDictionary != null && (stdCryptFilterDictionary = cryptFilterDictionary.getDictionaryObject(cryptFilterName, COSDictionary.class)) != null) {
            return new PDCryptFilterDictionary(stdCryptFilterDictionary);
        }
        return null;
    }

    public void setCryptFilterDictionary(COSName cryptFilterName, PDCryptFilterDictionary cryptFilterDictionary) {
        COSDictionary cfDictionary = Optional.ofNullable(this.getCOSObject().getDictionaryObject(COSName.CF, COSDictionary.class)).orElseGet(COSDictionary::new);
        this.getCOSObject().setItem(COSName.CF, (COSBase)DirectCOSObject.asDirectObject(cfDictionary));
        cfDictionary.setItem(cryptFilterName, (COSBase)DirectCOSObject.asDirectObject(cryptFilterDictionary.getCOSObject()));
    }

    public void setStdCryptFilterDictionary(PDCryptFilterDictionary cryptFilterDictionary) {
        this.setCryptFilterDictionary(COSName.STD_CF, cryptFilterDictionary);
    }

    public void setDefaultCryptFilterDictionary(PDCryptFilterDictionary defaultFilterDictionary) {
        this.setCryptFilterDictionary(COSName.DEFAULT_CRYPT_FILTER, defaultFilterDictionary);
    }

    public COSName getStreamFilterName() {
        COSName stmF = (COSName)this.getCOSObject().getDictionaryObject(COSName.STM_F);
        if (stmF == null) {
            stmF = COSName.IDENTITY;
        }
        return stmF;
    }

    public void setStreamFilterName(COSName streamFilterName) {
        this.getCOSObject().setItem(COSName.STM_F, (COSBase)streamFilterName);
    }

    public COSName getStringFilterName() {
        COSName strF = (COSName)this.getCOSObject().getDictionaryObject(COSName.STR_F);
        if (strF == null) {
            strF = COSName.IDENTITY;
        }
        return strF;
    }

    public void setStringFilterName(COSName stringFilterName) {
        this.getCOSObject().setItem(COSName.STR_F, (COSBase)stringFilterName);
    }

    public void setPerms(byte[] perms) {
        this.getCOSObject().setItem(COSName.PERMS, (COSBase)COSString.newInstance(perms));
    }

    public byte[] getPerms() {
        COSString permsCosString = this.getCOSObject().getDictionaryObject(COSName.PERMS, COSString.class);
        if (Objects.nonNull(permsCosString)) {
            return permsCosString.getBytes();
        }
        return null;
    }

    public void removeV45filters() {
        this.getCOSObject().setItem(COSName.CF, null);
        this.getCOSObject().setItem(COSName.STM_F, null);
        this.getCOSObject().setItem(COSName.STR_F, null);
    }
}

