"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardAddPanel = void 0;

var _react = _interopRequireDefault(require("react"));

var _i18n = require("@kbn/i18n");

var _react2 = require("@kbn/i18n/react");

var _capabilities = require("ui/capabilities");

var _notify = require("ui/notify");

var _saved_object_finder = require("ui/saved_objects/components/saved_object_finder");

var _eui = require("@elastic/eui");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var DashboardAddPanel =
/*#__PURE__*/
function (_React$Component) {
  _inherits(DashboardAddPanel, _React$Component);

  function DashboardAddPanel() {
    var _getPrototypeOf2;

    var _this;

    _classCallCheck(this, DashboardAddPanel);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(DashboardAddPanel)).call.apply(_getPrototypeOf2, [this].concat(args)));

    _defineProperty(_assertThisInitialized(_this), "lastToast", void 0);

    _defineProperty(_assertThisInitialized(_this), "onAddPanel", function (id, type, name) {
      _this.props.addNewPanel(id, type); // To avoid the clutter of having toast messages cover flyout
      // close previous toast message before creating a new one


      if (_this.lastToast) {
        _notify.toastNotifications.remove(_this.lastToast);
      }

      _this.lastToast = _notify.toastNotifications.addSuccess({
        title: _i18n.i18n.translate('kbn.dashboard.topNav.addPanel.savedObjectAddedToDashboardSuccessMessageTitle', {
          defaultMessage: '{savedObjectName} was added to your dashboard',
          values: {
            savedObjectName: name
          }
        }),
        'data-test-subj': 'addObjectToDashboardSuccess'
      });
    });

    return _this;
  }

  _createClass(DashboardAddPanel, [{
    key: "render",
    value: function render() {
      return _react.default.createElement(_eui.EuiFlyout, {
        ownFocus: true,
        onClose: this.props.onClose,
        "data-test-subj": "dashboardAddPanel"
      }, _react.default.createElement(_eui.EuiFlyoutHeader, {
        hasBorder: true
      }, _react.default.createElement(_eui.EuiTitle, {
        size: "m"
      }, _react.default.createElement("h2", null, _react.default.createElement(_react2.FormattedMessage, {
        id: "kbn.dashboard.topNav.addPanelsTitle",
        defaultMessage: "Add panels"
      })))), _react.default.createElement(_eui.EuiFlyoutBody, null, _react.default.createElement(_saved_object_finder.SavedObjectFinder, {
        onChoose: this.onAddPanel,
        savedObjectMetaData: this.props.embeddableFactories.filter(function (embeddableFactory) {
          return Boolean(embeddableFactory.savedObjectMetaData);
        }).map(function (_ref) {
          var savedObjectMetaData = _ref.savedObjectMetaData;
          return savedObjectMetaData;
        }),
        showFilter: true,
        noItemsMessage: _i18n.i18n.translate('kbn.dashboard.topNav.addPanel.noMatchingObjectsMessage', {
          defaultMessage: 'No matching objects found.'
        })
      })), _capabilities.capabilities.get().visualize.save ? _react.default.createElement(_eui.EuiFlyoutFooter, null, _react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "flexEnd"
      }, _react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, _react.default.createElement(_eui.EuiButton, {
        fill: true,
        onClick: this.props.addNewVis,
        "data-test-subj": "addNewSavedObjectLink"
      }, _react.default.createElement(_react2.FormattedMessage, {
        id: "kbn.dashboard.topNav.addPanel.createNewVisualizationButtonLabel",
        defaultMessage: "Create new visualization"
      }))))) : null);
    }
  }]);

  return DashboardAddPanel;
}(_react.default.Component);

exports.DashboardAddPanel = DashboardAddPanel;