"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardAppController = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

var _i18n = require("@kbn/i18n");

var _react = _interopRequireDefault(require("react"));

var _angular = _interopRequireDefault(require("angular"));

var _chrome = _interopRequireDefault(require("ui/chrome"));

var _notify = require("ui/notify");

var _confirm_modal = require("ui/modals/confirm_modal");

var _query_filter = require("ui/filter_manager/query_filter");

var _doc_title = require("ui/doc_title/doc_title");

var _show_saved_object_save_modal = require("ui/saved_objects/show_saved_object_save_modal");

var _share = require("ui/share");

var _migrate_legacy_query = require("ui/utils/migrate_legacy_query");

var _embeddable_factories_registry = require("ui/embeddable/embeddable_factories_registry");

var _embeddable = require("ui/embeddable");

var _vis_types = require("ui/registry/vis_types");

var _timefilter = require("ui/timefilter");

var _get_unhashable_states_provider = require("ui/state_management/state_hashing/get_unhashable_states_provider");

var _wizard = require("../visualize/wizard");

var _show_options_popover = require("./top_nav/show_options_popover");

var _show_add_panel = require("./top_nav/show_add_panel");

var _save_modal = require("./top_nav/save_modal");

var _show_clone_modal = require("./top_nav/show_clone_modal");

var _lib = require("./lib");

var _dashboard_state_manager = require("./dashboard_state_manager");

var _dashboard_constants = require("./dashboard_constants");

var _get_top_nav_config = require("./top_nav/get_top_nav_config");

var _top_nav_ids = require("./top_nav/top_nav_ids");

var _dashboard_view_mode = require("./dashboard_view_mode");

var _dashboard_strings = require("./dashboard_strings");

var _panel_actions_store = require("./store/panel_actions_store");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var DashboardAppController = // Part of the exposed plugin API - do not remove without careful consideration.
function DashboardAppController(_ref) {
  var _this = this;

  var $scope = _ref.$scope,
      $rootScope = _ref.$rootScope,
      $route = _ref.$route,
      $routeParams = _ref.$routeParams,
      getAppState = _ref.getAppState,
      dashboardConfig = _ref.dashboardConfig,
      localStorage = _ref.localStorage,
      Private = _ref.Private,
      kbnUrl = _ref.kbnUrl,
      AppStateClass = _ref.AppStateClass,
      indexPatterns = _ref.indexPatterns,
      config = _ref.config,
      confirmModal = _ref.confirmModal,
      addFilter = _ref.addFilter,
      courier = _ref.courier;

  _classCallCheck(this, DashboardAppController);

  _defineProperty(this, "appStatus", void 0);

  var queryFilter = Private(_query_filter.FilterBarQueryFilterProvider);
  var embeddableFactories = Private(_embeddable_factories_registry.EmbeddableFactoriesRegistryProvider);
  var panelActionsRegistry = Private(_embeddable.ContextMenuActionsRegistryProvider);
  var getUnhashableStates = Private(_get_unhashable_states_provider.getUnhashableStatesProvider);
  var shareContextMenuExtensions = Private(_share.ShareContextMenuExtensionsRegistryProvider); // @ts-ignore This code is going away shortly.

  _panel_actions_store.panelActionsStore.initializeFromRegistry(panelActionsRegistry);

  var visTypes = Private(_vis_types.VisTypesRegistryProvider);

  $scope.getEmbeddableFactory = function (panelType) {
    return embeddableFactories.byName[panelType];
  };

  var dash = $scope.dash = $route.current.locals.dash;

  if (dash.id) {
    _doc_title.docTitle.change(dash.title);
  }

  var dashboardStateManager = new _dashboard_state_manager.DashboardStateManager({
    savedDashboard: dash,
    AppStateClass: AppStateClass,
    hideWriteControls: dashboardConfig.getHideWriteControls(),
    addFilter: addFilter
  });

  $scope.getDashboardState = function () {
    return dashboardStateManager;
  };

  $scope.appState = dashboardStateManager.getAppState(); // The 'previouslyStored' check is so we only update the time filter on dashboard open, not during
  // normal cross app navigation.

  if (dashboardStateManager.getIsTimeSavedWithDashboard() && !getAppState.previouslyStored()) {
    dashboardStateManager.syncTimefilterWithDashboard(_timefilter.timefilter);
  }

  var updateState = function updateState() {
    // Following the "best practice" of always have a '.' in your ng-models –
    // https://github.com/angular/angular.js/wiki/Understanding-Scopes
    $scope.model = {
      query: dashboardStateManager.getQuery(),
      filters: queryFilter.getFilters(),
      timeRestore: dashboardStateManager.getTimeRestore(),
      title: dashboardStateManager.getTitle(),
      description: dashboardStateManager.getDescription(),
      timeRange: _timefilter.timefilter.getTime(),
      refreshInterval: _timefilter.timefilter.getRefreshInterval()
    };
    $scope.panels = dashboardStateManager.getPanels();
    $scope.screenTitle = dashboardStateManager.getTitle();
    var panelIndexPatterns = dashboardStateManager.getPanelIndexPatterns();

    if (panelIndexPatterns && panelIndexPatterns.length > 0) {
      $scope.indexPatterns = panelIndexPatterns;
    } else {
      indexPatterns.getDefault().then(function (defaultIndexPattern) {
        $scope.$evalAsync(function () {
          $scope.indexPatterns = [defaultIndexPattern];
        });
      });
    }
  }; // Part of the exposed plugin API - do not remove without careful consideration.


  this.appStatus = {
    dirty: !dash.id
  };
  dashboardStateManager.registerChangeListener(function (status) {
    _this.appStatus.dirty = status.dirty || !dash.id;
    updateState();
  });
  dashboardStateManager.applyFilters(dashboardStateManager.getQuery() || {
    query: '',
    language: localStorage.get('kibana.userQueryLanguage') || config.get('search:queryLanguage')
  }, queryFilter.getFilters());

  _timefilter.timefilter.disableTimeRangeSelector();

  _timefilter.timefilter.disableAutoRefreshSelector();

  updateState();

  $scope.refresh = function () {
    $rootScope.$broadcast('fetch');
    courier.fetch();
  };

  dashboardStateManager.handleTimeChange(_timefilter.timefilter.getTime());
  dashboardStateManager.handleRefreshConfigChange(_timefilter.timefilter.getRefreshInterval());

  var landingPageUrl = function landingPageUrl() {
    return "#".concat(_dashboard_constants.DashboardConstants.LANDING_PAGE_PATH);
  };

  var getDashTitle = function getDashTitle() {
    return (0, _dashboard_strings.getDashboardTitle)(dashboardStateManager.getTitle(), dashboardStateManager.getViewMode(), dashboardStateManager.getIsDirty(_timefilter.timefilter));
  }; // Push breadcrumbs to new header navigation


  var updateBreadcrumbs = function updateBreadcrumbs() {
    _chrome.default.breadcrumbs.set([{
      text: _i18n.i18n.translate('kbn.dashboard.dashboardAppBreadcrumbsTitle', {
        defaultMessage: 'Dashboard'
      }),
      href: landingPageUrl()
    }, {
      text: getDashTitle()
    }]);
  };

  updateBreadcrumbs();
  dashboardStateManager.registerChangeListener(updateBreadcrumbs);

  $scope.getShouldShowEditHelp = function () {
    return !dashboardStateManager.getPanels().length && dashboardStateManager.getIsEditMode() && !dashboardConfig.getHideWriteControls();
  };

  $scope.getShouldShowViewHelp = function () {
    return !dashboardStateManager.getPanels().length && dashboardStateManager.getIsViewMode() && !dashboardConfig.getHideWriteControls();
  };

  $scope.updateQueryAndFetch = function (_ref2) {
    var query = _ref2.query,
        dateRange = _ref2.dateRange;

    if (dateRange) {
      _timefilter.timefilter.setTime(dateRange);
    }

    var oldQuery = $scope.model.query;

    if (_lodash.default.isEqual(oldQuery, query)) {
      // The user can still request a reload in the query bar, even if the
      // query is the same, and in that case, we have to explicitly ask for
      // a reload, since no state changes will cause it.
      dashboardStateManager.requestReload();
    } else {
      $scope.model.query = query;
      dashboardStateManager.applyFilters($scope.model.query, $scope.model.filters);
    }

    $scope.refresh();
  };

  $scope.onRefreshChange = function (_ref3) {
    var isPaused = _ref3.isPaused,
        refreshInterval = _ref3.refreshInterval;

    _timefilter.timefilter.setRefreshInterval({
      pause: isPaused,
      value: refreshInterval ? refreshInterval : $scope.model.refreshInterval.value
    });
  };

  $scope.onFiltersUpdated = function (filters) {
    // The filters will automatically be set when the queryFilter emits an update event (see below)
    queryFilter.setFilters(filters);
  };

  $scope.onCancelApplyFilters = function () {
    $scope.appState.$newFilters = [];
  };

  $scope.onApplyFilters = function (filters) {
    queryFilter.addFiltersAndChangeTimeFilter(filters);
    $scope.appState.$newFilters = [];
  };

  $scope.$watch('appState.$newFilters', function () {
    var filters = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];

    if (filters.length === 1) {
      $scope.onApplyFilters(filters);
    }
  });
  $scope.indexPatterns = [];
  $scope.$watch('model.query', function (newQuery) {
    var query = (0, _migrate_legacy_query.migrateLegacyQuery)(newQuery);
    $scope.updateQueryAndFetch({
      query: query
    });
  });
  $scope.$listenAndDigestAsync(_timefilter.timefilter, 'fetch', function () {
    dashboardStateManager.handleTimeChange(_timefilter.timefilter.getTime()); // Currently discover relies on this logic to re-fetch. We need to refactor it to rely instead on the
    // directly passed down time filter. Then we can get rid of this reliance on scope broadcasts.

    $scope.refresh();
  });
  $scope.$listenAndDigestAsync(_timefilter.timefilter, 'refreshIntervalUpdate', function () {
    dashboardStateManager.handleRefreshConfigChange(_timefilter.timefilter.getRefreshInterval());
    updateState();
  });
  $scope.$listenAndDigestAsync(_timefilter.timefilter, 'timeUpdate', updateState);

  function updateViewMode(newMode) {
    $scope.topNavMenu = (0, _get_top_nav_config.getTopNavConfig)(newMode, navActions, dashboardConfig.getHideWriteControls()); // eslint-disable-line no-use-before-define

    dashboardStateManager.switchViewMode(newMode);
  }

  var onChangeViewMode = function onChangeViewMode(newMode) {
    var isPageRefresh = newMode === dashboardStateManager.getViewMode();
    var isLeavingEditMode = !isPageRefresh && newMode === _dashboard_view_mode.DashboardViewMode.VIEW;
    var willLoseChanges = isLeavingEditMode && dashboardStateManager.getIsDirty(_timefilter.timefilter);

    if (!willLoseChanges) {
      updateViewMode(newMode);
      return;
    }

    function revertChangesAndExitEditMode() {
      dashboardStateManager.resetState();
      kbnUrl.change(dash.id ? (0, _dashboard_constants.createDashboardEditUrl)(dash.id) : _dashboard_constants.DashboardConstants.CREATE_NEW_DASHBOARD_URL); // This is only necessary for new dashboards, which will default to Edit mode.

      updateViewMode(_dashboard_view_mode.DashboardViewMode.VIEW); // We need to do a hard reset of the timepicker. appState will not reload like
      // it does on 'open' because it's been saved to the url and the getAppState.previouslyStored() check on
      // reload will cause it not to sync.

      if (dashboardStateManager.getIsTimeSavedWithDashboard()) {
        dashboardStateManager.syncTimefilterWithDashboard(_timefilter.timefilter);
      }
    }

    confirmModal(_i18n.i18n.translate('kbn.dashboard.changeViewModeConfirmModal.discardChangesDescription', {
      defaultMessage: "Once you discard your changes, there's no getting them back."
    }), {
      onConfirm: revertChangesAndExitEditMode,
      onCancel: _lodash.default.noop,
      confirmButtonText: _i18n.i18n.translate('kbn.dashboard.changeViewModeConfirmModal.confirmButtonLabel', {
        defaultMessage: 'Discard changes'
      }),
      cancelButtonText: _i18n.i18n.translate('kbn.dashboard.changeViewModeConfirmModal.cancelButtonLabel', {
        defaultMessage: 'Continue editing'
      }),
      defaultFocusedButton: _confirm_modal.ConfirmationButtonTypes.CANCEL,
      title: _i18n.i18n.translate('kbn.dashboard.changeViewModeConfirmModal.discardChangesTitle', {
        defaultMessage: 'Discard changes to dashboard?'
      })
    });
  };
  /**
   * Saves the dashboard.
   *
   * @param {object} [saveOptions={}]
   * @property {boolean} [saveOptions.confirmOverwrite=false] - If true, attempts to create the source so it
   * can confirm an overwrite if a document with the id already exists.
   * @property {boolean} [saveOptions.isTitleDuplicateConfirmed=false] - If true, save allowed with duplicate title
   * @property {func} [saveOptions.onTitleDuplicate] - function called if duplicate title exists.
   * When not provided, confirm modal will be displayed asking user to confirm or cancel save.
   * @return {Promise}
   * @resolved {String} - The id of the doc
   */


  function save(saveOptions) {
    return (0, _lib.saveDashboard)(_angular.default.toJson, _timefilter.timefilter, dashboardStateManager, saveOptions).then(function (id) {
      if (id) {
        _notify.toastNotifications.addSuccess({
          title: _i18n.i18n.translate('kbn.dashboard.dashboardWasSavedSuccessMessage', {
            defaultMessage: "Dashboard '{dashTitle}' was saved",
            values: {
              dashTitle: dash.title
            }
          }),
          'data-test-subj': 'saveDashboardSuccess'
        });

        if (dash.id !== $routeParams.id) {
          kbnUrl.change((0, _dashboard_constants.createDashboardEditUrl)(dash.id));
        } else {
          _doc_title.docTitle.change(dash.lastSavedTitle);

          updateViewMode(_dashboard_view_mode.DashboardViewMode.VIEW);
        }
      }

      return {
        id: id
      };
    }).catch(function (error) {
      _notify.toastNotifications.addDanger({
        title: _i18n.i18n.translate('kbn.dashboard.dashboardWasNotSavedDangerMessage', {
          defaultMessage: "Dashboard '{dashTitle}' was not saved. Error: {errorMessage}",
          values: {
            dashTitle: dash.title,
            errorMessage: error.message
          }
        }),
        'data-test-subj': 'saveDashboardFailure'
      });

      return {
        error: error
      };
    });
  }

  $scope.showFilterBar = function () {
    return $scope.model.filters.length > 0 || !dashboardStateManager.getFullScreenMode();
  };

  $scope.showAddPanel = function () {
    dashboardStateManager.setFullScreenMode(false);
    $scope.kbnTopNav.click(_top_nav_ids.TopNavIds.ADD);
  };

  $scope.enterEditMode = function () {
    dashboardStateManager.setFullScreenMode(false);
    $scope.kbnTopNav.click('edit');
  };

  var navActions = {};

  navActions[_top_nav_ids.TopNavIds.FULL_SCREEN] = function () {
    return dashboardStateManager.setFullScreenMode(true);
  };

  navActions[_top_nav_ids.TopNavIds.EXIT_EDIT_MODE] = function () {
    return onChangeViewMode(_dashboard_view_mode.DashboardViewMode.VIEW);
  };

  navActions[_top_nav_ids.TopNavIds.ENTER_EDIT_MODE] = function () {
    return onChangeViewMode(_dashboard_view_mode.DashboardViewMode.EDIT);
  };

  navActions[_top_nav_ids.TopNavIds.SAVE] = function () {
    var currentTitle = dashboardStateManager.getTitle();
    var currentDescription = dashboardStateManager.getDescription();
    var currentTimeRestore = dashboardStateManager.getTimeRestore();

    var onSave = function onSave(_ref4) {
      var newTitle = _ref4.newTitle,
          newDescription = _ref4.newDescription,
          newCopyOnSave = _ref4.newCopyOnSave,
          newTimeRestore = _ref4.newTimeRestore,
          isTitleDuplicateConfirmed = _ref4.isTitleDuplicateConfirmed,
          onTitleDuplicate = _ref4.onTitleDuplicate;
      dashboardStateManager.setTitle(newTitle);
      dashboardStateManager.setDescription(newDescription);
      dashboardStateManager.savedDashboard.copyOnSave = newCopyOnSave;
      dashboardStateManager.setTimeRestore(newTimeRestore);
      var saveOptions = {
        confirmOverwrite: false,
        isTitleDuplicateConfirmed: isTitleDuplicateConfirmed,
        onTitleDuplicate: onTitleDuplicate
      };
      return save(saveOptions).then(function (response) {
        // If the save wasn't successful, put the original values back.
        if (!response.id) {
          dashboardStateManager.setTitle(currentTitle);
          dashboardStateManager.setDescription(currentDescription);
          dashboardStateManager.setTimeRestore(currentTimeRestore);
        }

        return response;
      });
    };

    var dashboardSaveModal = _react.default.createElement(_save_modal.DashboardSaveModal, {
      onSave: onSave,
      onClose: function onClose() {},
      title: currentTitle,
      description: currentDescription,
      timeRestore: currentTimeRestore,
      showCopyOnSave: dash.id ? true : false
    });

    (0, _show_saved_object_save_modal.showSaveModal)(dashboardSaveModal);
  };

  navActions[_top_nav_ids.TopNavIds.CLONE] = function () {
    var currentTitle = dashboardStateManager.getTitle();

    var onClone = function onClone(newTitle, isTitleDuplicateConfirmed, onTitleDuplicate) {
      dashboardStateManager.savedDashboard.copyOnSave = true;
      dashboardStateManager.setTitle(newTitle);
      var saveOptions = {
        confirmOverwrite: false,
        isTitleDuplicateConfirmed: isTitleDuplicateConfirmed,
        onTitleDuplicate: onTitleDuplicate
      };
      return save(saveOptions).then(function (response) {
        // If the save wasn't successful, put the original title back.
        if (response.error) {
          dashboardStateManager.setTitle(currentTitle);
        }

        return response;
      });
    };

    (0, _show_clone_modal.showCloneModal)(onClone, currentTitle);
  };

  navActions[_top_nav_ids.TopNavIds.ADD] = function () {
    var addNewVis = function addNewVis() {
      (0, _wizard.showNewVisModal)(visTypes, {
        editorParams: [_dashboard_constants.DashboardConstants.ADD_VISUALIZATION_TO_DASHBOARD_MODE_PARAM]
      });
    };

    (0, _show_add_panel.showAddPanel)(dashboardStateManager.addNewPanel, addNewVis, embeddableFactories);
  };

  navActions[_top_nav_ids.TopNavIds.OPTIONS] = function (menuItem, navController, anchorElement) {
    (0, _show_options_popover.showOptionsPopover)({
      anchorElement: anchorElement,
      useMargins: dashboardStateManager.getUseMargins(),
      onUseMarginsChange: function onUseMarginsChange(isChecked) {
        dashboardStateManager.setUseMargins(isChecked);
      },
      hidePanelTitles: dashboardStateManager.getHidePanelTitles(),
      onHidePanelTitlesChange: function onHidePanelTitlesChange(isChecked) {
        dashboardStateManager.setHidePanelTitles(isChecked);
      }
    });
  };

  navActions[_top_nav_ids.TopNavIds.SHARE] = function (menuItem, navController, anchorElement) {
    (0, _share.showShareContextMenu)({
      anchorElement: anchorElement,
      allowEmbed: true,
      allowShortUrl: !dashboardConfig.getHideWriteControls(),
      getUnhashableStates: getUnhashableStates,
      objectId: dash.id,
      objectType: 'dashboard',
      shareContextMenuExtensions: shareContextMenuExtensions.raw,
      sharingData: {
        title: dash.title
      },
      isDirty: dashboardStateManager.getIsDirty()
    });
  };

  updateViewMode(dashboardStateManager.getViewMode()); // update root source when filters update

  var updateSubscription = queryFilter.getUpdates$().subscribe({
    next: function next() {
      $scope.model.filters = queryFilter.getFilters();
      dashboardStateManager.applyFilters($scope.model.query, $scope.model.filters);
    }
  }); // update data when filters fire fetch event

  var fetchSubscription = queryFilter.getFetches$().subscribe($scope.refresh);
  $scope.$on('$destroy', function () {
    updateSubscription.unsubscribe();
    fetchSubscription.unsubscribe();
    dashboardStateManager.destroy();
  });

  if ($route.current.params && $route.current.params[_dashboard_constants.DashboardConstants.NEW_VISUALIZATION_ID_PARAM]) {
    dashboardStateManager.addNewPanel($route.current.params[_dashboard_constants.DashboardConstants.NEW_VISUALIZATION_ID_PARAM], 'visualization');
    kbnUrl.removeParam(_dashboard_constants.DashboardConstants.ADD_VISUALIZATION_TO_DASHBOARD_MODE_PARAM);
    kbnUrl.removeParam(_dashboard_constants.DashboardConstants.NEW_VISUALIZATION_ID_PARAM);
  }
};

exports.DashboardAppController = DashboardAppController;