/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
import { nodeTypes } from '../node_types';
export function convertGeoBoundingBox(filter) {
  if (filter.meta.type !== 'geo_bounding_box') {
    throw new Error("Expected filter of type \"geo_bounding_box\", got \"".concat(filter.meta.type, "\""));
  }

  var _filter$meta = filter.meta,
      key = _filter$meta.key,
      params = _filter$meta.params;

  var camelParams = _.mapKeys(params, function (value, key) {
    return _.camelCase(key);
  });

  return nodeTypes.function.buildNode('geoBoundingBox', key, camelParams);
}