/**
 * @file Mutable references in the `IO` monad
 */
import { IO } from './IO';
/**
 * @example
 * import { newIORef } from 'fp-ts/lib/IORef'
 *
 * assert.strictEqual(
 *   newIORef(1)
 *     .chain(ref => ref.write(2).chain(() => ref.read))
 *     .run(),
 *   2
 * )
 * @since 1.8.0
 */
export class IORef {
    constructor(value) {
        this.value = value;
        this.read = new IO(() => this.value);
    }
    /**
     * @since 1.8.0
     */
    write(a) {
        return new IO(() => {
            this.value = a;
        });
    }
    /**
     * @since 1.8.0
     */
    modify(f) {
        return new IO(() => {
            this.value = f(this.value);
        });
    }
}
/**
 * @since 1.8.0
 */
export const newIORef = (a) => {
    return new IO(() => new IORef(a));
};
