"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Map each y value from a RawDataSeries on it's specific x value into,
 * ordering the stack based on the dataseries index.
 * @param dataseries
 */
function getYValueStackMap(dataseries) {
    var stackMap = new Map();
    dataseries.forEach(function (ds, index) {
        ds.data.forEach(function (datum) {
            var stack = stackMap.get(datum.x) || new Array(dataseries.length).fill(0);
            stack[index] = datum.y1;
            stackMap.set(datum.x, stack);
        });
    });
    return stackMap;
}
exports.getYValueStackMap = getYValueStackMap;
/**
 * For each key of the yValueStackMap, it stacks the values one after the other,
 * summing the previous value to the next one.
 * @param yValueStackMap
 * @param scaleToExtent
 */
function computeYStackedMapValues(yValueStackMap, scaleToExtent) {
    var stackedValues = new Map();
    yValueStackMap.forEach(function (yStackArray, xValue) {
        var stackArray = yStackArray.reduce(function (stackedValue, currentValue, index) {
            if (stackedValue.length === 0) {
                if (scaleToExtent) {
                    return [currentValue, currentValue];
                }
                return [0, currentValue];
            }
            return __spread(stackedValue, [stackedValue[index] + currentValue]);
        }, []);
        stackedValues.set(xValue, stackArray);
    });
    return stackedValues;
}
exports.computeYStackedMapValues = computeYStackedMapValues;
function formatStackedDataSeriesValues(dataseries, scaleToExtent) {
    var yValueStackMap = getYValueStackMap(dataseries);
    var stackedValues = computeYStackedMapValues(yValueStackMap, scaleToExtent);
    var stackedDataSeries = dataseries.map(function (ds, seriesIndex) {
        var newData = [];
        ds.data.forEach(function (data) {
            var x = data.x, y1 = data.y1, datum = data.datum;
            if (stackedValues.get(x) === undefined) {
                return;
            }
            var computedY0;
            if (scaleToExtent) {
                computedY0 = data.y0 ? data.y0 : y1;
            }
            else {
                computedY0 = data.y0 ? data.y0 : 0;
            }
            var initialY0 = data.y0 == null ? null : data.y0;
            if (seriesIndex === 0) {
                newData.push({
                    x: x,
                    y1: y1,
                    y0: computedY0,
                    initialY1: y1,
                    initialY0: initialY0,
                    datum: datum,
                });
            }
            else {
                var stack = stackedValues.get(x);
                if (!stack) {
                    return;
                }
                var stackY = stack[seriesIndex];
                var stackedY1 = y1 !== null ? stackY + y1 : null;
                var stackedY0 = data.y0 == null ? stackY : stackY + data.y0;
                // configure null y0 if y1 is null
                // it's semantically right to say y0 is null if y1 is null
                if (stackedY1 === null) {
                    stackedY0 = null;
                }
                newData.push({
                    x: x,
                    y1: stackedY1,
                    y0: stackedY0,
                    initialY1: y1,
                    initialY0: initialY0,
                    datum: datum,
                });
            }
        });
        return {
            specId: ds.specId,
            key: ds.key,
            seriesColorKey: ds.seriesColorKey,
            data: newData,
        };
    });
    return stackedDataSeries;
}
exports.formatStackedDataSeriesValues = formatStackedDataSeriesValues;
//# sourceMappingURL=stacked_series_utils.js.map