/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.JsseUtils_7;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JsseUtils_8
extends JsseUtils_7 {
    JsseUtils_8() {
    }

    static SNIMatcher exportSNIMatcher(BCSNIMatcher bCSNIMatcher) {
        if (null == bCSNIMatcher) {
            return null;
        }
        if (bCSNIMatcher instanceof ImportSNIMatcher) {
            return ((ImportSNIMatcher)bCSNIMatcher).unwrap();
        }
        return new ExportSNIMatcher(bCSNIMatcher);
    }

    static Object exportSNIMatchers(Collection<BCSNIMatcher> collection) {
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SNIMatcher> arrayList = new ArrayList<SNIMatcher>(collection.size());
        for (BCSNIMatcher bCSNIMatcher : collection) {
            arrayList.add(JsseUtils_8.exportSNIMatcher(bCSNIMatcher));
        }
        return Collections.unmodifiableList(arrayList);
    }

    static SNIServerName exportSNIServerName(BCSNIServerName bCSNIServerName) {
        if (null == bCSNIServerName) {
            return null;
        }
        int n = bCSNIServerName.getType();
        byte[] byArray = bCSNIServerName.getEncoded();
        switch (n) {
            case 0: {
                return new SNIHostName(byArray);
            }
        }
        return new UnknownServerName(n, byArray);
    }

    static Object exportSNIServerNames(Collection<BCSNIServerName> collection) {
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SNIServerName> arrayList = new ArrayList<SNIServerName>(collection.size());
        for (BCSNIServerName bCSNIServerName : collection) {
            arrayList.add(JsseUtils_8.exportSNIServerName(bCSNIServerName));
        }
        return Collections.unmodifiableList(arrayList);
    }

    static BCSNIMatcher importSNIMatcher(SNIMatcher sNIMatcher) {
        if (null == sNIMatcher) {
            return null;
        }
        if (sNIMatcher instanceof ExportSNIMatcher) {
            return ((ExportSNIMatcher)sNIMatcher).unwrap();
        }
        return new ImportSNIMatcher(sNIMatcher);
    }

    static List<BCSNIMatcher> importSNIMatchers(Object object) {
        Collection collection = (Collection)object;
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BCSNIMatcher> arrayList = new ArrayList<BCSNIMatcher>(collection.size());
        for (SNIMatcher sNIMatcher : collection) {
            arrayList.add(JsseUtils_8.importSNIMatcher(sNIMatcher));
        }
        return Collections.unmodifiableList(arrayList);
    }

    static BCSNIServerName importSNIServerName(SNIServerName sNIServerName) {
        if (null == sNIServerName) {
            return null;
        }
        int n = sNIServerName.getType();
        byte[] byArray = sNIServerName.getEncoded();
        switch (n) {
            case 0: {
                return new BCSNIHostName(byArray);
            }
        }
        return new JsseUtils.BCUnknownServerName(n, byArray);
    }

    static List<BCSNIServerName> importSNIServerNames(Object object) {
        Collection collection = (Collection)object;
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BCSNIServerName> arrayList = new ArrayList<BCSNIServerName>(collection.size());
        for (SNIServerName sNIServerName : collection) {
            arrayList.add(JsseUtils_8.importSNIServerName(sNIServerName));
        }
        return Collections.unmodifiableList(arrayList);
    }

    static class ExportSNIMatcher
    extends SNIMatcher {
        private final BCSNIMatcher matcher;

        ExportSNIMatcher(BCSNIMatcher bCSNIMatcher) {
            super(bCSNIMatcher.getType());
            this.matcher = bCSNIMatcher;
        }

        public boolean matches(SNIServerName sNIServerName) {
            return this.matcher.matches(JsseUtils_8.importSNIServerName(sNIServerName));
        }

        BCSNIMatcher unwrap() {
            return this.matcher;
        }
    }

    static class ImportSNIMatcher
    extends BCSNIMatcher {
        private final SNIMatcher matcher;

        ImportSNIMatcher(SNIMatcher sNIMatcher) {
            super(sNIMatcher.getType());
            this.matcher = sNIMatcher;
        }

        public boolean matches(BCSNIServerName bCSNIServerName) {
            return this.matcher.matches(JsseUtils_8.exportSNIServerName(bCSNIServerName));
        }

        SNIMatcher unwrap() {
            return this.matcher;
        }
    }

    static class UnknownServerName
    extends SNIServerName {
        UnknownServerName(int n, byte[] byArray) {
            super(n, byArray);
        }
    }
}

