/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.util.ArrayList;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.Track;
import tim.prune.function.DistanceTimeLimitFunction;
import tim.prune.undo.UndoAppendPoints;

public class CreateMarkerWaypointsFunction
extends DistanceTimeLimitFunction {
    private ArrayList<DataPoint> _pointsToAdd = new ArrayList();
    private int _previousMultiple = 0;

    public CreateMarkerWaypointsFunction(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.createmarkerwaypoints";
    }

    private void initMemory() {
        this._pointsToAdd.clear();
        this._previousMultiple = 0;
    }

    protected void performFunction() {
        boolean bl;
        int n = this.getTimeLimitInSeconds();
        boolean bl2 = n > 0;
        double d = this.getDistanceLimitRadians();
        boolean bl3 = bl = d > 0.0;
        if (!bl2 && !bl) {
            return;
        }
        int n2 = this._app.getTrackInfo().getTrack().getNumPoints();
        UndoAppendPoints undoAppendPoints = new UndoAppendPoints(n2);
        this.initMemory();
        DataPoint dataPoint = null;
        DataPoint dataPoint2 = null;
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            dataPoint = this._app.getTrackInfo().getTrack().getPoint(n3);
            if (!dataPoint.isWaypoint()) {
                if (!dataPoint.getSegmentStart() && dataPoint2 != null) {
                    if (bl2) {
                        if (dataPoint.hasTimestamp() && dataPoint2.hasTimestamp()) {
                            this.processValue(dataPoint2, d3, n, dataPoint, d2 += (double)dataPoint.getTimestamp().getMillisecondsSince(dataPoint2.getTimestamp()) / 1000.0);
                        }
                    } else if (bl) {
                        this.processValue(dataPoint2, d3, d, dataPoint, d2 += DataPoint.calculateRadiansBetween(dataPoint2, dataPoint));
                    }
                }
                dataPoint2 = dataPoint;
                d3 = d2;
            }
            ++n3;
        }
        if (!this._pointsToAdd.isEmpty()) {
            Field[] fieldArray = new Field[]{Field.LATITUDE, Field.LONGITUDE, Field.ALTITUDE, Field.WAYPT_NAME};
            int n4 = this._pointsToAdd.size();
            DataPoint[] dataPointArray = new DataPoint[n4];
            this._pointsToAdd.toArray(dataPointArray);
            Track track = new Track(new FieldList(fieldArray), dataPointArray);
            this._app.getTrackInfo().getTrack().combine(track);
            undoAppendPoints.setNumPointsAppended(n4);
            this._app.completeFunction(undoAppendPoints, I18nManager.getText("confirm.interpolate"));
            UpdateMessageBroker.informSubscribers();
        }
        this._dialog.dispose();
    }

    private void processValue(DataPoint dataPoint, double d, double d2, DataPoint dataPoint2, double d3) {
        int n = (int)Math.floor(d3 / d2);
        int n2 = this._previousMultiple + 1;
        while (n2 <= n) {
            double d4 = (double)n2 * d2 - d;
            double d5 = d3 - (double)n2 * d2;
            double d6 = d4 / (d4 + d5);
            DataPoint dataPoint3 = DataPoint.interpolate(dataPoint, dataPoint2, d6);
            dataPoint3.setFieldValue(Field.WAYPT_NAME, this.createLimitDescription(n2), false);
            this._pointsToAdd.add(dataPoint3);
            ++n2;
        }
        this._previousMultiple = n;
    }
}

