---
comments: false
type: index
---

# GitLab basics guides

This section provides resources to help you start working with GitLab and Git by focusing
on the basic features that you will need to use.

This documentation is split into the following groups:

- [GitLab-specific functionality](#gitlab-basics), for basic GitLab features.
- [General Git functionality](#working-with-git-from-the-command-line), for working
  with Git in conjunction with GitLab.

## GitLab basics

The following are guides to basic GitLab functionality:

- [Create and add your SSH public key](create-your-ssh-keys.md), for enabling Git over SSH.
- [Create a project](create-project.md), to start using GitLab.
- [Create a group](../user/group/index.md#create-a-new-group), to combine and administer
  projects together.
- [Create a branch](create-branch.md), to make changes to files stored in a project's repository.
- [Fork a project](fork-project.md), to duplicate projects so they can be worked on in parallel.
- [Add a file](add-file.md), to add new files to a project's repository.
- [Create an issue](../user/project/issues/managing_issues.md#create-a-new-issue),
  to start collaborating within a project.
- [Create a merge request](add-merge-request.md), to request changes made in a branch
  be merged into a project's repository.
- See how these features come together in the [GitLab Flow introduction video](https://youtu.be/InKNIvky2KE)
  and [GitLab Flow page](../workflow/gitlab_flow.md).

## Working with Git from the command line

If you're familiar with Git on the command line, you can interact with your GitLab
projects just as you would with any other Git repository.

These resources will help get further acclimated to working on the command line.

- [Start using Git on the command line](start-using-git.md), for some simple Git commands.
- [Command line basics](command-line-commands.md), to create and edit files using the command line.

More Git resources are available in GitLab's [Git documentation](../topics/git/index.md).
