/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.util.Arrays;
import java.util.Comparator;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.downloaded.TreeTableModel;

class VariableModel
implements TreeTableModel {
    private static final String[] cNames = new String[]{" Name", " Value"};
    private static final Class[] cTypes = new Class[]{class$org$mozilla$javascript$tools$debugger$downloaded$TreeTableModel == null ? (class$org$mozilla$javascript$tools$debugger$downloaded$TreeTableModel = VariableModel.class$("org.mozilla.javascript.tools.debugger.downloaded.TreeTableModel")) : class$org$mozilla$javascript$tools$debugger$downloaded$TreeTableModel, class$java$lang$String == null ? (class$java$lang$String = VariableModel.class$("java.lang.String")) : class$java$lang$String};
    private static final VariableNode[] CHILDLESS = new VariableNode[0];
    private Dim debugger;
    private VariableNode root;
    static /* synthetic */ Class class$org$mozilla$javascript$tools$debugger$downloaded$TreeTableModel;
    static /* synthetic */ Class class$java$lang$String;

    public VariableModel() {
    }

    public VariableModel(Dim dim, Object object) {
        this.debugger = dim;
        this.root = new VariableNode(object, "this");
    }

    public Object getRoot() {
        if (this.debugger == null) {
            return null;
        }
        return this.root;
    }

    public int getChildCount(Object object) {
        if (this.debugger == null) {
            return 0;
        }
        VariableNode variableNode = (VariableNode)object;
        return this.children(variableNode).length;
    }

    public Object getChild(Object object, int n) {
        if (this.debugger == null) {
            return null;
        }
        VariableNode variableNode = (VariableNode)object;
        return this.children(variableNode)[n];
    }

    public boolean isLeaf(Object object) {
        if (this.debugger == null) {
            return true;
        }
        VariableNode variableNode = (VariableNode)object;
        return this.children(variableNode).length == 0;
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (this.debugger == null) {
            return -1;
        }
        VariableNode variableNode = (VariableNode)object;
        VariableNode variableNode2 = (VariableNode)object2;
        VariableNode[] variableNodeArray = this.children(variableNode);
        for (int i = 0; i != variableNodeArray.length; ++i) {
            if (variableNodeArray[i] != variableNode2) continue;
            return i;
        }
        return -1;
    }

    public boolean isCellEditable(Object object, int n) {
        return n == 0;
    }

    public void setValueAt(Object object, Object object2, int n) {
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public int getColumnCount() {
        return cNames.length;
    }

    public String getColumnName(int n) {
        return cNames[n];
    }

    public Class getColumnClass(int n) {
        return cTypes[n];
    }

    public Object getValueAt(Object object, int n) {
        if (this.debugger == null) {
            return null;
        }
        VariableNode variableNode = (VariableNode)object;
        switch (n) {
            case 0: {
                return variableNode.toString();
            }
            case 1: {
                String string;
                try {
                    string = this.debugger.objectToString(this.getValue(variableNode));
                }
                catch (RuntimeException runtimeException) {
                    string = runtimeException.getMessage();
                }
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = string.length();
                for (int i = 0; i < n2; ++i) {
                    char c = string.charAt(i);
                    if (Character.isISOControl(c)) {
                        c = ' ';
                    }
                    stringBuffer.append(c);
                }
                return stringBuffer.toString();
            }
        }
        return null;
    }

    private VariableNode[] children(VariableNode variableNode) {
        VariableNode[] variableNodeArray;
        if (variableNode.children != null) {
            return variableNode.children;
        }
        Object object = this.getValue(variableNode);
        Object[] objectArray = this.debugger.getObjectIds(object);
        if (objectArray.length == 0) {
            variableNodeArray = CHILDLESS;
        } else {
            Arrays.sort(objectArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object instanceof String) {
                        if (object2 instanceof Integer) {
                            return -1;
                        }
                        return ((String)object).compareToIgnoreCase((String)object2);
                    }
                    if (object2 instanceof String) {
                        return 1;
                    }
                    int n = (Integer)object;
                    int n2 = (Integer)object2;
                    return n - n2;
                }
            });
            variableNodeArray = new VariableNode[objectArray.length];
            for (int i = 0; i != objectArray.length; ++i) {
                variableNodeArray[i] = new VariableNode(object, objectArray[i]);
            }
        }
        VariableNode.access$002(variableNode, variableNodeArray);
        return variableNodeArray;
    }

    public Object getValue(VariableNode variableNode) {
        try {
            return this.debugger.getObjectProperty(variableNode.object, variableNode.id);
        }
        catch (Exception exception) {
            return "undefined";
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class VariableNode {
        private Object object;
        private Object id;
        private VariableNode[] children;

        public VariableNode(Object object, Object object2) {
            this.object = object;
            this.id = object2;
        }

        public String toString() {
            return this.id instanceof String ? (String)this.id : "[" + (Integer)this.id + "]";
        }

        static /* synthetic */ VariableNode[] access$002(VariableNode variableNode, VariableNode[] variableNodeArray) {
            variableNode.children = variableNodeArray;
            return variableNodeArray;
        }
    }
}

