/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.report;

import java.io.PrintWriter;
import java.util.Random;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.profile.ui.views.IHTMLPresentableTreeElement;
import org.eclipse.swt.widgets.Tree;

public class TreeViewer2HTML {
    private PrintWriter fWriter;
    private TreeViewer fTreeViewer;
    private Tree fTree;
    private ITableLabelProvider fLabelProvider;
    private ITreeContentProvider fContentProvider;
    private String fTableId;

    public TreeViewer2HTML(TreeViewer treeViewer, PrintWriter writer) {
        this.fTreeViewer = treeViewer;
        this.fTree = treeViewer.getTree();
        this.fLabelProvider = (ITableLabelProvider)treeViewer.getLabelProvider();
        this.fContentProvider = (ITreeContentProvider)treeViewer.getContentProvider();
        this.fTableId = Integer.toHexString(new Random().nextInt()).substring(0, 3).toUpperCase();
        this.fWriter = writer;
    }

    private void generateTableHeader() {
        this.fWriter.println("<tr>");
        int columnsNum = this.fTree.getColumnCount();
        int i = 0;
        while (i < columnsNum) {
            this.fWriter.print("<th>");
            this.fWriter.print(this.fTree.getColumn(i).getText());
            this.fWriter.println("</th>");
            ++i;
        }
        this.fWriter.println("</tr>");
    }

    private void generateTableRow(Object[] items, int tabs, String idPrefix) {
        if (items == null || items.length == 0) {
            return;
        }
        StringBuilder tabsBuf = new StringBuilder();
        int i = 0;
        while (i < tabs) {
            tabsBuf.append("&nbsp;&nbsp;&nbsp;");
            ++i;
        }
        i = 0;
        while (i < items.length) {
            int numColumns = this.fTree.getColumnCount();
            String newId = String.valueOf(idPrefix) + "_" + i;
            this.fWriter.print("<tr id=");
            this.fWriter.print(newId);
            if (items[i] instanceof IHTMLPresentableTreeElement) {
                this.fWriter.print(" class=\"");
                this.fWriter.print(((IHTMLPresentableTreeElement)items[i]).getTableRowClass());
                this.fWriter.print("\"");
            }
            this.fWriter.println(">");
            int j = 0;
            while (j < numColumns) {
                String text = this.fLabelProvider.getColumnText(items[i], j);
                this.fWriter.print("\t<td");
                if (text == null) {
                    this.fWriter.print(" align=right");
                    text = "-";
                } else {
                    switch (this.fTree.getColumn(j).getAlignment()) {
                        case 16384: {
                            this.fWriter.print(" align=left");
                            break;
                        }
                        case 0x1000000: {
                            this.fWriter.print(" align=center");
                            break;
                        }
                        case 131072: {
                            this.fWriter.print(" align=right");
                        }
                    }
                }
                this.fWriter.print(">");
                if (j == 0) {
                    this.fWriter.print(tabsBuf);
                    if (this.fContentProvider.hasChildren(items[i])) {
                        this.fWriter.print("<a href=\"#\"");
                        if (items[i] instanceof IHTMLPresentableTreeElement) {
                            this.fWriter.print(" class=\"");
                            this.fWriter.print(((IHTMLPresentableTreeElement)items[i]).getTableLinkClass());
                            this.fWriter.print("\"");
                        }
                        this.fWriter.print(" onclick=\"return toggle('");
                        this.fWriter.print(newId);
                        this.fWriter.print("');\">");
                        this.fWriter.print("<img id=\"");
                        this.fWriter.print(newId);
                        this.fWriter.print("_s\" class=\"fold\" src=\"");
                        this.fWriter.print("report_images");
                        this.fWriter.print("/minus.png\"/>");
                    }
                    this.fWriter.print("<img class=\"type\" src=\"");
                    this.fWriter.print("report_images");
                    this.fWriter.print("/");
                    if (items[i] instanceof IHTMLPresentableTreeElement) {
                        this.fWriter.print(((IHTMLPresentableTreeElement)items[i]).getImageURL());
                    }
                    this.fWriter.print("\"/>");
                }
                this.fWriter.print(text);
                this.fWriter.println("</td>");
                ++j;
            }
            this.fWriter.println("</tr>");
            this.generateTableRow(this.fContentProvider.getChildren(items[i]), tabs + 1, newId);
            ++i;
        }
    }

    private void generateTableRows() {
        this.generateTableRow(this.fContentProvider.getChildren(this.fTreeViewer.getInput()), 0, this.fTableId);
    }

    private void generateTable() {
        this.fWriter.print("<table class=\"tree\" id=");
        this.fWriter.print(this.fTableId);
        this.fWriter.println(">");
        this.fWriter.println("<colgroup><col width=\"200\" /><col width=\"0*\" /></colgroup>");
        this.generateTableHeader();
        this.generateTableRows();
        this.fWriter.println("</table>");
    }

    public static void process(TreeViewer treeViewer, PrintWriter writer) {
        TreeViewer2HTML treeViewer2HTML = new TreeViewer2HTML(treeViewer, writer);
        treeViewer2HTML.generateTable();
    }
}

