/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.viewmodel;

import java.util.LinkedList;
import org.eclipse.cdt.dsf.concurrent.DsfExecutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.viewers.TreePath;

public class VMViewerUpdate
extends DsfExecutable
implements IViewerUpdate {
    private final RequestMonitor fRequestMonitor;
    private final IViewerUpdate fClientUpdate;

    public VMViewerUpdate(IViewerUpdate clientUpdate, RequestMonitor requestMonitor) {
        this.fRequestMonitor = requestMonitor;
        this.fClientUpdate = clientUpdate;
    }

    public VMViewerUpdate(IModelDelta delta, IPresentationContext presentationContext, RequestMonitor requestMonitor) {
        LinkedList<Object> elementList = new LinkedList<Object>();
        IModelDelta listDelta = delta;
        elementList.add(0, listDelta.getElement());
        while (listDelta.getParentDelta() != null) {
            listDelta = listDelta.getParentDelta();
            elementList.add(0, listDelta.getElement());
        }
        Object viewerInput = elementList.remove(0);
        this.fClientUpdate = new ClientUpdatePlaceHolder(new TreePath(elementList.toArray()), viewerInput, presentationContext);
        this.fRequestMonitor = requestMonitor;
    }

    public VMViewerUpdate(TreePath elementPath, Object viewerInput, IPresentationContext presentationContext, RequestMonitor requestMonitor) {
        this.fRequestMonitor = requestMonitor;
        this.fClientUpdate = new ClientUpdatePlaceHolder(elementPath, viewerInput, presentationContext);
    }

    protected RequestMonitor getRequestMonitor() {
        return this.fRequestMonitor;
    }

    public Object getViewerInput() {
        return this.fClientUpdate.getViewerInput();
    }

    public Object getElement() {
        return this.fClientUpdate.getElement();
    }

    public TreePath getElementPath() {
        return this.fClientUpdate.getElementPath();
    }

    public IPresentationContext getPresentationContext() {
        return this.fClientUpdate.getPresentationContext();
    }

    public IStatus getStatus() {
        return this.fRequestMonitor.getStatus();
    }

    public void setStatus(IStatus status) {
        this.fRequestMonitor.setStatus(status);
    }

    public boolean isCanceled() {
        return this.fClientUpdate.isCanceled();
    }

    public void cancel() {
        this.fClientUpdate.cancel();
    }

    public void done() {
        this.setSubmitted();
        if (this.isCanceled()) {
            this.fRequestMonitor.cancel();
            this.fRequestMonitor.setStatus((IStatus)new Status(8, "org.eclipse.cdt.dsf.ui", " Update was canceled"));
        }
        this.fRequestMonitor.done();
    }

    private static class ClientUpdatePlaceHolder
    implements IViewerUpdate {
        private volatile boolean fCanceled;
        private final Object fViewerInput;
        private final TreePath fElementPath;
        private final IPresentationContext fPresentationContext;

        ClientUpdatePlaceHolder(TreePath elementPath, Object viewerInput, IPresentationContext presentationContext) {
            this.fViewerInput = viewerInput;
            this.fElementPath = elementPath;
            this.fPresentationContext = presentationContext;
        }

        public void cancel() {
            this.fCanceled = true;
        }

        public boolean isCanceled() {
            return this.fCanceled;
        }

        public IPresentationContext getPresentationContext() {
            return this.fPresentationContext;
        }

        public Object getElement() {
            return this.fElementPath.getSegmentCount() != 0 ? this.fElementPath.getLastSegment() : this.fViewerInput;
        }

        public TreePath getElementPath() {
            return this.fElementPath;
        }

        public Object getViewerInput() {
            return this.fViewerInput;
        }

        public void done() {
            assert (false);
        }

        public void setStatus(IStatus status) {
            assert (false);
        }

        public IStatus getStatus() {
            assert (false);
            return null;
        }
    }
}

