/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.folding;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.ui.text.folding.CFoldingStructureProviderDescriptor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.folding.ICFoldingStructureProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class CFoldingStructureProviderRegistry {
    private static final String EXTENSION_POINT = "foldingStructureProviders";
    private Map<String, CFoldingStructureProviderDescriptor> fDescriptors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CFoldingStructureProviderDescriptor[] getFoldingProviderDescriptors() {
        CFoldingStructureProviderRegistry cFoldingStructureProviderRegistry = this;
        synchronized (cFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return this.fDescriptors.values().toArray(new CFoldingStructureProviderDescriptor[this.fDescriptors.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CFoldingStructureProviderDescriptor getFoldingProviderDescriptor(String id) {
        CFoldingStructureProviderRegistry cFoldingStructureProviderRegistry = this;
        synchronized (cFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return this.fDescriptors.get(id);
        }
    }

    public ICFoldingStructureProvider getCurrentFoldingProvider() {
        String id = CUIPlugin.getDefault().getPreferenceStore().getString("editor_folding_provider");
        CFoldingStructureProviderDescriptor desc = this.getFoldingProviderDescriptor(id);
        if (desc != null) {
            try {
                return desc.createProvider();
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
        }
        return null;
    }

    private void ensureRegistered() {
        if (this.fDescriptors == null) {
            this.reloadExtensions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        HashMap<String, CFoldingStructureProviderDescriptor> map = new HashMap<String, CFoldingStructureProviderDescriptor>();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(CUIPlugin.getPluginId(), EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            CFoldingStructureProviderDescriptor desc = new CFoldingStructureProviderDescriptor(elements[i]);
            map.put(desc.getId(), desc);
            ++i;
        }
        CFoldingStructureProviderRegistry cFoldingStructureProviderRegistry = this;
        synchronized (cFoldingStructureProviderRegistry) {
            this.fDescriptors = Collections.unmodifiableMap(map);
        }
    }
}

