/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.predicates.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.base.provider.ModelElementItemProvider;
import org.eclipse.oomph.predicates.PredicatesPackage;
import org.eclipse.oomph.predicates.RepositoryPredicate;
import org.eclipse.oomph.predicates.provider.PredicateItemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryPredicateItemProvider
extends PredicateItemProvider {
    private static final IWorkspaceRoot WORKSPACE_ROOT = ResourcesPlugin.getWorkspace().getRoot();

    public RepositoryPredicateItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addProjectPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addProjectPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_RepositoryPredicate_project_feature"), this.getString("_UI_RepositoryPredicate_project_description"), (EStructuralFeature)PredicatesPackage.Literals.REPOSITORY_PREDICATE__PROJECT, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                ArrayList<IProject> result = new ArrayList<IProject>();
                IProject[] iProjectArray = WORKSPACE_ROOT.getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    result.add(project);
                    ++n2;
                }
                return result;
            }
        });
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/RepositoryPredicate"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        IProject project = ((RepositoryPredicate)object).getProject();
        return project == null ? this.getString("_UI_RepositoryPredicate_type") : "In same repository as " + project.getName();
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(RepositoryPredicate.class)) {
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected Command createPrimaryDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        return new ModelElementItemProvider.BaseDragAndDropCommand(domain, owner, location, operations, operation, collection){

            protected boolean analyzeForNonContainment(Command command) {
                return true;
            }
        };
    }

    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        if (feature == null && value instanceof Collection) {
            for (Object item : (Collection)value) {
                if (!(item instanceof IProject)) continue;
                IProject project = (IProject)item;
                return new SetCommand(domain, owner, (EStructuralFeature)PredicatesPackage.Literals.REPOSITORY_PREDICATE__PROJECT, (Object)project);
            }
        }
        return super.createSetCommand(domain, owner, feature, value);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

