/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.dict.OracleConnectionType;
import org.jkiss.dbeaver.ext.oracle.oci.OCIUtils;
import org.jkiss.dbeaver.ext.oracle.oci.OracleHomeDescriptor;
import org.jkiss.dbeaver.ext.oracle.ui.internal.OracleUIMessages;
import org.jkiss.dbeaver.ext.oracle.ui.tools.OracleScriptExecuteWizardPageSettings;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.dialogs.tools.AbstractScriptExecuteWizard;
import org.jkiss.dbeaver.utils.RuntimeUtils;

class OracleScriptExecuteWizard
extends AbstractScriptExecuteWizard<OracleDataSource, OracleDataSource> {
    private OracleScriptExecuteWizardPageSettings mainPage = new OracleScriptExecuteWizardPageSettings(this);

    public OracleScriptExecuteWizard(OracleDataSource oracleSchema) {
        super(Collections.singleton(oracleSchema), OracleUIMessages.tools_script_execute_wizard_page_name);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.mainPage);
        super.addPages();
    }

    public void fillProcessParameters(List<String> cmd, OracleDataSource arg) throws IOException {
        String sqlPlusExec = RuntimeUtils.getNativeBinaryName((String)"sqlplus");
        File sqlPlusBinary = new File(this.getClientHome().getPath(), "bin/" + sqlPlusExec);
        if (!sqlPlusBinary.exists()) {
            sqlPlusBinary = new File(this.getClientHome().getPath(), sqlPlusExec);
        }
        if (!sqlPlusBinary.exists()) {
            throw new IOException(NLS.bind((String)OracleUIMessages.tools_script_execute_wizard_error_sqlplus_not_found, (Object)this.getClientHome().getDisplayName()));
        }
        String dumpPath = sqlPlusBinary.getAbsolutePath();
        cmd.add(dumpPath);
    }

    public OracleHomeDescriptor findNativeClientHome(String clientHomeId) {
        return OCIUtils.getOraHome((String)clientHomeId);
    }

    public Collection<OracleDataSource> getRunInfo() {
        return this.getDatabaseObjects();
    }

    protected List<String> getCommandLine(OracleDataSource arg) throws IOException {
        String url;
        ArrayList<String> cmd = new ArrayList<String>();
        this.fillProcessParameters(cmd, arg);
        DBPConnectionConfiguration conInfo = this.getConnectionInfo();
        if ("TNS".equals(conInfo.getProviderProperty("@dbeaver-connection-type@"))) {
            url = conInfo.getServerName();
        } else {
            boolean isSID = OracleConnectionType.SID.name().equals(conInfo.getProviderProperty("@dbeaver-sid-service@"));
            String port = conInfo.getHostPort();
            url = isSID ? "(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(Host=" + conInfo.getHostName() + ")(Port=" + port + "))(CONNECT_DATA=(SID=" + conInfo.getDatabaseName() + ")))" : "//" + conInfo.getHostName() + (port != null ? ":" + port : "") + "/" + conInfo.getDatabaseName();
        }
        String role = conInfo.getProviderProperty("@dbeaver-internal-logon@");
        if (role != null) {
            url = String.valueOf(url) + " AS " + role;
        }
        cmd.add(String.valueOf(conInfo.getUserName()) + "/" + conInfo.getUserPassword() + "@" + url);
        return cmd;
    }
}

