/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data.handlers;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBConstants;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDContentValueHandler;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentAbstract;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentBLOB;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentBytes;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentCLOB;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentChars;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentXML;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCAbstractValueHandler;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class JDBCContentValueHandler
extends JDBCAbstractValueHandler
implements DBDContentValueHandler {
    private static final Log log = Log.getLog(JDBCContentValueHandler.class);
    public static final JDBCContentValueHandler INSTANCE = new JDBCContentValueHandler();
    public static final int MAX_CACHED_CLOB_LENGTH = 10000;

    @Override
    @NotNull
    public String getValueContentType(@NotNull DBSTypedObject attribute) {
        if (attribute.getTypeID() == 2009) {
            return "text/xml";
        }
        return "application/octet-stream";
    }

    @Override
    protected DBDContent fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        Object value = resultSet.getObject(index);
        if (value == null && !resultSet.wasNull()) {
            switch (type.getTypeID()) {
                case -16: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2011: {
                    value = resultSet.getString(index);
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    value = resultSet.getBytes(index);
                    break;
                }
                case 2009: {
                    value = resultSet.getSQLXML(index);
                    break;
                }
                default: {
                    value = resultSet.getObject(index);
                }
            }
        }
        if (value instanceof String) {
            return new JDBCContentChars(session.getDataSource(), (String)value);
        }
        return this.getValueFromObject(session, type, value, false);
    }

    @Override
    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        if (!(value instanceof JDBCContentAbstract)) {
            throw new DBCException(String.valueOf(ModelMessages.model_jdbc_unsupported_value_type_) + value);
        }
        ((JDBCContentAbstract)value).bindParameter(session, statement, paramType, paramIndex);
    }

    @NotNull
    public Class<DBDContent> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return DBDContent.class;
    }

    @Override
    public DBDContent getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        if (object == null) {
            switch (type.getTypeID()) {
                case -16: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    return new JDBCContentChars(session.getDataSource(), null);
                }
                case 2005: 
                case 2011: {
                    return new JDBCContentCLOB(session.getDataSource(), null);
                }
                case -4: 
                case -3: 
                case -2: {
                    return new JDBCContentBytes(session.getDataSource());
                }
                case 2004: {
                    return new JDBCContentBLOB(session.getDataSource(), null);
                }
                case 2009: {
                    return new JDBCContentXML(session.getDataSource(), null);
                }
            }
            String typeName = type.getTypeName();
            if (typeName.contains("XML") || typeName.contains(DBConstants.TYPE_NAME_XML2)) {
                return new JDBCContentXML(session.getDataSource(), null);
            }
            if (typeName.contains("JSON") || typeName.contains(DBConstants.TYPE_NAME_JSON2)) {
                return new JDBCContentChars(session.getDataSource(), null);
            }
            return new JDBCContentBytes(session.getDataSource());
        }
        if (object instanceof byte[]) {
            return new JDBCContentBytes(session.getDataSource(), (byte[])object);
        }
        if (object instanceof String) {
            switch (type.getTypeID()) {
                case -4: 
                case -3: 
                case -2: {
                    return new JDBCContentBytes(session.getDataSource(), (String)object);
                }
            }
            return new JDBCContentChars(session.getDataSource(), (String)object);
        }
        if (object instanceof Blob) {
            JDBCContentBLOB blob = new JDBCContentBLOB(session.getDataSource(), (Blob)object);
            DBPPreferenceStore preferenceStore = session.getDataSource().getContainer().getPreferenceStore();
            if (preferenceStore.getBoolean("content.cache.blob") && blob.getLOBLength() < preferenceStore.getLong("content.cache.maxsize")) {
                blob.getContents(session.getProgressMonitor());
            }
            return blob;
        }
        if (object instanceof Clob) {
            JDBCContentCLOB clob = new JDBCContentCLOB(session.getDataSource(), (Clob)object);
            DBPPreferenceStore preferenceStore = session.getDataSource().getContainer().getPreferenceStore();
            if (preferenceStore.getBoolean("content.cache.clob") && clob.getLOBLength() < preferenceStore.getLong("content.cache.maxsize")) {
                clob.getContents(session.getProgressMonitor());
            }
            return clob;
        }
        if (object instanceof SQLXML) {
            return new JDBCContentXML(session.getDataSource(), (SQLXML)object);
        }
        if (object instanceof InputStream) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            InputStream stream = (InputStream)object;
            try {
                IOUtils.copyStream((InputStream)stream, (OutputStream)buffer);
            }
            catch (Exception e) {
                throw new DBCException("Error reading content stream", e);
            }
            IOUtils.close((Closeable)stream);
            return new JDBCContentBytes(session.getDataSource(), buffer.toByteArray());
        }
        if (object instanceof Reader) {
            StringWriter buffer = new StringWriter();
            Reader reader = (Reader)object;
            try {
                IOUtils.copyText((Reader)reader, (Writer)buffer);
            }
            catch (Exception e) {
                throw new DBCException("Error reading content reader", e);
            }
            IOUtils.close((Closeable)reader);
            return new JDBCContentChars(session.getDataSource(), buffer.toString());
        }
        if (object instanceof DBDContent) {
            if (copy && object instanceof DBDValueCloneable) {
                return (DBDContent)((Object)((DBDValueCloneable)object).cloneValue(session.getProgressMonitor()));
            }
            return (DBDContent)object;
        }
        return new JDBCContentChars(session.getDataSource(), CommonUtils.toString((Object)object));
    }

    @Override
    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof DBDContent) {
            String result = ((DBDContent)value).getDisplayString(format);
            if (result == null) {
                return super.getValueDisplayString(column, null, format);
            }
            return result;
        }
        return super.getValueDisplayString(column, value, format);
    }

    @Override
    public void writeStreamValue(DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull DBSTypedObject type, @NotNull DBDContent object, @NotNull Writer writer) throws DBCException, IOException {
        DBDContentStorage cs = object.getContents(monitor);
        if (cs != null) {
            if (ContentUtils.isTextContent(object)) {
                writer.write("'");
                String strValue = ContentUtils.getContentStringValue(monitor, object);
                if (dataSource instanceof SQLDataSource) {
                    strValue = ((SQLDataSource)dataSource).getSQLDialect().escapeString(strValue);
                }
                writer.write(strValue);
                writer.write("'");
            } else if (dataSource instanceof SQLDataSource) {
                DBDBinaryFormatter binaryFormatter = ((SQLDataSource)dataSource).getSQLDialect().getNativeBinaryFormatter();
                ByteArrayOutputStream buffer = new ByteArrayOutputStream((int)cs.getContentLength());
                Throwable throwable = null;
                Object var10_12 = null;
                try (InputStream contentStream = cs.getContentStream();){
                    IOUtils.copyStream((InputStream)contentStream, (OutputStream)buffer);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                byte[] bytes = buffer.toByteArray();
                String binaryString = binaryFormatter.toString(bytes, 0, bytes.length);
                writer.write(binaryString);
            } else {
                writer.write("NULL");
            }
        } else {
            writer.write("NULL");
        }
    }
}

