/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.jimfs;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.nio.file.CopyOption;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Set;

final class Options {
    public static final ImmutableSet<LinkOption> NOFOLLOW_LINKS = ImmutableSet.of((Object)LinkOption.NOFOLLOW_LINKS);
    public static final ImmutableSet<LinkOption> FOLLOW_LINKS = ImmutableSet.of();
    private static final ImmutableSet<OpenOption> DEFAULT_READ = ImmutableSet.of((Object)StandardOpenOption.READ);
    private static final ImmutableSet<OpenOption> DEFAULT_READ_NOFOLLOW_LINKS = ImmutableSet.of((Object)StandardOpenOption.READ, (Object)LinkOption.NOFOLLOW_LINKS);
    private static final ImmutableSet<OpenOption> DEFAULT_WRITE = ImmutableSet.of((Object)StandardOpenOption.WRITE, (Object)StandardOpenOption.CREATE, (Object)StandardOpenOption.TRUNCATE_EXISTING);

    private Options() {
    }

    public static ImmutableSet<LinkOption> getLinkOptions(LinkOption ... options) {
        return options.length == 0 ? FOLLOW_LINKS : NOFOLLOW_LINKS;
    }

    public static ImmutableSet<OpenOption> getOptionsForChannel(Set<? extends OpenOption> options) {
        boolean read;
        if (options.isEmpty()) {
            return DEFAULT_READ;
        }
        boolean append = options.contains(StandardOpenOption.APPEND);
        boolean write = append || options.contains(StandardOpenOption.WRITE);
        boolean bl = read = !write || options.contains(StandardOpenOption.READ);
        if (read) {
            if (append) {
                throw new UnsupportedOperationException("'READ' + 'APPEND' not allowed");
            }
            if (!write) {
                return options.contains(LinkOption.NOFOLLOW_LINKS) ? DEFAULT_READ_NOFOLLOW_LINKS : DEFAULT_READ;
            }
        }
        if (options.contains(StandardOpenOption.WRITE)) {
            return ImmutableSet.copyOf(options);
        }
        return new ImmutableSet.Builder().add((Object)StandardOpenOption.WRITE).addAll(options).build();
    }

    public static ImmutableSet<OpenOption> getOptionsForInputStream(OpenOption ... options) {
        boolean nofollowLinks = false;
        for (OpenOption option : options) {
            if (Preconditions.checkNotNull((Object)option) == StandardOpenOption.READ) continue;
            if (option == LinkOption.NOFOLLOW_LINKS) {
                nofollowLinks = true;
                continue;
            }
            throw new UnsupportedOperationException("'" + option + "' not allowed");
        }
        return nofollowLinks ? NOFOLLOW_LINKS : FOLLOW_LINKS;
    }

    public static ImmutableSet<OpenOption> getOptionsForOutputStream(OpenOption ... options) {
        if (options.length == 0) {
            return DEFAULT_WRITE;
        }
        ImmutableSet result = ImmutableSet.copyOf((Object[])options);
        if (result.contains((Object)StandardOpenOption.READ)) {
            throw new UnsupportedOperationException("'READ' not allowed");
        }
        return result;
    }

    public static ImmutableSet<CopyOption> getMoveOptions(CopyOption ... options) {
        return ImmutableSet.copyOf((Collection)Lists.asList((Object)LinkOption.NOFOLLOW_LINKS, (Object[])options));
    }

    public static ImmutableSet<CopyOption> getCopyOptions(CopyOption ... options) {
        ImmutableSet result = ImmutableSet.copyOf((Object[])options);
        if (result.contains((Object)StandardCopyOption.ATOMIC_MOVE)) {
            throw new UnsupportedOperationException("'ATOMIC_MOVE' not allowed");
        }
        return result;
    }
}

