"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareCrossReferencedEventsView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../../atom/octicon"));

var _timeago = _interopRequireDefault(require("../../views/timeago"));

var _crossReferencedEventView = _interopRequireDefault(require("./cross-referenced-event-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCrossReferencedEventsView extends _react["default"].Component {
  render() {
    return _react["default"].createElement("div", {
      className: "timeline-item cross-referenced-events"
    }, _react["default"].createElement("div", {
      className: "info-row"
    }, _react["default"].createElement(_octicon["default"], {
      className: "pre-timeline-item-icon",
      icon: "bookmark"
    }), _react["default"].createElement("span", {
      className: "cross-referenced-event-header"
    }, this.renderSummary())), this.renderEvents());
  }

  renderSummary() {
    const first = this.props.nodes[0];

    if (this.props.nodes.length > 1) {
      return _react["default"].createElement("span", null, "This was referenced ", _react["default"].createElement(_timeago["default"], {
        time: first.referencedAt
      }));
    } else {
      const type = {
        PullRequest: 'a pull request',
        Issue: 'an issue'
      }[first.source.__typename];
      let xrefClause = '';

      if (first.isCrossRepository) {
        const repo = first.source.repository;
        xrefClause = _react["default"].createElement("span", null, "in ", _react["default"].createElement("strong", null, repo.owner.login, "/", repo.name));
      }

      return _react["default"].createElement("span", null, _react["default"].createElement("img", {
        className: "author-avatar",
        src: first.actor.avatarUrl,
        alt: first.actor.login,
        title: first.actor.login
      }), _react["default"].createElement("strong", null, first.actor.login), " referenced this from ", type, " ", xrefClause, _react["default"].createElement(_timeago["default"], {
        time: first.referencedAt
      }));
    }
  }

  renderEvents() {
    return this.props.nodes.map(node => {
      return _react["default"].createElement(_crossReferencedEventView["default"], {
        key: node.id,
        item: node
      });
    });
  }

}

exports.BareCrossReferencedEventsView = BareCrossReferencedEventsView;

_defineProperty(BareCrossReferencedEventsView, "propTypes", {
  nodes: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired,
    referencedAt: _propTypes["default"].string.isRequired,
    isCrossRepository: _propTypes["default"].bool.isRequired,
    actor: _propTypes["default"].shape({
      avatarUrl: _propTypes["default"].string.isRequired,
      login: _propTypes["default"].string.isRequired
    }),
    source: _propTypes["default"].shape({
      __typename: _propTypes["default"].oneOf(['Issue', 'PullRequest']).isRequired,
      repository: _propTypes["default"].shape({
        name: _propTypes["default"].string.isRequired,
        owner: _propTypes["default"].shape({
          login: _propTypes["default"].string.isRequired
        }).isRequired
      }).isRequired
    }).isRequired
  }).isRequired).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCrossReferencedEventsView, {
  nodes: function () {
    const node = require("./__generated__/crossReferencedEventsView_nodes.graphql");

    if (node.hash && node.hash !== "5bbb7b39e10559bac4af2d6f9ff7a9e2") {
      console.error("The definition of 'crossReferencedEventsView_nodes' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/crossReferencedEventsView_nodes.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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