"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _nodeEmoji = require("node-emoji");

var _moment = _interopRequireDefault(require("moment"));

var _multiFilePatchController = _interopRequireDefault(require("../controllers/multi-file-patch-controller"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CommitDetailView extends _react["default"].Component {
  constructor(props) {
    super(props);
    this.refRoot = new _refHolder["default"]();
  }

  render() {
    const commit = this.props.commit;
    return _react["default"].createElement("div", {
      className: "github-CommitDetailView",
      ref: this.refRoot.setter
    }, this.renderCommands(), _react["default"].createElement("div", {
      className: "github-CommitDetailView-header native-key-bindings",
      tabIndex: "-1"
    }, _react["default"].createElement("div", {
      className: "github-CommitDetailView-commit"
    }, _react["default"].createElement("h3", {
      className: "github-CommitDetailView-title"
    }, (0, _nodeEmoji.emojify)(commit.getMessageSubject())), _react["default"].createElement("div", {
      className: "github-CommitDetailView-meta"
    }, this.renderAuthors(), _react["default"].createElement("span", {
      className: "github-CommitDetailView-metaText"
    }, this.getAuthorInfo(), " committed ", this.humanizeTimeSince(commit.getAuthorDate())), _react["default"].createElement("div", {
      className: "github-CommitDetailView-sha"
    }, this.renderDotComLink())), this.renderShowMoreButton(), this.renderCommitMessageBody())), _react["default"].createElement(_multiFilePatchController["default"], _extends({
      multiFilePatch: commit.getMultiFileDiff(),
      surface: this.props.surfaceCommit
    }, this.props)));
  }

  renderCommands() {
    return _react["default"].createElement(_commands["default"], {
      registry: this.props.commands,
      target: this.refRoot
    }, _react["default"].createElement(_commands.Command, {
      command: "github:surface",
      callback: this.props.surfaceCommit
    }));
  }

  renderCommitMessageBody() {
    const collapsed = this.props.messageCollapsible && !this.props.messageOpen;
    return _react["default"].createElement("pre", {
      className: "github-CommitDetailView-moreText"
    }, collapsed ? this.props.commit.abbreviatedBody() : this.props.commit.getMessageBody());
  }

  renderShowMoreButton() {
    if (!this.props.messageCollapsible) {
      return null;
    }

    const buttonText = this.props.messageOpen ? 'Show Less' : 'Show More';
    return _react["default"].createElement("button", {
      className: "github-CommitDetailView-moreButton",
      onClick: this.props.toggleMessage
    }, buttonText);
  }

  humanizeTimeSince(date) {
    return (0, _moment["default"])(date * 1000).fromNow();
  }

  renderDotComLink() {
    const remote = this.props.currentRemote;
    const sha = this.props.commit.getSha();

    if (remote.isGithubRepo() && this.props.isCommitPushed) {
      const repoUrl = `https://github.com/${remote.getOwner()}/${remote.getRepo()}`;
      return _react["default"].createElement("a", {
        href: `${repoUrl}/commit/${sha}`,
        title: `open commit ${sha} on GitHub.com`
      }, sha);
    } else {
      return _react["default"].createElement("span", null, sha);
    }
  }

  getAuthorInfo() {
    const commit = this.props.commit;
    const coAuthorCount = commit.getCoAuthors().length;

    if (coAuthorCount === 0) {
      return commit.getAuthorName();
    } else if (coAuthorCount === 1) {
      return `${commit.getAuthorName()} and ${commit.getCoAuthors()[0].name}`;
    } else {
      return `${commit.getAuthorName()} and ${coAuthorCount} others`;
    }
  }

  renderAuthor(email) {
    const match = email.match(/^(\d+)\+[^@]+@users.noreply.github.com$/);
    let avatarUrl;

    if (match) {
      avatarUrl = 'https://avatars.githubusercontent.com/u/' + match[1] + '?s=32';
    } else {
      avatarUrl = 'https://avatars.githubusercontent.com/u/e?email=' + encodeURIComponent(email) + '&s=32';
    }

    return _react["default"].createElement("img", {
      className: "github-CommitDetailView-avatar github-RecentCommit-avatar",
      key: email,
      src: avatarUrl,
      title: email,
      alt: `${email}'s avatar'`
    });
  }

  renderAuthors() {
    const coAuthorEmails = this.props.commit.getCoAuthors().map(author => author.email);
    const authorEmails = [this.props.commit.getAuthorEmail(), ...coAuthorEmails];
    return _react["default"].createElement("span", {
      className: "github-CommitDetailView-authors github-RecentCommit-authors"
    }, authorEmails.map(this.renderAuthor));
  }

}

exports["default"] = CommitDetailView;

_defineProperty(CommitDetailView, "drilledPropTypes", {
  // Model properties
  repository: _propTypes["default"].object.isRequired,
  commit: _propTypes["default"].object.isRequired,
  currentRemote: _propTypes["default"].object.isRequired,
  isCommitPushed: _propTypes["default"].bool.isRequired,
  itemType: _propTypes["default"].func.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  keymaps: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  // Action functions
  destroy: _propTypes["default"].func.isRequired,
  surfaceCommit: _propTypes["default"].func.isRequired
});

_defineProperty(CommitDetailView, "propTypes", _objectSpread({}, CommitDetailView.drilledPropTypes, {
  // Controller state
  messageCollapsible: _propTypes["default"].bool.isRequired,
  messageOpen: _propTypes["default"].bool.isRequired,
  // Action functions
  toggleMessage: _propTypes["default"].func.isRequired
}));
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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