/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RecordableTextAction;

public class SketchTextAreaEditorKit
extends RSyntaxTextAreaEditorKit {
    public static final String rtaDeleteNextWordAction = "RTA.DeleteNextWordAction";
    public static final String rtaDeleteLineToCursorAction = "RTA.DeleteLineToCursorAction";
    public static final String rtaIncreaseIndentAction = "RTA.IncreaseIndentAction";
    private static final Action[] defaultActions = new Action[]{new DeleteNextWordAction(), new DeleteLineToCursorAction(), new IncreaseIndentAction(), new SelectWholeLineAction(), new ToggleCommentAction()};

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    public static class ToggleCommentAction
    extends RecordableTextAction {
        public ToggleCommentAction() {
            super("RSTA.ToggleCommentAction");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                return;
            }
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            Element map = doc.getDefaultRootElement();
            Caret c = textArea.getCaret();
            int dot = c.getDot();
            int mark = c.getMark();
            int line1 = map.getElementIndex(dot);
            int line2 = map.getElementIndex(mark);
            int start = Math.min(line1, line2);
            int end = Math.max(line1, line2);
            Token t = doc.getTokenListForLine(start);
            int languageIndex = t != null ? t.getLanguageIndex() : 0;
            String[] startEnd = doc.getLineCommentStartAndEnd(languageIndex);
            if (startEnd == null) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                return;
            }
            if (start != end) {
                Element elem = map.getElement(end);
                if (Math.max(dot, mark) == elem.getStartOffset()) {
                    --end;
                }
            }
            textArea.beginAtomicEdit();
            try {
                boolean add = this.getDoAdd((Document)doc, map, start, end, startEnd);
                for (line1 = start; line1 <= end; ++line1) {
                    Element elem = map.getElement(line1);
                    this.handleToggleComment(elem, (Document)doc, startEnd, add);
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
            }
            finally {
                textArea.endAtomicEdit();
            }
        }

        private boolean getDoAdd(Document doc, Element map, int startLine, int endLine, String[] startEnd) throws BadLocationException {
            boolean doAdd = false;
            for (int i = startLine; i <= endLine; ++i) {
                Element elem = map.getElement(i);
                int start = elem.getStartOffset();
                String t = doc.getText(start, elem.getEndOffset() - start - 1).trim();
                if (t.startsWith(startEnd[0]) && (startEnd[1] == null || t.endsWith(startEnd[1]))) continue;
                doAdd = true;
                break;
            }
            return doAdd;
        }

        private void handleToggleComment(Element elem, Document doc, String[] startEnd, boolean add) throws BadLocationException {
            int start = elem.getStartOffset();
            int end = elem.getEndOffset() - 1;
            if (add) {
                doc.insertString(start, startEnd[0], null);
                if (startEnd[1] != null) {
                    doc.insertString(end + startEnd[0].length(), startEnd[1], null);
                }
            } else {
                String text = doc.getText(start, elem.getEndOffset() - start - 1);
                doc.remove(start += text.indexOf(startEnd[0]), startEnd[0].length());
                if (startEnd[1] != null) {
                    int temp = startEnd[1].length();
                    doc.remove(end - startEnd[0].length() - temp, temp);
                }
            }
        }

        public final String getMacroID() {
            return "RSTA.ToggleCommentAction";
        }
    }

    public static class SelectWholeLineAction
    extends RecordableTextAction {
        public SelectWholeLineAction() {
            super("select-line");
        }

        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            Document document = textArea.getDocument();
            Element map = document.getDefaultRootElement();
            int currentLineNum = map.getElementIndex(textArea.getCaretPosition());
            Element currentLineElement = map.getElement(currentLineNum);
            textArea.select(currentLineElement.getStartOffset(), currentLineElement.getEndOffset());
        }

        public final String getMacroID() {
            return "select-line";
        }
    }

    public static class IncreaseIndentAction
    extends RSyntaxTextAreaEditorKit.InsertTabAction {
        public IncreaseIndentAction() {
            super(SketchTextAreaEditorKit.rtaIncreaseIndentAction);
        }

        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            boolean noSelec;
            int caretPosition = textArea.getCaretPosition();
            boolean bl = noSelec = textArea.getSelectedText() == null;
            if (noSelec) {
                try {
                    int line = textArea.getCaretLineNumber();
                    int startOffset = textArea.getLineStartOffset(line);
                    textArea.setCaretPosition(startOffset);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            super.actionPerformedImpl(e, textArea);
            if (noSelec) {
                textArea.setCaretPosition(caretPosition + (textArea.getTabsEmulated() ? textArea.getTabSize() : 1));
            }
        }
    }

    public static class DeleteLineToCursorAction
    extends RecordableTextAction {
        public DeleteLineToCursorAction() {
            super(SketchTextAreaEditorKit.rtaDeleteLineToCursorAction);
        }

        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                return;
            }
            try {
                Document document = textArea.getDocument();
                int caretPosition = textArea.getCaretPosition();
                Element map = document.getDefaultRootElement();
                int currentLineNum = map.getElementIndex(caretPosition);
                Element currentLineElement = map.getElement(currentLineNum);
                int currentLineStart = currentLineElement.getStartOffset();
                if (caretPosition > currentLineStart) {
                    document.remove(currentLineStart, caretPosition - currentLineStart);
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }

        public String getMacroID() {
            return SketchTextAreaEditorKit.rtaDeleteLineToCursorAction;
        }
    }

    public static class DeleteNextWordAction
    extends RecordableTextAction {
        public DeleteNextWordAction() {
            super(SketchTextAreaEditorKit.rtaDeleteNextWordAction);
        }

        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                return;
            }
            try {
                int start = textArea.getSelectionStart();
                int end = this.getNextWordStart(textArea, start);
                if (end > start) {
                    textArea.getDocument().remove(start, end - start);
                }
            }
            catch (BadLocationException ex) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
            }
        }

        public String getMacroID() {
            return SketchTextAreaEditorKit.rtaDeleteNextWordAction;
        }

        protected int getNextWordStart(RTextArea textArea, int end) throws BadLocationException {
            return Utilities.getNextWord((JTextComponent)textArea, end);
        }
    }
}

