/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.ui;

import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import java.util.Enumeration;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTableModel;
import org.openide.util.Exceptions;

class HeapViewerTreeTable
extends ProfilerTreeTable {
    private volatile boolean initializing = true;

    HeapViewerTreeTable(ProfilerTreeTableModel model, List<? extends RowSorter.SortKey> sortKeys) {
        super(model, true, true, new int[]{0});
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setShadeUnfocusedSelection(true);
        this.setForgetPreviouslyExpanded(true);
        this.setAllowsThreeStateColumns(true);
        this.getRowSorter().setSortKeys(sortKeys);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = HeapViewerTreeTable.this.getSelectedRow();
                HeapViewerNode sel = row == -1 ? null : (HeapViewerNode)((Object)HeapViewerTreeTable.this.getValueForRow(row));
                HeapViewerTreeTable.this.nodeSelected(sel, e.getValueIsAdjusting());
            }
        });
        this.initializing = false;
    }

    protected final boolean isInitializing() {
        return this.initializing;
    }

    protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
    }

    protected void forgetChildren(HeapViewerNode node) {
    }

    protected void nodeCollapsed(final TreeNode node) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HeapViewerTreeTable.this.forgetChildren((HeapViewerNode)((Object)node));
            }
        });
    }

    protected void willBeSorted(List<? extends RowSorter.SortKey> sortKeys) {
        final ProfilerTreeTable.UIState uiState = this.getUIState();
        try {
            Enumeration expanded = this.getExpandedNodes();
            this.clearSelection();
            if (expanded != null) {
                while (expanded.hasMoreElements()) {
                    HeapViewerNode node = (HeapViewerNode)((Object)((TreePath)expanded.nextElement()).getLastPathComponent());
                    node.willBeSorted();
                }
            }
        }
        catch (Throwable t) {
            Exceptions.printStackTrace((Throwable)t);
        }
        this.resetPath(null);
        if (uiState != null) {
            this.restoreSelectedNodes(uiState);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HeapViewerTreeTable.this.restoreExpandedNodes(uiState);
                }
            });
        }
    }
}

