/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.utils;

import com.github.cereda.arara.controller.ConfigurationController;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class MessageUtils {
    private static final int WIDTH = 250;

    private static int normalizeIconType(int value) {
        switch (value) {
            case 1: {
                value = 0;
                break;
            }
            case 2: {
                value = 1;
                break;
            }
            case 3: {
                value = 2;
                break;
            }
            case 4: {
                value = 3;
                break;
            }
            default: {
                value = -1;
            }
        }
        return value;
    }

    private static int normalizeMessageWidth(int value) {
        return value > 0 ? value : 250;
    }

    public static void showMessage(int width, int type, String title, String text) {
        JOptionPane.showMessageDialog(null, String.format("<html><body style=\"width:%dpx\">%s</body></html>", MessageUtils.normalizeMessageWidth(width), text), title, MessageUtils.normalizeIconType(type));
    }

    public static void showMessage(int type, String title, String text) {
        MessageUtils.showMessage(250, type, title, text);
    }

    public static int showOptions(int width, int type, String title, String text, Object ... buttons) {
        return JOptionPane.showOptionDialog(null, String.format("<html><body style=\"width:%dpx\">%s</body></html>", MessageUtils.normalizeMessageWidth(width), text), title, -1, MessageUtils.normalizeIconType(type), null, buttons, buttons[0]) + 1;
    }

    public static int showOptions(int type, String title, String text, Object ... buttons) {
        return MessageUtils.showOptions(250, type, title, text, buttons);
    }

    public static String showInput(int width, int type, String title, String text) {
        String input = JOptionPane.showInputDialog(null, String.format("<html><body style=\"width:%dpx\">%s</body></html>", MessageUtils.normalizeMessageWidth(width), text), title, MessageUtils.normalizeIconType(type));
        if (input != null) {
            return input.trim();
        }
        return "";
    }

    public static String showInput(int type, String title, String text) {
        return MessageUtils.showInput(250, type, title, text);
    }

    public static int showDropdown(int width, int type, String title, String text, Object ... elements) {
        Object index = JOptionPane.showInputDialog(null, String.format("<html><body style=\"width:%dpx\">%s</body></html>", MessageUtils.normalizeMessageWidth(width), text), title, MessageUtils.normalizeIconType(type), null, elements, elements[0]);
        if (index != null) {
            for (int i = 0; i < elements.length; ++i) {
                if (!elements[i].equals(index)) continue;
                return i + 1;
            }
        }
        return 0;
    }

    public static int showDropdown(int type, String title, String text, Object ... elements) {
        return MessageUtils.showDropdown(250, type, title, text, elements);
    }

    static {
        String laf = (String)ConfigurationController.getInstance().get("ui.lookandfeel");
        if (!laf.equals("none")) {
            if (laf.equals("system")) {
                laf = UIManager.getSystemLookAndFeelClassName();
            }
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

