/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.DefaultHeapVisitor;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.VM;

public class ConcurrentLocksPrinter {
    private Map locksMap = new HashMap();

    public ConcurrentLocksPrinter() {
        this.fillLocks();
    }

    public void print(JavaThread jthread, PrintStream tty) {
        List locks = (List)this.locksMap.get(jthread);
        tty.println("Locked ownable synchronizers:");
        if (locks == null || locks.isEmpty()) {
            tty.println("    - None");
        } else {
            for (Oop oop : locks) {
                tty.println("    - <" + oop.getHandle() + ">, (a " + oop.getKlass().getName().asString() + ")");
            }
        }
    }

    private JavaThread getOwnerThread(Oop oop) {
        Oop threadOop = OopUtilities.abstractOwnableSynchronizerGetOwnerThread(oop);
        if (threadOop == null) {
            return null;
        }
        return OopUtilities.threadOopGetJavaThread(threadOop);
    }

    private void fillLocks() {
        VM vm = VM.getVM();
        SystemDictionary sysDict = vm.getSystemDictionary();
        InstanceKlass absOwnSyncKlass = sysDict.getAbstractOwnableSynchronizerKlass();
        ObjectHeap heap = vm.getObjectHeap();
        if (absOwnSyncKlass != null) {
            heap.iterateObjectsOfKlass(new DefaultHeapVisitor(){

                @Override
                public boolean doObj(Oop oop) {
                    JavaThread thread = ConcurrentLocksPrinter.this.getOwnerThread(oop);
                    if (thread != null) {
                        LinkedList<Oop> locks = (LinkedList<Oop>)ConcurrentLocksPrinter.this.locksMap.get(thread);
                        if (locks == null) {
                            locks = new LinkedList<Oop>();
                            ConcurrentLocksPrinter.this.locksMap.put(thread, locks);
                        }
                        locks.add(oop);
                    }
                    return false;
                }
            }, absOwnSyncKlass, true);
        }
    }
}

