"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var electron_1 = require("electron");
var EnvironmentUtil = require("../runtime/EnvironmentUtil");
var config_1 = require("../settings/config");
var ConfigurationPersistence_1 = require("../settings/ConfigurationPersistence");
var WindowManager_1 = require("../window/WindowManager");
var currentEnvironment = EnvironmentUtil.getEnvironment();
var getPrimaryWindow = function () { return WindowManager_1.WindowManager.getPrimaryWindow(); };
var reloadTemplate = {
    click: function () { return getPrimaryWindow().reload(); },
    label: 'Reload',
};
var devToolsTemplate = {
    label: 'Toggle DevTools',
    submenu: [
        {
            accelerator: 'Alt+CmdOrCtrl+I',
            click: function () { return getPrimaryWindow().webContents.toggleDevTools(); },
            label: 'Sidebar',
        },
        {
            click: function () {
                var command = 'document.getElementsByTagName("webview")[0].openDevTools({mode: "detach"})';
                return getPrimaryWindow().webContents.executeJavaScript(command);
            },
            label: 'First',
        },
        {
            click: function () {
                var command = 'document.getElementsByTagName("webview")[1].openDevTools({mode: "detach"})';
                return getPrimaryWindow().webContents.executeJavaScript(command);
            },
            label: 'Second',
        },
        {
            click: function () {
                var command = 'document.getElementsByTagName("webview")[2].openDevTools({mode: "detach"})';
                return getPrimaryWindow().webContents.executeJavaScript(command);
            },
            label: 'Third',
        },
    ],
};
var createEnvironmentTemplates = function () {
    var environmentTemplate = [];
    var _loop_1 = function (key) {
        var type = EnvironmentUtil.BackendTypeLabel[key].toUpperCase();
        environmentTemplate.push({
            checked: currentEnvironment === type,
            click: function () {
                EnvironmentUtil.setEnvironment(type);
                ConfigurationPersistence_1.settings.persistToFile();
                electron_1.app.relaunch();
                electron_1.app.quit();
            },
            label: EnvironmentUtil.BackendTypeLabel[key],
            type: 'radio',
        });
    };
    for (var key in EnvironmentUtil.BackendTypeLabel) {
        _loop_1(key);
    }
    return environmentTemplate;
};
var versionTemplate = {
    enabled: false,
    label: config_1.config.name + " Version " + (config_1.config.version || 'Development'),
};
var chromeVersionTemplate = {
    enabled: false,
    label: "Chrome Version " + process.versions.chrome,
};
var electronVersionTemplate = {
    enabled: false,
    label: "Electron Version " + process.versions.electron,
};
var separatorTemplate = {
    type: 'separator',
};
var menuTemplate = {
    id: 'Developer',
    label: '&Developer',
    submenu: __spread([
        devToolsTemplate,
        reloadTemplate,
        separatorTemplate
    ], createEnvironmentTemplates(), [
        separatorTemplate,
        versionTemplate,
        chromeVersionTemplate,
        electronVersionTemplate,
    ]),
};
exports.menuItem = new electron_1.MenuItem(menuTemplate);
//# sourceMappingURL=developer.js.map