/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.optimization;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sejda.model.optimization.OptimizationPolicy;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageTree;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizationRuler
implements Function<PDDocument, Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizationRuler.class);
    private OptimizationPolicy policy;

    public OptimizationRuler(OptimizationPolicy policy) {
        RequireUtils.requireNotNullArg((Object)policy, (String)"Optimization policy cannot be null");
        this.policy = policy;
    }

    @Override
    public Boolean apply(PDDocument document) {
        if (this.policy == OptimizationPolicy.YES) {
            return true;
        }
        if (this.policy == OptimizationPolicy.AUTO) {
            return this.willNeedOptimization(document);
        }
        return false;
    }

    private boolean willNeedOptimization(PDDocument document) {
        return this.hasSharedXObjectDictionaries(document) || this.hasSharedFontDictionaries(document) || this.hasInheritedResources(document);
    }

    private boolean hasInheritedResources(PDDocument document) {
        List resources = document.getPages().streamNodes().filter(PDPageTree::isPageTreeNode).map(d -> (COSDictionary)d.getDictionaryObject(COSName.RESOURCES, COSDictionary.class)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        long inheritedImage = resources.stream().map(d -> (COSDictionary)d.getDictionaryObject(COSName.XOBJECT, COSDictionary.class)).filter(Objects::nonNull).flatMap(d -> d.getValues().stream()).map(COSBase::getCOSObject).filter(d -> d instanceof COSDictionary).map(d -> (COSDictionary)d).map(d -> d.getNameAsString(COSName.SUBTYPE)).filter(Objects::nonNull).filter(COSName.IMAGE.getName()::equals).count();
        long inheritedFonts = resources.stream().map(d -> (COSDictionary)d.getDictionaryObject(COSName.FONT, COSDictionary.class)).filter(Objects::nonNull).flatMap(d -> d.getValues().stream()).map(COSBase::getCOSObject).filter(d -> d instanceof COSDictionary).count();
        LOG.debug("Found {} inherited images and {} inherited fonts potentially unused", (Object)inheritedImage, (Object)inheritedFonts);
        return inheritedImage + inheritedFonts > 0L;
    }

    private boolean hasSharedXObjectDictionaries(PDDocument document) {
        List xobjectsDictionaries = document.getPages().stream().map(PDPage::getCOSObject).filter(Objects::nonNull).map(d -> (COSDictionary)d.getDictionaryObject(COSName.RESOURCES, COSDictionary.class)).filter(Objects::nonNull).map(d -> (COSDictionary)d.getDictionaryObject(COSName.XOBJECT, COSDictionary.class)).filter(Objects::nonNull).filter(x -> x.size() > 0).collect(Collectors.toList());
        long distinctXobjectsDictionaries = xobjectsDictionaries.stream().distinct().count();
        if ((long)xobjectsDictionaries.size() > distinctXobjectsDictionaries) {
            LOG.debug("Found shared XObject dictionary containing image resouces");
            return true;
        }
        return false;
    }

    private boolean hasSharedFontDictionaries(PDDocument document) {
        List fontDictionaries = document.getPages().stream().map(PDPage::getCOSObject).filter(Objects::nonNull).map(d -> (COSDictionary)d.getDictionaryObject(COSName.RESOURCES, COSDictionary.class)).filter(Objects::nonNull).map(d -> (COSDictionary)d.getDictionaryObject(COSName.FONT, COSDictionary.class)).filter(Objects::nonNull).filter(x -> x.getValues().stream().map(COSBase::getCOSObject).filter(v -> v instanceof COSDictionary).count() > 0L).collect(Collectors.toList());
        long distinctFontDictionaries = fontDictionaries.stream().distinct().count();
        if ((long)fontDictionaries.size() > distinctFontDictionaries) {
            LOG.debug("Found shared font dictionaries");
            return true;
        }
        return false;
    }
}

