/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.zip.DeflaterInputStream;
import org.sejda.io.SeekableSource;
import org.sejda.model.exception.SejdaRuntimeException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.input.FileSource;
import org.sejda.model.input.Source;
import org.sejda.model.input.SourceDispatcher;
import org.sejda.model.input.StreamSource;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.cos.IndirectCOSObjectIdentifier;
import org.sejda.sambox.pdmodel.graphics.color.PDColorSpace;
import org.sejda.util.IOUtils;
import org.sejda.util.RequireUtils;

public class ReadOnlyFilteredCOSStream
extends COSStream {
    private InputStreamSupplier<InputStream> stream;
    private long length;
    private COSDictionary wrapped;

    ReadOnlyFilteredCOSStream(COSDictionary existingDictionary, InputStream stream, long length) {
        this(existingDictionary, () -> stream, length);
        RequireUtils.requireNotNullArg((Object)stream, (String)"input stream cannot be null");
    }

    public ReadOnlyFilteredCOSStream(COSDictionary existingDictionary, InputStreamSupplier<InputStream> stream, long length) {
        super(Optional.ofNullable(existingDictionary).orElseThrow(() -> new IllegalArgumentException("wrapped dictionary cannot be null")));
        RequireUtils.requireNotNullArg(stream, (String)"input stream provider cannot be null");
        this.stream = stream;
        this.length = length;
        this.wrapped = existingDictionary;
    }

    protected InputStream doGetFilteredStream() throws IOException {
        return this.stream.get();
    }

    public long getFilteredLength() throws IOException {
        RequireUtils.requireIOCondition((this.length >= 0L ? 1 : 0) != 0, (String)"Filtered length cannot be requested");
        return this.length;
    }

    public long getUnfilteredLength() throws IOException {
        throw new IOException("Unfiltered length cannot be requested");
    }

    public InputStream getUnfilteredStream() throws IOException {
        throw new IOException("getUnfilteredStream  cannot be requested");
    }

    public SeekableSource getUnfilteredSource() throws IOException {
        throw new IOException("getUnfilteredSource  cannot be requested");
    }

    public OutputStream createFilteredStream() {
        throw new SejdaRuntimeException("createFilteredStream cannot be called on this stream");
    }

    public OutputStream createFilteredStream(COSBase filters) {
        throw new SejdaRuntimeException("createFilteredStream cannot be called on this stream");
    }

    public void setFilters(COSBase filters) {
        throw new SejdaRuntimeException("setFilters cannot be called on this stream");
    }

    public boolean addCompression() {
        return false;
    }

    public boolean encryptable() {
        return true;
    }

    public void encryptable(boolean encryptable) {
    }

    public OutputStream createUnfilteredStream() {
        throw new SejdaRuntimeException("createUnfilteredStream cannot be called on this stream");
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean indirectLength() {
        return true;
    }

    public void indirectLength(boolean indirectLength) {
    }

    public IndirectCOSObjectIdentifier id() {
        return this.wrapped.id();
    }

    public void idIfAbsent(IndirectCOSObjectIdentifier id) {
        this.wrapped.idIfAbsent(id);
    }

    public void close() throws IOException {
        IOUtils.closeQuietly((Closeable)this.stream.get());
    }

    public static ReadOnlyFilteredCOSStream readOnly(COSStream existing) throws IOException {
        RequireUtils.requireNotNullArg((Object)existing, (String)"input stream cannot be null");
        existing.setEncryptor(null);
        return new ReadOnlyFilteredCOSStream((COSDictionary)existing, () -> existing.getFilteredStream(), existing.getFilteredLength());
    }

    public static ReadOnlyFilteredCOSStream readOnlyJpegImage(File imageFile, int width, int height, int bitsPerComponent, PDColorSpace colorSpace) {
        RequireUtils.requireNotNullArg((Object)imageFile, (String)"input file cannot be null");
        RequireUtils.requireNotNullArg((Object)colorSpace, (String)"color space cannot be null");
        COSDictionary dictionary = new COSDictionary();
        dictionary.setItem(COSName.TYPE, (COSBase)COSName.XOBJECT);
        dictionary.setItem(COSName.SUBTYPE, (COSBase)COSName.IMAGE);
        dictionary.setItem(COSName.FILTER, (COSBase)COSName.DCT_DECODE);
        dictionary.setInt(COSName.BITS_PER_COMPONENT, bitsPerComponent);
        dictionary.setInt(COSName.HEIGHT, height);
        dictionary.setInt(COSName.WIDTH, width);
        Optional.of(colorSpace).map(PDColorSpace::getCOSObject).ifPresent(cs -> dictionary.setItem(COSName.COLORSPACE, cs));
        return new ReadOnlyFilteredCOSStream(dictionary, () -> new FileInputStream(imageFile), imageFile.length());
    }

    public static final ReadOnlyFilteredCOSStream readOnlyEmbeddedFile(Source<?> source) throws TaskIOException {
        final COSDictionary dictionary = new COSDictionary();
        dictionary.setItem(COSName.FILTER, (COSBase)COSName.FLATE_DECODE);
        return (ReadOnlyFilteredCOSStream)((Object)source.dispatch((SourceDispatcher)new SourceDispatcher<ReadOnlyFilteredCOSStream>(){

            public ReadOnlyFilteredCOSStream dispatch(FileSource source) throws TaskIOException {
                try {
                    ReadOnlyFilteredCOSStream retVal = new ReadOnlyFilteredCOSStream(dictionary, new DeflaterInputStream(new FileInputStream(source.getSource())), -1L);
                    retVal.setEmbeddedInt(COSName.PARAMS.getName(), COSName.SIZE, source.getSource().length());
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTimeInMillis(source.getSource().lastModified());
                    retVal.setEmbeddedDate(COSName.PARAMS.getName(), COSName.MOD_DATE, calendar);
                    return retVal;
                }
                catch (FileNotFoundException e) {
                    throw new TaskIOException((Throwable)e);
                }
            }

            public ReadOnlyFilteredCOSStream dispatch(StreamSource source) {
                return new ReadOnlyFilteredCOSStream(dictionary, new DeflaterInputStream(source.getSource()), -1L);
            }
        }));
    }

    @FunctionalInterface
    public static interface InputStreamSupplier<T extends InputStream> {
        public T get() throws IOException;
    }
}

