/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata.location;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.hibernate.validator.metadata.location.ConstraintLocation;
import org.hibernate.validator.util.Contracts;
import org.hibernate.validator.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodConstraintLocation
implements ConstraintLocation {
    private final Method method;
    private final Integer parameterIndex;

    public MethodConstraintLocation(Method method) {
        Contracts.assertNotNull(method, "Method must not be null");
        this.method = method;
        this.parameterIndex = null;
    }

    public MethodConstraintLocation(Method method, int parameterIndex) {
        Contracts.assertNotNull(method, "Method must not be null");
        this.method = method;
        this.parameterIndex = parameterIndex;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.method.getDeclaringClass();
    }

    @Override
    public Type typeOfAnnotatedElement() {
        Type t = null;
        t = this.parameterIndex == null ? ReflectionHelper.typeOf(this.method) : ReflectionHelper.typeOf(this.method, this.parameterIndex);
        if (t instanceof Class && ((Class)t).isPrimitive()) {
            t = ReflectionHelper.boxedType(t);
        }
        return t;
    }

    public Method getMethod() {
        return this.method;
    }

    public Integer getParameterIndex() {
        return this.parameterIndex;
    }

    public String toString() {
        return "MethodConstraintLocation [method=" + this.method + ", parameterIndex=" + this.parameterIndex + "]";
    }
}

