# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.pca_statistics import PCAStatistics


class PPCAStatistics(PCAStatistics):
    """
    PPCAStatistics - A class for parallel principal component analysis
    
    Superclass: PCAStatistics
    
    PPCAStatistics is PCAStatistics subclass for parallel datasets.
    It learns and derives the global statistical model on each node, but
    assesses each individual data points on the node that owns it.
    
    @par Thanks: Thanks to Philippe Pebay, David Thompson and Janine
    Bennett from Sandia National Laboratories for implementing this
    class.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPPCAStatistics, obj, update, **traits)
    
    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        """
        Get/Set the multiprocess controller. If no controller is set,
        single process is assumed.
        """
    )

    _updateable_traits_ = \
    (('median_absolute_deviation', 'GetMedianAbsoluteDeviation'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('basis_scheme', 'GetBasisScheme'), ('fixed_basis_energy',
    'GetFixedBasisEnergy'), ('fixed_basis_size', 'GetFixedBasisSize'),
    ('normalization_scheme', 'GetNormalizationScheme'), ('assess_option',
    'GetAssessOption'), ('derive_option', 'GetDeriveOption'),
    ('learn_option', 'GetLearnOption'), ('number_of_primary_tables',
    'GetNumberOfPrimaryTables'), ('test_option', 'GetTestOption'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'median_absolute_deviation', 'release_data_flag', 'assess_option',
    'basis_scheme', 'derive_option', 'fixed_basis_energy',
    'fixed_basis_size', 'learn_option', 'normalization_scheme',
    'number_of_primary_tables', 'progress_text', 'test_option'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PPCAStatistics, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PPCAStatistics properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['median_absolute_deviation'], [], ['assess_option',
            'basis_scheme', 'derive_option', 'fixed_basis_energy',
            'fixed_basis_size', 'learn_option', 'normalization_scheme',
            'number_of_primary_tables', 'test_option']),
            title='Edit PPCAStatistics properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PPCAStatistics properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

