#ifndef FES_INTERFACE_H
#define FES_INTERFACE_H

typedef int (*solution_callback_t)(void *, uint64_t, uint64_t*);

/* In principe, this function should be the single entry point to the library 
   The input format is explicit, except for the coefficients of the equations. 
   coeffs[e][d][m] = coefficient of the m-th monomial of degree d in the e-th equation
   the monomials of each degree are assumed to be in invlex order (i.e. in lex order with reversed variables)
*/
void exhaustive_search_wrapper(const int n, int n_eqs, const int degree, int ***coeffs, solution_callback_t callback, void* callback_state, int verbose, int);

#endif
